/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.cert.utils;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class SMUtil {
    public static final String SOURCES = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890";

    public static String gen16SM4Key() {
        return SMUtil.genRandomString(new SecureRandom(), SOURCES, 16);
    }

    public static String genSM4EncryptKey(String sm4Key, String bankPublicKey) {
        try {
            return Base64.getEncoder().encodeToString(SMUtil.CMBSM2Encrypt(Base64.getDecoder().decode(bankPublicKey), sm4Key.getBytes("utf-8")));
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5bf9SM\u79d8\u94a5\u52a0\u5bc6\u5931\u8d25\uff1a", (String)"SMUtil_0", (String)"ebg-aqap-business", (Object[])new Object[0]), (String)ex.getMessage(), (Throwable)ex);
        }
    }

    public static String genRandomString(SecureRandom random, String characters, int len) {
        char[] text = new char[len];
        for (int i = 0; i < len; ++i) {
            text[i] = characters.charAt(random.nextInt(characters.length()));
        }
        return new String(text);
    }

    public static Map CMBSM2KeyGen() {
        ECDomainParameters domainParameters = SMUtil.getECDomainParameters();
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        ECKeyGenerationParameters parameters = new ECKeyGenerationParameters(domainParameters, new SecureRandom());
        generator.init((KeyGenerationParameters)parameters);
        AsymmetricCipherKeyPair keyPair = generator.generateKeyPair();
        ECPublicKeyParameters publicKeyParameters = (ECPublicKeyParameters)keyPair.getPublic();
        ECPrivateKeyParameters privateKeyParameters = (ECPrivateKeyParameters)keyPair.getPrivate();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("publickey", publicKeyParameters.getQ().getEncoded(false));
        map.put("privatekey", SMUtil.format(privateKeyParameters.getD().toByteArray()));
        return map;
    }

    private static Object format(byte[] value) {
        if (value.length == 32) {
            return value;
        }
        byte[] bytes = new byte[32];
        if (value.length > 32) {
            System.arraycopy(value, value.length - 32, bytes, 0, 32);
        } else {
            System.arraycopy(value, 0, bytes, 32 - value.length, value.length);
        }
        return bytes;
    }

    private static ECDomainParameters getECDomainParameters() {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)"sm2p256v1");
        return new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN(), spec.getH(), spec.getSeed());
    }

    private static ECPublicKeyParameters encodePublicKey(byte[] value) {
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        System.arraycopy(value, 1, x, 0, 32);
        System.arraycopy(value, 33, y, 0, 32);
        BigInteger X = new BigInteger(1, x);
        BigInteger Y = new BigInteger(1, y);
        ECPoint Q = SMUtil.getSM2Curve().createPoint(X, Y);
        return new ECPublicKeyParameters(Q, SMUtil.getECDomainParameters());
    }

    private static ECCurve getSM2Curve() {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)"sm2p256v1");
        return spec.getCurve();
    }

    public static byte[] CMBSM2Encrypt(byte[] pubkey, byte[] msg) throws Exception {
        ECPublicKeyParameters publicKey = null;
        publicKey = SMUtil.encodePublicKey(pubkey);
        SM2Engine engine = new SM2Engine();
        engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKey, new SecureRandom()));
        byte[] cipherText = engine.processBlock(msg, 0, msg.length);
        return SMUtil.C1C2C3ToC1C3C2(cipherText);
    }

    public static byte[] CMBSM2Decrypt(byte[] privkey, byte[] msg) throws Exception {
        msg = SMUtil.C1C3C2ToC1C2C3(msg);
        ECPrivateKeyParameters privateKey = null;
        privateKey = SMUtil.encodePrivateKey(privkey);
        SM2Engine engine = new SM2Engine();
        engine.init(false, (CipherParameters)privateKey);
        return engine.processBlock(msg, 0, msg.length);
    }

    private static ECPrivateKeyParameters encodePrivateKey(byte[] value) {
        BigInteger d = new BigInteger(1, value);
        return new ECPrivateKeyParameters(d, SMUtil.getECDomainParameters());
    }

    private static byte[] C1C2C3ToC1C3C2(byte[] cipherText) throws Exception {
        if (cipherText == null || cipherText.length < 97) {
            throw new Exception("E10406");
        }
        byte[] bytes = new byte[cipherText.length];
        System.arraycopy(cipherText, 0, bytes, 0, 65);
        System.arraycopy(cipherText, cipherText.length - 32, bytes, 65, 32);
        System.arraycopy(cipherText, 65, bytes, 97, cipherText.length - 97);
        return bytes;
    }

    private static byte[] C1C3C2ToC1C2C3(byte[] cipherText) throws Exception {
        if (cipherText == null || cipherText.length < 97) {
            throw new Exception("E10406");
        }
        byte[] bytes = new byte[cipherText.length];
        System.arraycopy(cipherText, 0, bytes, 0, 65);
        System.arraycopy(cipherText, 97, bytes, 65, cipherText.length - 97);
        System.arraycopy(cipherText, 65, bytes, cipherText.length - 32, 32);
        return bytes;
    }
}

