/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.codeless.parser;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.credit.EBGCreditUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.egf.common.codeless.PackerUtil.CodeLessUtil;
import kd.ebg.egf.common.codeless.PackerUtil.ResponseCode;
import kd.ebg.egf.common.codeless.ParserUtil.ParseUtil;
import kd.ebg.egf.common.codeless.ParserUtil.ParserToMapUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ParseCreditOpenUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ParseCreditOpenUtil.class);

    public static List<OpenCreditDetail> parseCreditOpen(List<OpenCreditDetail> openCreditDetails, String rspStr) throws Exception {
        logger.info("\u4f4e\u4ee3\u7801\u6846\u67b6\u5f00\u59cb\u8fdb\u884c\u6570\u636e\u89e3\u6790\uff1a");
        ResponseCode responseCode = CodeLessUtil.getResponseCodeNode((String)rspStr);
        logger.info("\u4f4e\u4ee3\u7801\u6846\u67b6\u4ea4\u4e92\u54cd\u5e94\u7801\u89e3\u6790\u5b8c\u6bd5\uff0c" + responseCode.getCode() + "," + responseCode.getMsg());
        String outResult = ParseUtil.getResult((ResponseCode)responseCode, null, null, (String)"CREDIT");
        if (StringUtils.isEmpty((String)outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u7a7a");
            EBGCreditUtils.setPaymentState(openCreditDetails, PaymentState.UNKNOWN, "", "");
            return openCreditDetails;
        }
        if ("SUCCESS".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u6210\u529f");
            EBGCreditUtils.setPaymentState(openCreditDetails, PaymentState.SUCCESS, responseCode.getCode(), responseCode.getMsg());
            return openCreditDetails;
        }
        if ("FAIL".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u5931\u8d25");
            EBGCreditUtils.setPaymentState(openCreditDetails, PaymentState.FAIL, responseCode.getCode(), responseCode.getMsg());
            return openCreditDetails;
        }
        if ("UNKNOWN".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u672a\u77e5");
            EBGCreditUtils.setPaymentState(openCreditDetails, PaymentState.UNKNOWN, responseCode.getCode(), responseCode.getMsg());
            return openCreditDetails;
        }
        if ("ERROR".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u5f02\u5e38");
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u4e92\u54cd\u5e94\u7801\u5f02\u5e38%1$s %2$s %3$s", (String)"ParseCreditOpenUtil_0", (String)"ebg-aqap-business", (Object[])new Object[0]), responseCode.getCode(), responseCode.getMsg(), outResult));
        }
        if ("SUBMITED".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u5904\u7406\u4e2d");
            EBGCreditUtils.setPaymentState(openCreditDetails, PaymentState.SUBMITED, responseCode.getCode(), responseCode.getMsg());
            for (OpenCreditDetail detail : openCreditDetails) {
                ParseCreditOpenUtil.reloadData(detail, rspStr);
            }
            return openCreditDetails;
        }
        if ("MIDDLE".equals(outResult)) {
            return ParseCreditOpenUtil.getInnerResult(openCreditDetails, rspStr);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5f00\u8bc1\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a%s", (String)"ParseCreditOpenUtil_1", (String)"ebg-aqap-business", (Object[])new Object[0]), outResult + responseCode.getCode() + "," + responseCode.getMsg()));
    }

    private static OpenCreditDetail reloadData(OpenCreditDetail detail, String rspStr) {
        Map needParam = CodeLessUtil.getNeedParamPath();
        Set set2 = needParam.keySet();
        set2.stream().forEach(key -> {
            if ("bankRefDate".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("bankRefDate")));
                detail.setBankRefDate(value);
            } else if ("bankRefKey".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("bankRefKey")));
                detail.setBankRefKey(value);
            } else if ("reserved1".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("reserved1")));
                detail.setReserved1(value);
            } else if ("reserved2".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("reserved2")));
                detail.setReserved2(value);
            } else if ("creditNo".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("reserved2")));
                detail.setCreditNo(value);
            }
        });
        return detail;
    }

    private static List<OpenCreditDetail> getInnerResult(List<OpenCreditDetail> details, String rspStr) throws Exception {
        if (details.get(0).getBankBatchCount() == 1 || !ParseUtil.isBatchParser()) {
            logger.info("\u5355\u7b14\u4ea4\u6613\u5904\u7406\u4ea4\u6613\u7ed3\u679c");
            return ParseCreditOpenUtil.dealSingle(details, rspStr);
        }
        logger.info("\u6279\u91cf\u4ea4\u6613\u9010\u7b14\u5904\u7406\u4ea4\u6613\u7ed3\u679c");
        return ParseCreditOpenUtil.dealBatch(details, rspStr);
    }

    private static List<OpenCreditDetail> dealSingle(List<OpenCreditDetail> openCreditDetails, String rspStr) throws Exception {
        ResponseCode responseCode = ParseUtil.getInnerCode((String)rspStr, (String)"CREDIT");
        String outResult = responseCode.getResult();
        if (StringUtils.isEmpty((String)outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u7a7a\uff0c\u7f6e\u4e3a\u4ea4\u6613\u7ed3\u679c\u672a\u77e5");
            EBGCreditUtils.setPaymentState(openCreditDetails, PaymentState.UNKNOWN, responseCode.getCode(), responseCode.getMsg());
            return openCreditDetails;
        }
        for (OpenCreditDetail notePayableInfo : openCreditDetails) {
            ParseCreditOpenUtil.reloadData(notePayableInfo, rspStr);
        }
        if ("SUCCESS".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u6210\u529f");
            EBGCreditUtils.setPaymentState(openCreditDetails, PaymentState.SUCCESS, responseCode.getCode(), responseCode.getMsg());
            return openCreditDetails;
        }
        if ("FAIL".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u5931\u8d25");
            EBGCreditUtils.setPaymentState(openCreditDetails, PaymentState.FAIL, responseCode.getCode(), responseCode.getMsg());
            return openCreditDetails;
        }
        if ("UNKNOWN".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u672a\u77e5");
            EBGCreditUtils.setPaymentState(openCreditDetails, PaymentState.UNKNOWN, responseCode.getCode(), responseCode.getMsg());
            return openCreditDetails;
        }
        if ("SUBMITED".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u5904\u7406\u4e2d");
            EBGCreditUtils.setPaymentState(openCreditDetails, PaymentState.SUBMITED, responseCode.getCode(), responseCode.getMsg());
            return openCreditDetails;
        }
        if ("ERROR".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u5f02\u5e38");
            EBGCreditUtils.setPaymentState(openCreditDetails, PaymentState.UNKNOWN, responseCode.getCode(), responseCode.getMsg());
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u4e92\u54cd\u5e94\u7801\u5f02\u5e38%1$s %2$s %3$s", (String)"ParseCreditOpenUtil_0", (String)"ebg-aqap-business", (Object[])new Object[0]), responseCode.getCode(), responseCode.getMsg(), outResult));
        }
        logger.error("\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a" + outResult);
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a%s", (String)"ParseCreditOpenUtil_2", (String)"ebg-aqap-business", (Object[])new Object[0]), outResult));
    }

    private static List<OpenCreditDetail> dealBatch(List<OpenCreditDetail> details, String rspStr) throws Exception {
        logger.info("\u4f4e\u4ee3\u7801\u5e73\u53f0\u6279\u91cf\u89e3\u6790\u5f00\u59cb");
        List eachData = ParseUtil.getRepeaterData((String)rspStr);
        Map map = CodeLessUtil.getNeedParam();
        Map mapMatch = CodeLessUtil.getMatchParam();
        for (OpenCreditDetail detail : details) {
            Boolean isMatch = false;
            Field[] fields = detail.getClass().getDeclaredFields();
            Map result = ParserToMapUtil.getCommonMap((Field[])fields, (String)"yyyyMMdd", (Object)detail);
            for (Map each : eachData) {
                if (!ParseUtil.judgeMatch((Map)mapMatch, (Map)each, (Map)result)) continue;
                String inner_code = (String)each.get(map.get("inner_code"));
                String inner_code2 = (String)each.get(map.get("inner_code2"));
                String msg = (String)each.get(map.get("inner_msg"));
                ResponseCode responseCode = new ResponseCode();
                if (inner_code2 != null) {
                    responseCode.setCode(inner_code + inner_code2);
                } else {
                    responseCode.setCode(inner_code);
                }
                responseCode.setMsg(msg);
                String outResult = ParseUtil.getResult(null, (String)inner_code, (String)inner_code2, (String)"CREDIT");
                ParseCreditOpenUtil.dealSingleResult(detail, outResult, responseCode);
                ParseCreditOpenUtil.reloadData(detail, each, map);
                isMatch = true;
                break;
            }
            if (isMatch.booleanValue()) continue;
            EBGCreditUtils.setPaymentState(detail, PaymentState.UNKNOWN, "", ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u8be5\u6570\u636e\uff0c\u8bf7\u4eba\u5de5\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c", (String)"ParseCreditOpenUtil_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        return details;
    }

    private static void dealSingleResult(OpenCreditDetail detail, String outResult, ResponseCode responseCode) throws Exception {
        if (StringUtils.isEmpty((String)outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u7a7a\uff0c\u7f6e\u4e3a\u4ea4\u6613\u7ed3\u679c\u672a\u77e5" + detail.getBankDetailSeqId());
            EBGCreditUtils.setPaymentState(detail, PaymentState.UNKNOWN, responseCode.getCode(), responseCode.getMsg());
            return;
        }
        if ("SUCCESS".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u6210\u529f," + detail.getBankDetailSeqId());
            EBGCreditUtils.setPaymentState(detail, PaymentState.SUCCESS, responseCode.getCode(), responseCode.getMsg());
        } else if ("FAIL".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u5931\u8d25," + detail.getBankDetailSeqId());
            EBGCreditUtils.setPaymentState(detail, PaymentState.FAIL, responseCode.getCode(), responseCode.getMsg());
        } else if ("UNKNOWN".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u672a\u77e5," + detail.getBankDetailSeqId());
            EBGCreditUtils.setPaymentState(detail, PaymentState.UNKNOWN, responseCode.getCode(), responseCode.getMsg());
        } else if ("SUBMITED".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u5904\u7406\u4e2d," + detail.getBankDetailSeqId());
            EBGCreditUtils.setPaymentState(detail, PaymentState.SUBMITED, responseCode.getCode(), responseCode.getMsg());
        } else {
            if ("ERROR".equals(outResult)) {
                logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u5f02\u5e38," + detail.getBankDetailSeqId());
                EBGCreditUtils.setPaymentState(detail, PaymentState.UNKNOWN, responseCode.getCode(), responseCode.getMsg());
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u4e92\u54cd\u5e94\u7801\u5f02\u5e38%1$s %2$s %3$s", (String)"ParseCreditOpenUtil_0", (String)"ebg-aqap-business", (Object[])new Object[0]), responseCode.getCode(), responseCode.getMsg(), outResult));
            }
            logger.error("\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a" + outResult);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a%s", (String)"ParseCreditOpenUtil_2", (String)"ebg-aqap-business", (Object[])new Object[0]), outResult));
        }
    }

    private static OpenCreditDetail reloadData(OpenCreditDetail detail, Map eachData, Map reflect) {
        Set set2 = reflect.keySet();
        set2.stream().forEach(key -> {
            if ("bankRefDate".equals(key)) {
                String value = (String)eachData.get(reflect.get("bankRefDate"));
                if (StringUtils.isNotEmpty((String)value)) {
                    value = value.replaceAll("-", "");
                }
                detail.setBankRefDate(value);
            } else if ("bankRefKey".equals(key)) {
                String value = (String)eachData.get(reflect.get("bankRefKey"));
                detail.setBankRefKey(value);
            } else if ("creditNo".equals(key)) {
                String value = (String)eachData.get(reflect.get("creditNo"));
                detail.setCreditNo(value);
            } else if ("busAmt".equals(key)) {
                String value = (String)eachData.get(reflect.get("busAmt"));
                if (StringUtils.isNotEmpty((String)value)) {
                    detail.setBusAmt(new BigDecimal(value));
                }
            } else if ("busCurrency".equals(key)) {
                String value = (String)eachData.get(reflect.get("busCurrency"));
                detail.setBusCurrency(value);
            } else if ("refusePoint".equals(key)) {
                String value = (String)eachData.get(reflect.get("refusePoint"));
                detail.setRefusePoint(value);
            } else if ("charFeeInfo".equals(key)) {
                String value = (String)eachData.get(reflect.get("charFeeInfo"));
                detail.setCharFeeInfo(value);
            }
        });
        return detail;
    }
}

