/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.codeless.parser;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.codeless.packer.BussinessToMap;
import kd.ebg.aqap.business.codeless.parser.ParserUtil;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.codeless.PackerUtil.CodeLessUtil;
import kd.ebg.egf.common.codeless.PackerUtil.ResponseCode;
import kd.ebg.egf.common.codeless.ParserUtil.MapToObjectUtil;
import kd.ebg.egf.common.codeless.ParserUtil.ParseUtil;
import kd.ebg.egf.common.codeless.dateUtil.LocalDateTimeUtil;
import kd.ebg.egf.common.codeless.dateUtil.LocalDateUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ParseDetailUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ParseDetailUtil.class);

    public static List<DetailInfo> parseDetail(BankDetailRequest request, String rspStr, String dateStr, boolean isRequestAccno) throws Exception {
        String outResult = ParserUtil.getOuterResultError(rspStr, "QUERY");
        if ("MIDDLE".equals(outResult)) {
            return ParseDetailUtil.getInnerResult(request, rspStr, dateStr, isRequestAccno);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a%s", (String)"ParseCreditUtil_0", (String)"ebg-aqap-business", (Object[])new Object[0]), outResult));
    }

    public static List<DetailInfo> getInnerResult(BankDetailRequest request, String rspStr, String dateStr, boolean isRequestAccno) throws Exception {
        ResponseCode responseCode;
        String outResult;
        logger.info("\u4f4e\u4ee3\u7801\u5e73\u53f0\u6279\u91cf\u89e3\u6790\u5f00\u59cb");
        boolean isneedInnr = ParseUtil.isNeedInner();
        if (isneedInnr && "FAIL".equals(outResult = (responseCode = ParseUtil.getInnerCode((String)rspStr, (String)"QUERY")).getResult())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a%s", (String)"ParseCreditUtil_0", (String)"ebg-aqap-business", (Object[])new Object[0]), outResult));
        }
        List eachData = ParseUtil.getRepeaterDataWithAttr((String)rspStr);
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(1);
        if (eachData == null || eachData.size() == 0) {
            return details;
        }
        List<Map<String, String>> sourceDate = BussinessToMap.getMapDetail(request, "yyyyMMdd");
        Map map = CodeLessUtil.getNeedParam();
        for (Map objectMap : eachData) {
            Map jsonMap;
            boolean isPasss = ParseUtil.isPassing((Map)objectMap, sourceDate.get(0));
            if (isPasss) continue;
            DetailInfo detail = new DetailInfo();
            ParseDetailUtil.reloadData(detail, objectMap, map, sourceDate.get(0));
            if (isRequestAccno) {
                detail.setAccNo(request.getAcnt().getAccNo());
                detail.setAccName(request.getAcnt().getAccName());
            }
            if ((jsonMap = (Map)objectMap.get("jsonMap")) != null) {
                String jsonString = JSON.toJSONString((Object)jsonMap);
                detail.setJsonMap(jsonString);
            }
            details.add(detail);
        }
        return details;
    }

    private static DetailInfo reloadData(DetailInfo detailInfo, Map eachData, Map reflect, Map request) throws Exception {
        Map result = MapToObjectUtil.coventMap((Map)eachData, (Map)reflect);
        Map judge = ParseUtil.getParseResultMap((Map)eachData, (Map)request);
        result.putAll(judge);
        ParseDetailUtil.reloadData(detailInfo, result);
        return detailInfo;
    }

    private static DetailInfo reloadData(DetailInfo detailInfo, Map eachData) {
        Set set2 = eachData.keySet();
        set2.stream().forEach(key -> {
            if ("debitAmount".equals(key)) {
                String value = (String)eachData.get(key);
                if (StringUtils.isEmpty((String)value)) {
                    detailInfo.setDebitAmount(new BigDecimal("0"));
                } else {
                    detailInfo.setDebitAmount(new BigDecimal(value));
                }
            } else if ("creditAmount".equals(key)) {
                String value = (String)eachData.get(key);
                if (StringUtils.isEmpty((String)value)) {
                    detailInfo.setCreditAmount(new BigDecimal("0"));
                } else {
                    detailInfo.setCreditAmount(new BigDecimal(value));
                }
            } else if ("accNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setAccNo(value);
            } else if ("bankName".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setBankName(value);
            } else if ("currency".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setCurrency(value);
            } else if ("oppAccNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setOppAccNo(value);
            } else if ("oppBankName".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setOppBankName(value);
            } else if ("oppAccName".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setOppAccName(value);
            } else if ("balance".equals(key)) {
                String value = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value)) {
                    detailInfo.setBalance(new BigDecimal(value));
                }
            } else if ("transDate".equals(key)) {
                String value = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value)) {
                    detailInfo.setTransDate(LocalDateUtil.tryParse((String)value));
                }
            } else if ("detailDateTime".equals(key)) {
                String value = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value)) {
                    detailInfo.setTransTime(LocalDateTimeUtil.tryParse((String)value));
                }
            } else if ("bankDetailNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setBankDetailNo(value);
            } else if ("bizRefNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setBizRefNo(value);
            } else if ("agentAccNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setAgentAccNo(value);
            } else if ("agentAccName".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setAgentAccName(value);
            } else if ("agentAccBankName".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setAgentAccBankName(value);
            } else if ("vouhNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setVouhNo(value);
            } else if ("payBankDetailSeqID".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setPayBankDetailSeqID(value);
            } else if ("receiptNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setReceiptNo(value);
            } else if ("transferCharge".equals(key)) {
                String value = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value)) {
                    detailInfo.setTransferCharge(new BigDecimal(value));
                }
            } else if ("extraAccNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setExtraAccNo(value);
            } else if ("frmcod".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setFrmcod(value);
            } else if ("kdFlag".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setKdFlag(value);
            } else if ("explanation".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setExplanation(value);
            }
        });
        return detailInfo;
    }
}

