/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.credit.openCredit.Task;

import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.codeless.CodeLessRouteAqapUtil;
import kd.ebg.aqap.business.credit.EBGCreditUtils;
import kd.ebg.aqap.business.credit.openCredit.atomic.CodelessOpenCreditImpl;
import kd.ebg.aqap.business.credit.openCredit.atomic.IQueryOpenCredit;
import kd.ebg.aqap.business.credit.openCredit.bank.BankOpenCreditDetailRequest;
import kd.ebg.aqap.business.credit.openCredit.bank.BankOpenCreditDetailResponse;
import kd.ebg.aqap.business.payment.cache.CacheQueryPayStorage;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.OpenCreditService;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.codeless.CodeLessRoute;
import kd.ebg.egf.common.model.codeless.RouteBody;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class BankQueryOpenCreditTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankQueryOpenCreditTask.class);
    private BankOpenCreditDetailRequest request;
    private EBContext context;
    private static final int QUERY_PAY_INTERVAL_MINUTES = 1;

    public BankQueryOpenCreditTask(BankOpenCreditDetailRequest request, EBContext context) {
        this.request = request;
        this.context = context;
    }

    public Object doBiz() {
        BankOpenCreditDetailResponse response = this.submitQueryNotePayable(this.request, this.context);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BankOpenCreditDetailResponse submitQueryNotePayable(BankOpenCreditDetailRequest request, EBContext context) {
        String bizSeqID = Sequence.gen18Sequence();
        if (StringUtils.isEmpty((String)request.getHeader().getBizSeqID())) {
            request.getHeader().setBizSeqID(bizSeqID);
        }
        String customId = request.getHeader().getCustomerID();
        String batchSeqID = request.getBankBatchSeqID();
        String key = customId + batchSeqID + "openCreditQuery";
        try {
            BankOpenCreditDetailResponse response;
            FEPAccess access;
            List<OpenCreditDetail> result;
            block26: {
                LocalDateTime lastQueryTime;
                if (CacheQueryPayStorage.checkRepeatQuery(key)) {
                    BankOpenCreditDetailResponse response2 = new BankOpenCreditDetailResponse(request.getDetails());
                    response2.setHeader(request.getHeader());
                    BankOpenCreditDetailResponse bankOpenCreditDetailResponse = response2;
                    return bankOpenCreditDetailResponse;
                }
                context.setBizName("openCreditQuery");
                MDCUtil.clearBussinessMDC();
                MDCUtil.initMDC((EBContext)context);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                this.logger.infoIndex("\u5f00\u59cb\u8fdb\u884c\u540c\u6b65\u4e1a\u52a1\u5904\u7406,{}", (Object)bizSeqID);
                EBContext.setContext((EBContext)context);
                List<OpenCreditDetail> openCreditDetails = request.getDetails();
                if (openCreditDetails.isEmpty()) {
                    BankOpenCreditDetailResponse bankOpenCreditDetailResponse = null;
                    return bankOpenCreditDetailResponse;
                }
                this.logger.info("\u5f00\u8bc1\u540c\u6b65\u5f00\u59cb\u5904\u7406,\u94f6\u884c\u6279\u6b21\u53f7\uff1a{}, \u8be5\u6279\u6b21\u6570\u91cf\u4e3a\uff1a{},\u4e1a\u52a1\u7aef\u6279\u6b21\u53f7\uff1a{}", new Object[]{request.getDetails().get(0).getBankBatchSeqId(), request.getDetails().size(), request.getDetails().get(0).getBatchSeqId()});
                PaymentState state = PaymentState.getEnumById((int)openCreditDetails.get(0).getStatus());
                if (PaymentState.PACKAGED == state || PaymentState.INITIAL == state) {
                    this.logger.info("\u5f53\u524d\u4fe1\u606f\u8fd8\u672a\u63d0\u4ea4\u5230\u94f6\u884c\uff0c\u4e0d\u5141\u8bb8\u4ece\u94f6\u884c\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001");
                    BankOpenCreditDetailResponse bankOpenCreditDetailResponse = null;
                    return bankOpenCreditDetailResponse;
                }
                String reserved1 = request.getForceQuery();
                if (!"1".equals(reserved1) && Objects.nonNull(lastQueryTime = openCreditDetails.get(0).getLastSyncTime()) && LocalDateTime.now().plusMinutes(-1L).isBefore(lastQueryTime)) {
                    this.logger.info("1\u5206\u949f\u5185\u5df2\u7ecf\u4ece\u94f6\u884c\u540c\u6b65\u8fc7\u4e86,\u672c\u6b21\u4e0d\u518d\u4ece\u94f6\u884c\u67e5\u8be2");
                    BankOpenCreditDetailResponse bankOpenCreditDetailResponse = null;
                    return bankOpenCreditDetailResponse;
                }
                result = null;
                String bankVersionID = context.getBankVersionID();
                String implClassName = openCreditDetails.get(0).getQueryImplClassName();
                EBGCreditUtils.setPaymentUpdateTimeAndStatus(openCreditDetails, LocalDateTime.now());
                request.setDetails(openCreditDetails);
                access = null;
                response = null;
                try {
                    EBContext.initParameter();
                    if (implClassName.contains("codelessRoute=")) {
                        String subBizType = openCreditDetails.get(0).getSubBizType();
                        String bankVersionId = EBContext.getContext().getBankVersionID();
                        CodeLessRoute codeLessRoute = CodeLessRouteAqapUtil.getCodelessRouteCredit(bankVersionId, subBizType);
                        List routeBodies = codeLessRoute.getRouteBodiesQuery();
                        if (routeBodies == null || routeBodies.size() == 0) {
                            EBGCreditUtils.setPaymentState(request.getDetails(), PaymentState.UNKNOWN, ResManager.loadKDString((String)"\u65e0\u4ee3\u7801\u8def\u7531\u7ed3\u6784\u5f02\u5e38\uff0c\u65e0\u6cd5\u5904\u7406\u4e1a\u52a1", (String)"BankQueryOpenCreditTask_0", (String)"ebg-aqap-business", (Object[])new Object[0]), "", String.format(ResManager.loadKDString((String)"\u65e0\u4ee3\u7801\u8def\u7531\u7ed3\u6784\u5f02\u5e38\uff0c\u65e0\u6cd5\u5904\u7406\u4e1a\u52a1\uff0c\u94f6\u4f01\u4e91\u5c06\u4ea4\u6613\u72b6\u6001\u7f6e\u4e3a\u4ea4\u6613\u672a\u77e5\uff0c\u8bf7\u68c0\u67e5\u8def\u7531\u914d\u7f6e\uff1a%s", (String)"BankQueryOpenCreditTask_1", (String)"ebg-aqap-business", (Object[])new Object[0]), codeLessRoute.getNumber()));
                        } else {
                            this.logger.info("\u94f6\u884c\u8def\u7531\u7f16\u53f7\u4e3a\uff1a{}", (Object)codeLessRoute.getNumber());
                            EBContext.initParameter();
                            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                            access = FEPAccessUtil.access((String)bankVersionID, (String)context.getBankLoginID());
                            CodelessOpenCreditImpl impl = new CodelessOpenCreditImpl();
                            response = impl.doBiz(request, (RouteBody)routeBodies.get(0), 0);
                        }
                    } else {
                        MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                        IQueryOpenCredit queryOpenCredit = (IQueryOpenCredit)BankBundleManager.getInstance().getImplByClassName(bankVersionID, IQueryOpenCredit.class, implClassName);
                        access = FEPAccessUtil.access((String)bankVersionID, (String)context.getBankLoginID());
                        this.logger.info("\u83b7\u53d6\u5230\u524d\u7f6e\u673a\u9501");
                        response = queryOpenCredit.queryPay(request);
                    }
                    if (Objects.nonNull(EBContext.getContext().getThrowableAfterSend())) {
                        EBGCreditUtils.setPaymentState(request.getDetails(), PaymentState.UNKNOWN, ResManager.loadKDString((String)"\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38,\u7ed3\u679c\u672a\u77e5,\u8bf7\u540c\u6b65\u7ed3\u679c", (String)"BankQueryOpenCreditTask_2", (String)"ebg-aqap-business", (Object[])new Object[0]), "", "");
                        break block26;
                    }
                    Preconditions.checkState((boolean)Objects.nonNull((Object)response), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u5bf9\u8c61\u4e0d\u80fd\u4e3anull", (String)"BankQueryOpenCreditTask_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    if (response == null) break block26;
                    Preconditions.checkState((boolean)Objects.nonNull(response.getDetails()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u4e0d\u80fd\u4e3anull", (String)"BankQueryOpenCreditTask_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    result = response.getDetails();
                }
                catch (Exception e) {
                    try {
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        EBGCreditUtils.setPaymentState(request.getDetails(), PaymentState.UNKNOWN, ResManager.loadKDString((String)"\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38,\u7ed3\u679c\u672a\u77e5,\u8bf7\u540c\u6b65\u7ed3\u679c", (String)"BankQueryOpenCreditTask_2", (String)"ebg-aqap-business", (Object[])new Object[0]), "", "");
                        this.logger.error("\u540c\u6b65\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", new Object[]{e.getMessage()});
                        this.logger.error(EBExceiptionUtil.stackTraceString((StackTraceElement[])e.getStackTrace()));
                    }
                    catch (Throwable throwable) {
                        FEPAccessUtil.release(access);
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        throw throwable;
                    }
                    FEPAccessUtil.release((FEPAccess)access);
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                }
            }
            FEPAccessUtil.release((FEPAccess)access);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            LocalDateTime queryTime = LocalDateTime.now();
            if (result != null) {
                result.forEach(info -> {
                    info.setLastSyncTime(queryTime);
                    info.setSyncCount(Integer.valueOf(Integer.parseInt(Objects.toString(info.getSyncCount(), "0")) + 1));
                    info.setPayFinishTime(LocalDateTime.now());
                });
            }
            OpenCreditService service = OpenCreditService.getInstance();
            if (result != null) {
                service.save(result, false);
            } else {
                result = request.getDetails();
                service.save(result, false);
            }
            response = new BankOpenCreditDetailResponse(result);
            response.setHeader(request.getHeader());
            BankOpenCreditDetailResponse bankOpenCreditDetailResponse = response;
            return bankOpenCreditDetailResponse;
        }
        catch (Throwable e) {
            this.logger.error("BankQueryOpenCreditTask error", e);
            BankOpenCreditDetailResponse bankOpenCreditDetailResponse = null;
            return bankOpenCreditDetailResponse;
        }
        finally {
            CacheQueryPayStorage.releaseKey(key);
        }
    }
}

