/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.currentandfixed;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.currentandfixed.QueryCurAndFixedBizType;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.business.currentandfixed.cache.CacheQueryCafStorage;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.business.currentandfixed.util.CurAndFixedConvert;
import kd.ebg.aqap.common.entity.biz.querycurandfixed.QueryCurAndFixedReqBody;
import kd.ebg.aqap.common.entity.biz.querycurandfixed.QueryCurAndFixedRequest;
import kd.ebg.aqap.common.entity.biz.querycurandfixed.QueryCurAndFixedResponse;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.framework.services.CurAndFixedService;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import org.slf4j.MDC;

public class QueryCurAndFixedMethod
implements EBServiceMethod<QueryCurAndFixedRequest, QueryCurAndFixedResponse> {
    EBGLogger logger = EBGLogger.getInstance().getLogger(QueryCurAndFixedMethod.class);

    public QueryCurAndFixedResponse executeClientRequest(QueryCurAndFixedRequest queryCurAndFixedRequest, EBContext ebContext) throws MalformedURLException {
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        BankCurAndFixedRequest bankCurAndFixedRequest = new BankCurAndFixedRequest();
        QueryCurAndFixedReqBody body = queryCurAndFixedRequest.getBody();
        EBHeader header = queryCurAndFixedRequest.getHeader();
        Preconditions.checkArgument((boolean)QueryCurAndFixedBizType.isExistBiz(header.getSubBizType()), (Object)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"QueryCurAndFixedMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        BankHeader bankHeader = new BankHeader();
        bankHeader.setSubBizType(header.getSubBizType());
        bankCurAndFixedRequest.setHeader(bankHeader);
        String batchSeqId = body.getBatchSeqId();
        this.logger.info("\u83b7\u53d6\u5230\u6279\u6b21\u6d41\u6c34\u53f7{}", (Object)batchSeqId);
        bankCurAndFixedRequest.setBatchBizNo(batchSeqId);
        bankCurAndFixedRequest.setBatchSeqId(body.getDetailSeqID());
        CurAndFixedService service = CurAndFixedService.getInstance();
        List curAndFixedInfos = service.selectByBatchSeqID(batchSeqId);
        if (curAndFixedInfos.isEmpty()) {
            throw EBExceiptionUtil.preCheckException((String)"unknow_batch", (String)String.format(ResManager.loadKDString((String)"\u67e5\u65e0\u6279\u6b21\u53f7%s\u3002", (String)"QueryCurAndFixedMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]), batchSeqId));
        }
        String customId = queryCurAndFixedRequest.getHeader().getCustomId();
        String key = customId + batchSeqId;
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        ebBankCurAndFixedResponse.setDetails(curAndFixedInfos);
        EBContext.initParameter();
        if (!CacheQueryCafStorage.checkRepeat(key)) {
            try {
                boolean isHasSubmmting = curAndFixedInfos.stream().anyMatch(info -> info.getStatus().intValue() == CurAndFixedState.SUBMITTING.getId());
                if (isHasSubmmting) {
                    LocalDateTime submitSuccessTime = ((CurAndFixedInfo)curAndFixedInfos.get(0)).getSubmitSuccessTime();
                    Duration duration = Duration.between(submitSuccessTime, LocalDateTime.now());
                    long minutes = duration.toMinutes();
                    if (minutes > 20L) {
                        for (CurAndFixedInfo curAndFixedInfo : curAndFixedInfos) {
                            curAndFixedInfo.setStatus(Integer.valueOf(CurAndFixedState.UNKNOWN.getId()));
                            curAndFixedInfo.setStatusName(CurAndFixedState.UNKNOWN.getEnName());
                            curAndFixedInfo.setStatusMsg(CurAndFixedState.UNKNOWN.getCnName());
                        }
                        Set<List<CurAndFixedInfo>> lists = CAFUtil.packageCafQuery(curAndFixedInfos);
                        CAFUtil.asyncQuery(lists, (EBRequest)queryCurAndFixedRequest);
                    }
                } else if (((CurAndFixedInfo)curAndFixedInfos.get(0)).getStatus().intValue() != CurAndFixedState.PACKAGED.getId() && ((CurAndFixedInfo)curAndFixedInfos.get(0)).getStatus().intValue() != CurAndFixedState.SUCCESS.getId() && ((CurAndFixedInfo)curAndFixedInfos.get(0)).getStatus().intValue() != CurAndFixedState.FAIL.getId()) {
                    Set<List<CurAndFixedInfo>> lists = CAFUtil.packageCafQuery(curAndFixedInfos);
                    CAFUtil.asyncQuery(lists, (EBRequest)queryCurAndFixedRequest);
                }
            }
            catch (Exception e) {
                this.logger.info("method\u67e5\u8be2\u5b9a\u6d3b\u76f8\u5173\u4ea4\u6613\u72b6\u6001\u5931\u8d25", (Object)e.getMessage());
            }
        } else {
            this.logger.info("\u5f53\u524d\u6279\u6b21\u5df2\u7ecf\u5b58\u5728\u540c\u6b65\u67e5\u8be2\u7684\u8bf7\u6c42\uff0c\u672c\u6b21\u67e5\u8be2\u8bf7\u6c42\u4e0d\u751f\u6548");
        }
        QueryCurAndFixedResponse currentAndFixedResponse = CurAndFixedConvert.convertQuery(ebBankCurAndFixedResponse);
        return currentAndFixedResponse;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "QueryCurAndFixed";
    }
}

