/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.currentandfixed;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.common.entity.biz.cafstatus.CafStatusDetail;
import kd.ebg.aqap.common.entity.biz.cafstatus.CafStatusRequest;
import kd.ebg.aqap.common.entity.biz.cafstatus.CafStatusResponse;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.entity.biz.status.EbStatus;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.services.CurAndFixedService;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StrUtil;

public class UpdateCurAndFixedStatusMethod
implements EBServiceMethod<CafStatusRequest, CafStatusResponse> {
    public CafStatusResponse executeClientRequest(CafStatusRequest request, EBContext ebContext) throws MalformedURLException {
        this.checkStructure(request);
        List details = request.getBody().getDetails();
        HashSet bathSeqID = new HashSet();
        details.forEach(detail -> {
            Preconditions.checkArgument((detail.getModifyStatus() == 12 || detail.getModifyStatus() == 13 ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u679a\u4e3e\u6709\u8bef\u3002", (String)"UpdateCurAndFixedStatusMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((!StrUtil.isEmpty((String)detail.getUpdateReason()) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u4fee\u6539\u7406\u7531\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdateCurAndFixedStatusMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
            bathSeqID.add(detail.getBatchSeqID());
        });
        bathSeqID.forEach(id -> this.checkBatchSeqIDUnique((String)id));
        CurAndFixedService curAndFixedService = CurAndFixedService.getInstance();
        for (CafStatusDetail detail2 : details) {
            List curAndFixedInfos = curAndFixedService.selectByBatchSeqID(detail2.getBatchSeqID());
            if (curAndFixedInfos.size() == 1) {
                CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)curAndFixedInfos.get(0);
                curAndFixedInfo.setBackStatus(curAndFixedInfo.getStatus());
                curAndFixedInfo.setBackStatusMsg(curAndFixedInfo.getStatusMsg());
                CurAndFixedInfo infoClone = new CurAndFixedInfo();
                FieldUtils.fieldsCopy((Object)curAndFixedInfo, (Object)infoClone);
                CurAndFixedState state = CurAndFixedState.getEnumById((int)detail2.getModifyStatus());
                curAndFixedInfo.setStatus(Integer.valueOf(state.getId()));
                curAndFixedInfo.setStatusName(state.getEnName());
                curAndFixedInfo.setStatusMsg(state.getCnName());
                try {
                    curAndFixedService.save(curAndFixedInfos);
                    detail2.setEbStatusMsg(ResManager.loadKDString((String)"\u72b6\u6001\u4fee\u6539\u5b8c\u6210", (String)"UpdateCurAndFixedStatusMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    detail2.setUpdateStatus("BANK_FAIL");
                    detail2.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u5931\u8d25\uff1a%s\u3002", (String)"UpdateCurAndFixedStatusMethod_7", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage()));
                }
                curAndFixedInfos = curAndFixedService.selectByBatchSeqIDAndDetailSeqID(detail2.getBatchSeqID(), detail2.getDetailSeqID());
                curAndFixedInfo = (CurAndFixedInfo)curAndFixedInfos.get(0);
                CurAndFixedState curAndFixedState = CurAndFixedState.getEnumById((int)curAndFixedInfo.getStatus());
                EbStatus status = EbStatus.convertBankState2EBG((CurAndFixedState)curAndFixedState);
                detail2.setEbStatus(status.getName());
                if (curAndFixedState.getId() == detail2.getModifyStatus()) {
                    detail2.setUpdateStatus("BANK_SUCCESS");
                    continue;
                }
                detail2.setUpdateStatus("BANK_FAIL");
                continue;
            }
            detail2.setEbStatusMsg(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u591a\u6761\u8bb0\u5f55\u653e\u5f03\u66f4\u65b0\u64cd\u4f5c\u3002", (String)"UpdateCurAndFixedStatusMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
            detail2.setUpdateStatus("BANK_FAIL");
        }
        CafStatusResponse cafStatusResponse = new CafStatusResponse();
        cafStatusResponse.setBody(request.getBody());
        return cafStatusResponse;
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return BizName.UPDATE_CAF_STATUS.name();
    }

    private void checkStructure(CafStatusRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)MultiLang.getRequestEmptyTip());
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)MultiLang.getRequestHeaderEmptyTip());
            if (request.getBody() != null) {
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)MultiLang.getRequestBodyEmptyTip());
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u4fee\u6539\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdateCurAndFixedStatusMethod_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
                if (request.getBody().getDetails() != null) {
                    Preconditions.checkArgument((request.getBody().getTotalCount() == request.getBody().getDetails().size() ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u66f4\u65b0\u7b14\u6570\u4e0e\u5b9e\u9645\u4e0d\u7b26\u3002", (String)"UpdateCurAndFixedStatusMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
                }
            }
        }
    }

    private void checkBatchSeqIDUnique(String batchSeqID) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)MultiLang.getBatchNotEmptyTip());
        Preconditions.checkState((boolean)CurAndFixedService.getInstance().batchSeqIDExist(batchSeqID), (Object)MultiLang.getBatchEmptyTip());
    }
}

