/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.schedule;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.login.utils.sms.impl.KDSMSSender;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.model.DetailSyncRecord;
import kd.ebg.aqap.common.model.repository.AlertMessageRepository;
import kd.ebg.aqap.common.model.repository.DetailSyncRecordRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class DetailCompletionCheckAndSendMsgScheduleJob
extends AbstractTask {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailCompletionCheckAndSendMsgScheduleJob.class);
    private BankLoginService bankLoginService = (BankLoginService)SpringContextUtil.getBean(BankLoginService.class);
    private BankAcntService bankAcntService = (BankAcntService)SpringContextUtil.getBean(BankAcntService.class);
    private DetailSyncRecordRepository detailSyncRecordRepository = (DetailSyncRecordRepository)SpringContextUtil.getBean(DetailSyncRecordRepository.class);
    private AlertMessageRepository alertMessageRepository = (AlertMessageRepository)SpringContextUtil.getBean(AlertMessageRepository.class);
    private final String signature = ResManager.loadKDString((String)"\u91d1\u8776\u94f6\u4f01\u4e91", (String)"DetailCompletionCheckAndSendMsgScheduleJob_0", (String)"ebg-aqap-business", (Object[])new Object[0]);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        MDC.put((String)"schedule", (String)"true");
        MDC.put((String)"scheduleLog", (String)String.valueOf(SystemPropertyConfig.isScheduleLogOpen()));
        if (!BusinessPropertyConfig.isOpenDetailCompletionCheckSwitch()) {
            return;
        }
        long start = System.currentTimeMillis();
        boolean isPaymentAllowed = SystemPropertyConfig.NOT_PAYMENT_ALLOW.getCurrentValueAsBoolean();
        if (isPaymentAllowed) {
            String scope = BusinessPropertyConfig.getDetailCompletionCheckScope();
            if (StringUtils.isEmpty((String)scope)) {
                return;
            }
            String[] scopes = scope.split(",");
            Date now = new Date();
            Date startDate = null;
            Date endDate = null;
            try {
                startDate = DateUtil.preDay((Date)now, (int)Integer.parseInt(scopes[0]));
                endDate = DateUtil.preDay((Date)now, (int)(Integer.parseInt(scopes[1]) + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.init(startDate, endDate);
        }
        long end = System.currentTimeMillis();
    }

    public void init(Date startDate, Date endDate) {
        List bankLogins = this.bankLoginService.getNotDeleteByCustomId(RequestContext.get().getTenantId());
        if (CollectionUtil.isNotEmpty((Collection)bankLogins)) {
            LocalDate startLocalDate = LocalDateUtil.date2LocalDate((Date)startDate);
            LocalDate endLocalDate = LocalDateUtil.date2LocalDate((Date)endDate);
            int count = 0;
            HashSet<LocalDate> notCompDate = new HashSet<LocalDate>(16);
            for (BankLogin bankLogin : bankLogins) {
                String bankLoginId = bankLogin.getKey().getBankLoginId();
                List bankAcnts = this.bankAcntService.getNotDeleteAcntByBankLoginIDAndCustomID(bankLoginId, RequestContext.get().getTenantId());
                if (CollectionUtil.isEmpty((Collection)bankAcnts)) continue;
                ArrayList<DetailSyncRecord> insertDetailSyncRecord = new ArrayList<DetailSyncRecord>(16);
                for (BankAcnt bankAcnt : bankAcnts) {
                    List records = this.detailSyncRecordRepository.findByCustomIDAndAccNoAndCurrencyAndSyncDateBetween(bankAcnt.getCustomID(), bankAcnt.getAccNo(), bankAcnt.getCurrency(), startLocalDate, endLocalDate);
                    LocalDate temp = LocalDateUtil.date2LocalDate((Date)startDate);
                    HashSet<LocalDate> recordDate = new HashSet<LocalDate>(16);
                    if (records != null && records.size() > 0) {
                        for (DetailSyncRecord record : records) {
                            recordDate.add(record.getSyncDate());
                            if (!CosmicConstants.DETAIL_RECORD_NOT_COMPLETED.equals(record.getIsCompleted())) continue;
                            ++count;
                            notCompDate.add(record.getSyncDate());
                        }
                    }
                    while (temp.isBefore(endLocalDate) || temp.isEqual(endLocalDate)) {
                        if (!recordDate.contains(temp)) {
                            ++count;
                            notCompDate.add(temp);
                            insertDetailSyncRecord.add(new DetailSyncRecord(bankAcnt.getCustomID(), bankAcnt.getAccNo(), bankAcnt.getBankName(), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), temp, bankAcnt.getCurrency(), Integer.valueOf(0), CosmicConstants.DETAIL_RECORD_NOT_COMPLETED));
                        }
                        temp = temp.plusDays(1L);
                    }
                }
                if (!CollectionUtil.isNotEmpty(insertDetailSyncRecord)) continue;
                try {
                    this.detailSyncRecordRepository.saveAll(insertDetailSyncRecord);
                }
                catch (Exception ex) {
                    this.logger.error("\u524d\u7f6e\u673a\u63d2\u5165record\u8bb0\u5f55\u5931\u8d25", (Throwable)ex);
                }
            }
            this.sendMsg(count, notCompDate);
        } else {
            this.logger.info("\u5f53\u524d\u4e0d\u5b58\u5728\u672a\u5220\u9664\u7684\u524d\u7f6e\u673a\u5217\u8868\uff0c\u8df3\u8fc7\u672c\u6b21\u4efb\u52a1");
        }
    }

    public void sendMsg(int count, Set<LocalDate> notCompDate) {
        if (count <= 0 || CollectionUtil.isEmpty(notCompDate)) {
            return;
        }
        String phone = this.getPhone();
        if (StringUtils.isEmpty((String)phone)) {
            return;
        }
        StringBuilder dateString = new StringBuilder();
        Iterator<LocalDate> it = notCompDate.iterator();
        int i = 0;
        while (it.hasNext()) {
            LocalDate localDate = it.next();
            dateString.append(localDate.toString());
            if (++i >= 7) {
                dateString.append(ResManager.loadKDString((String)"\u7b49", (String)"DetailCompletionCheckAndSendMsgScheduleJob_1", (String)"ebg-aqap-business", (Object[])new Object[0])).append(notCompDate.size()).append(ResManager.loadKDString((String)"\u4e2a\u65e5\u671f", (String)"DetailCompletionCheckAndSendMsgScheduleJob_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
                break;
            }
            if (i >= notCompDate.size()) continue;
            dateString.append("\u3001");
        }
        String temp = dateString.toString();
        StringBuilder message = new StringBuilder();
        message.append(ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f", (String)"DetailCompletionCheckAndSendMsgScheduleJob_3", (String)"ebg-aqap-business", (Object[])new Object[0])).append(temp).append(ResManager.loadKDString((String)"\u7684", (String)"DetailCompletionCheckAndSendMsgScheduleJob_4", (String)"ebg-aqap-business", (Object[])new Object[0])).append(count).append(ResManager.loadKDString((String)"\u4e2a\u94f6\u884c\u8d26\u53f7*\u65e5\u671f\u7684\u4ea4\u6613\u660e\u7ec6\u4e0b\u8f7d\u4e0d\u5168\uff0c\u8bf7\u5230\u3010\u67e5\u8be2\u4e0e\u652f\u4ed8\u3011-\u3010\u8d26\u6237\u67e5\u8be2\u3011-\u3010\u94f6\u4f01\u4ea4\u6613\u660e\u7ec6\u5b8c\u6574\u5ea6\u68c0\u67e5\u62a5\u8868\u3011\u4e2d\u67e5\u770b\u8be6\u60c5\u3002", (String)"DetailCompletionCheckAndSendMsgScheduleJob_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
        KDSMSSender sender = new KDSMSSender();
        boolean result = sender.sendMessage(phone, message.toString(), this.signature);
        StringBuilder myMsg = new StringBuilder();
        myMsg.append('\u3010').append(this.signature).append('\u3011').append((CharSequence)message);
        this.alertMessageRepository.save("5", CosmicConstants.ALERT_TYPE_MOBILE, phone, new Date(), myMsg.toString(), String.valueOf(result));
    }

    private String getPhone() {
        String selectFields = "attr_key, attr_value";
        String objectId = "detail_early_warning_setting";
        QFilter filter = QFilter.of((String)"object_id=?  and object_name=?", (Object[])new Object[]{objectId, objectId});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"aqap_object_properties", (String)selectFields, (QFilter[])filter.toArray());
        if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
            for (DynamicObject d : dynamicObjects) {
                if (!"phone_number".equals(d.getString("attr_key"))) continue;
                return d.getString("attr_value");
            }
        }
        return "";
    }
}

