/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.financing;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.cache.CacheFinancingStorage;
import kd.ebg.aqap.business.financing.util.FinancingChecker;
import kd.ebg.aqap.business.financing.util.FinancingConvert;
import kd.ebg.aqap.business.financing.util.FinancingUtil;
import kd.ebg.aqap.common.entity.biz.financing.redeem.RedeemFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.redeem.RedeemFinancingResponse;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.services.FinancingService;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBDuplicateException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class RedeemFinancingMethod
implements EBServiceMethod<RedeemFinancingRequest, RedeemFinancingResponse> {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(RedeemFinancingMethod.class);

    public RedeemFinancingRequest mappingCurrency(RedeemFinancingRequest request) {
        List list = request.getBody().getDetails();
        HashMap currencyMap = new HashMap(16);
        list.stream().forEach(item -> {
            String currency = item.getCurrency();
            currency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(currency, currencyMap);
            item.setCurrency(currency);
        });
        return request;
    }

    public RedeemFinancingResponse mappingCurrency(RedeemFinancingResponse response) {
        if (response.getBody() != null) {
            List list = response.getBody().getDetails();
            HashMap currencyMap = new HashMap(16);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                list.stream().forEach(item -> {
                    String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getCurrency(), currencyMap);
                    item.setCurrency(currency);
                });
            }
        }
        return response;
    }

    public RedeemFinancingResponse executeClientRequest(RedeemFinancingRequest request, EBContext ebContext) throws MalformedURLException {
        String batchSeqID = "";
        try {
            FinancingChecker.checkStructure(request);
            batchSeqID = request.getBody().getBatchSeqId();
            FinancingChecker.checkBatchSeqIDUnique(batchSeqID);
            FinancingChecker.checkBizNo(request);
        }
        catch (IllegalArgumentException e) {
            throw EBExceiptionUtil.preCheckException((String)e.getMessage(), (Throwable)e);
        }
        catch (EBDuplicateException e) {
            throw EBExceiptionUtil.duplicateException((String)e.getMessage(), (Throwable)e);
        }
        BankFinancingRequest bankRequest = FinancingConvert.convert(request);
        String key = request.getHeader().getCustomId() + "_" + batchSeqID;
        if (!CacheFinancingStorage.checkRepeat(key)) {
            FinancingService.getInstance().insertAll(bankRequest.getInfos());
            FinancingUtil.async(bankRequest.getInfos(), bankRequest);
            CacheFinancingStorage.release(key);
        } else {
            this.logger.error("\u5f53\u524d\u7406\u8d22\u63a5\u53e3\u8bf7\u6c42\u51fa\u73b0\u91cd\u590d\uff0c\u4e1a\u52a1\u6279\u6b21\u53f7\uff1a ", new Object[]{batchSeqID});
        }
        RedeemFinancingResponse response = FinancingConvert.convertRedeem(bankRequest.getInfos(), request.getHeader().getCurrency());
        return response;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return BizName.REDEEM_FINANCING.name();
    }
}

