/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.business.payment.utils.OverseaPaymentConvertUtil;
import kd.ebg.aqap.business.payment.utils.QueryPaymentUtil;
import kd.ebg.aqap.common.entity.biz.querypay.QueryOverseaPayRequest;
import kd.ebg.aqap.common.entity.biz.querypay.QueryOverseaPayResponse;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.string.StrUtil;
import org.slf4j.MDC;

public class QueryOverseaPayMethod
implements EBServiceMethod<QueryOverseaPayRequest, QueryOverseaPayResponse> {
    public QueryOverseaPayResponse mappingCurrency(QueryOverseaPayResponse response) {
        if (response.getBody() != null) {
            List list = response.getBody().getDetails();
            HashMap currencyMap = new HashMap(16);
            list.stream().forEach(item -> {
                String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getPayCurrency(), currencyMap);
                item.setPayCurrency(currency);
                currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getPayerFeeCurrency(), currencyMap);
                item.setPayerFeeCurrency(currency);
                currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getExchangeCurrency(), currencyMap);
                item.setExchangeCurrency(currency);
                currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getProxyFeeCurrency(), currencyMap);
                item.setProxyFeeCurrency(currency);
            });
        }
        return response;
    }

    public QueryOverseaPayResponse executeClientRequest(QueryOverseaPayRequest request, EBContext context) {
        AccessUtils.checkPaymentAllowed(context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        String batchSeqID = request.getBody().getBatchSeqId();
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)ResManager.loadKDString((String)"\u6279\u6b21\u6d41\u6c34\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryOverseaPayMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        List infoList = PaymentInfoService.getInstance().selectByBatchSeqID(batchSeqID);
        if (infoList.isEmpty()) {
            throw EBExceiptionUtil.preCheckException((String)"unknown_batch", (String)String.format(ResManager.loadKDString((String)"\u67e5\u65e0\u6b64\u6279\u6b21\u53f7: %s\u3002", (String)"QueryOverseaPayMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]), batchSeqID));
        }
        Set<List<PaymentInfo>> paymentInfoSet = QueryPaymentUtil.setOfPay(infoList);
        QueryPaymentUtil.async(paymentInfoSet, (EBRequest)request);
        return OverseaPaymentConvertUtil.getQueryOverseaPayResponse(infoList, request);
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "queryOverseaPay";
    }
}

