/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.atomic;

import java.util.Stack;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BusiImplInfo {
    private String implName;
    private String queryImplName;
    private String packageKey;
    private Stack stack = new Stack();

    public String getImplName() {
        return this.implName;
    }

    public void setImplName(String impl) {
        if (StringUtils.isEmpty((String)impl)) {
            return;
        }
        this.implName = impl;
        try {
            IPay pay = (IPay)Class.forName(impl).newInstance();
            this.setQueryImplName(pay.defaultQueryClass().getName());
        }
        catch (Exception e) {
            EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String getQueryImplName() {
        return this.queryImplName;
    }

    public void setQueryImplName(String impl) {
        this.queryImplName = impl;
    }

    public String getPackageKey() {
        return this.getPayRoute();
    }

    public void setPackageKey(String packageKey) {
        this.packageKey = packageKey;
    }

    public String getPayRoute() {
        StringBuilder payRoute = new StringBuilder(this.packageKey);
        if (!this.stack.empty()) {
            payRoute.append("|");
            while (!this.stack.empty()) {
                payRoute.append(this.stack.pop()).append(" -> ");
            }
            payRoute.append("end");
        }
        return payRoute.toString();
    }

    public void appendNode(String node) {
        if (node.startsWith("getBusiImplInfo")) {
            node = "start -> " + node;
        }
        this.stack.push(node);
    }

    public boolean assertSubBizType(PaymentInfo paymentInfo, String subPayType) {
        if (StringUtils.isNotEmpty((String)subPayType)) {
            return subPayType.equalsIgnoreCase(paymentInfo.getSubBizType());
        }
        return false;
    }
}

