/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.route;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.route.PayRouteEnum;
import kd.ebg.aqap.business.payment.route.PayTypeEnum;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PayRoute {
    private String id;
    private String bankVersionID;
    private String bizType;
    private String individual;
    private String merge;
    private String sameBank;
    private String useCn;
    private String currency;
    private String single;
    private String urgent;
    private String busconfig;
    private String accprop;
    private String impl;
    private String source;

    public String getBankVersionID() {
        return this.bankVersionID;
    }

    public void setBankVersionID(String bankVersionID) {
        this.bankVersionID = bankVersionID;
    }

    public String getBizType() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.bizType);
        PayTypeEnum payTypeEnum = PayTypeEnum.getPayTypeEnum(this.bizType);
        if (payTypeEnum != null) {
            sb.append('(').append(payTypeEnum.getDesc()).append(')');
        }
        return sb.toString();
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String getMerge() {
        return this.merge;
    }

    public void setMerge(String merge) {
        this.merge = merge;
    }

    public String getSameBank() {
        return this.sameBank;
    }

    public void setSameBank(String sameBank) {
        this.sameBank = sameBank;
    }

    public String getUseCn() {
        return this.useCn;
    }

    public void setUseCn(String useCn) {
        this.useCn = useCn;
    }

    public String getBusconfig() {
        return this.busconfig;
    }

    public void setBusconfig(String busconfig) {
        this.busconfig = busconfig;
    }

    public String getAccprop() {
        return this.accprop;
    }

    public void setAccprop(String accprop) {
        this.accprop = accprop;
    }

    public String getImpl() {
        return this.impl;
    }

    public void setImpl(String impl) {
        this.impl = impl;
    }

    public String getIndividual() {
        return this.individual;
    }

    public void setIndividual(String individual) {
        this.individual = individual;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    private boolean isSameBizType(PayRoute p) {
        return p.getBizType().equalsIgnoreCase(this.getBizType());
    }

    private boolean isSameIndividual(PayRoute p) {
        return p.getIndividual().equalsIgnoreCase(this.getIndividual());
    }

    private boolean isSameMerge(PayRoute p) {
        return p.getMerge().equalsIgnoreCase(this.getMerge());
    }

    private boolean isSameBank(PayRoute p) {
        return p.getSameBank().equalsIgnoreCase(this.getSameBank());
    }

    private boolean isSameUseCN(PayRoute p) {
        return p.getUseCn().equalsIgnoreCase(this.getUseCn());
    }

    private boolean isSameCurrency(PayRoute p) {
        return p.getCurrency().equalsIgnoreCase(this.getCurrency());
    }

    private boolean isSameSingle(PayRoute p) {
        return p.getSingle().equalsIgnoreCase(this.getSingle());
    }

    private boolean isSameUrgent(PayRoute p) {
        return p.getUrgent().equalsIgnoreCase(this.getUrgent());
    }

    public boolean isSameNode(PayRouteEnum payRouteEnum, PayRoute p) {
        if (PayRouteEnum.INDIVIDUAL == payRouteEnum) {
            return this.isSameBizType(p);
        }
        if (PayRouteEnum.MERGE == payRouteEnum) {
            return this.isSameBizType(p) && this.isSameIndividual(p);
        }
        if (PayRouteEnum.SAME_BANK == payRouteEnum) {
            return this.isSameBizType(p) && this.isSameIndividual(p) && this.isSameMerge(p);
        }
        if (PayRouteEnum.USE_CN == payRouteEnum) {
            return this.isSameBizType(p) && this.isSameIndividual(p) && this.isSameMerge(p) && this.isSameBank(p);
        }
        if (PayRouteEnum.CURRENCY == payRouteEnum) {
            return this.isSameBizType(p) && this.isSameIndividual(p) && this.isSameMerge(p) && this.isSameBank(p) && this.isSameCurrency(p);
        }
        if (PayRouteEnum.SINGLE == payRouteEnum) {
            return this.isSameBizType(p) && this.isSameIndividual(p) && this.isSameMerge(p) && this.isSameBank(p) && this.isSameCurrency(p) && this.isSameSingle(p);
        }
        if (PayRouteEnum.BUS_CONFIG == payRouteEnum) {
            return this.isSameBizType(p) && this.isSameIndividual(p) && this.isSameMerge(p) && this.isSameBank(p) && this.isSameCurrency(p) && this.isSameSingle(p) && this.isSameUseCN(p);
        }
        if (PayRouteEnum.URGENT == payRouteEnum) {
            return this.isSameBizType(p) && this.isSameIndividual(p) && this.isSameMerge(p) && this.isSameBank(p) && this.isSameCurrency(p) && this.isSameSingle(p) && this.isSameUrgent(p);
        }
        return p.getBizType().equalsIgnoreCase(this.getBizType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.join(sb, ResManager.loadKDString((String)"\u94f6\u884c\u7248\u672c", (String)"PayRoute_0", (String)"ebg-aqap-business", (Object[])new Object[0]), this.bankVersionID);
        this.join(sb, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b", (String)"PayRoute_1", (String)"ebg-aqap-business", (Object[])new Object[0]), this.bizType);
        this.join(sb, ResManager.loadKDString((String)"\u662f\u5426\u5bf9\u79c1", (String)"PayRoute_2", (String)"ebg-aqap-business", (Object[])new Object[0]), this.individual);
        this.join(sb, ResManager.loadKDString((String)"\u662f\u5426\u5e76\u7b14", (String)"PayRoute_3", (String)"ebg-aqap-business", (Object[])new Object[0]), this.merge);
        this.join(sb, ResManager.loadKDString((String)"\u662f\u5426\u540c\u884c", (String)"PayRoute_4", (String)"ebg-aqap-business", (Object[])new Object[0]), this.sameBank);
        this.join(sb, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7528\u9014", (String)"PayRoute_5", (String)"ebg-aqap-business", (Object[])new Object[0]), this.useCn);
        this.join(sb, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7b14\u6570", (String)"PayRoute_6", (String)"ebg-aqap-business", (Object[])new Object[0]), this.single);
        this.join(sb, ResManager.loadKDString((String)"\u94f6\u884c\u5e01\u79cd", (String)"PayRoute_7", (String)"ebg-aqap-business", (Object[])new Object[0]), this.currency);
        this.join(sb, ResManager.loadKDString((String)"\u914d\u7f6e\u9879", (String)"PayRoute_8", (String)"ebg-aqap-business", (Object[])new Object[0]), this.busconfig);
        this.join(sb, ResManager.loadKDString((String)"\u8d26\u53f7\u5c5e\u6027", (String)"PayRoute_9", (String)"ebg-aqap-business", (Object[])new Object[0]), this.accprop);
        this.join(sb, ResManager.loadKDString((String)"\u63a5\u53e3\u5b9e\u73b0\u7c7b", (String)"PayRoute_10", (String)"ebg-aqap-business", (Object[])new Object[0]), this.impl);
        this.join(sb, ResManager.loadKDString((String)"\u8def\u7531\u6570\u636e\u6765\u6e90", (String)"PayRoute_11", (String)"ebg-aqap-business", (Object[])new Object[0]), this.source);
        return sb.toString();
    }

    private void join(StringBuilder sb, String key, String value) {
        if (sb != null && StringUtils.isNotEmpty((String)value)) {
            sb.append(key).append(" = ").append(value).append(" \n");
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getSingle() {
        return this.single;
    }

    public void setSingle(String single) {
        this.single = single;
    }

    public String getUrgent() {
        return this.urgent;
    }

    public void setUrgent(String urgent) {
        this.urgent = urgent;
    }
}

