/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.task;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.file.atomic.IUpload;
import kd.ebg.aqap.business.payment.bank.BankAttachmentRequest;
import kd.ebg.aqap.business.payment.bank.BankAttachmentResponse;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.PayAttachmentService;
import kd.ebg.aqap.common.model.PayAttachment;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class AttachmentUploadTask
extends AbstractTask {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(AttachmentUploadTask.class);
    private BankAttachmentRequest bankAttachmentRequest;
    private EBContext context;
    private static final String REQUEST_SEQ_ID_KEY = "requestSeqID";
    private static final String BIZ_NAME_KEY = "bizName";
    private static final String BIZ_SEQ_KEY = "bizSeqID";
    private static final String CUSTOMER_ID = "customerID";
    private static final String BANK_VERSION_ID = "bankVersionID";

    public AttachmentUploadTask(BankAttachmentRequest bankAttachmentRequest, EBContext context) {
        this.bankAttachmentRequest = bankAttachmentRequest;
        this.context = context;
    }

    public Object doBiz() {
        BankAttachmentResponse bankAttachmentResponse = this.submitUpload(this.bankAttachmentRequest, this.context);
        return bankAttachmentResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BankAttachmentResponse submitUpload(BankAttachmentRequest bankAttachmentRequest, EBContext context) {
        BankAttachmentResponse bankAttachmentResponse;
        FEPAccess access;
        List<PayAttachment> payAttachments;
        block6: {
            payAttachments = bankAttachmentRequest.getPayAttachments();
            PayAttachment attachment = payAttachments.get(0);
            EBContext.setContext((EBContext)context);
            PayAttachmentService payAttachmentService = (PayAttachmentService)SpringContextUtil.getBean(PayAttachmentService.class);
            MDCUtil.clearBankMDC();
            MDCUtil.initMDC((EBContext)context);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            MDC.put((String)REQUEST_SEQ_ID_KEY, (String)context.getRequestSeqID());
            MDC.put((String)BIZ_SEQ_KEY, (String)context.getBizSeqID());
            MDC.put((String)CUSTOMER_ID, (String)context.getCustomID());
            MDC.put((String)BIZ_NAME_KEY, (String)context.getBizName());
            MDC.put((String)BANK_VERSION_ID, (String)context.getBankVersionID());
            this.logger.infoIndex(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u8fdb\u884c\u9644\u4ef6\u4e0a\u4f20\u4e1a\u52a1\u5904\u7406,%s", (String)"AttachmentUploadTask_0", (String)"ebg-aqap-business", (Object[])new Object[0]), context.getLogger_batch_no()));
            IUpload upload = (IUpload)BankBundleManager.getInstance().getImplByClassName(attachment.getBankVersionID(), IUpload.class, attachment.getImplClassName());
            this.logger.info("\u94f6\u884c\u63d2\u4ef6\u7684\u5b9e\u73b0\u7c7b\u4e3a\uff1a{}", (Object)attachment.getImplClassName());
            access = null;
            try {
                EBContext.initParameter();
                access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
                bankAttachmentResponse = upload.upload(bankAttachmentRequest);
                if (bankAttachmentResponse == null || !CollectionUtil.isNotEmpty(bankAttachmentResponse.getPayAttachments())) break block6;
                payAttachmentService.updateAll(bankAttachmentResponse.getPayAttachments());
            }
            catch (Throwable e) {
                block7: {
                    try {
                        if (!CollectionUtil.isNotEmpty(payAttachments)) break block7;
                        for (PayAttachment payAttachment : payAttachments) {
                            payAttachment.setStatus(Integer.valueOf(AttachmentState.FAIL.getId()));
                            payAttachment.setStatusName(AttachmentState.FAIL.getEnName());
                            payAttachment.setStatusMsg(AttachmentState.FAIL.getCnName());
                            String error = e.getMessage();
                            if (StringUtils.isNotEmpty((String)error) && error.length() > 255) {
                                error = error.substring(0, 255);
                            }
                            payAttachment.setBankMsg(error);
                        }
                        payAttachmentService.updateAll(payAttachments);
                    }
                    catch (Throwable throwable) {
                        FEPAccessUtil.release(access);
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        throw throwable;
                    }
                }
                FEPAccessUtil.release((FEPAccess)access);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        bankAttachmentResponse = new BankAttachmentResponse();
        bankAttachmentResponse.setPayAttachments(payAttachments);
        return bankAttachmentResponse;
    }
}

