/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.task;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.currentandfixed.atomic.ICurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.CurAndFixedService;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBLoginAccessException;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class BankCurAndFixedTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankCurAndFixedTask.class);
    private BankCurAndFixedRequest request;
    private EBContext context;

    public BankCurAndFixedTask(BankCurAndFixedRequest request, EBContext context) {
        this.request = request;
        this.context = context;
    }

    public Object doBiz() {
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = this.submitCaf(this.request, this.context);
        return ebBankCurAndFixedResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EBBankCurAndFixedResponse submitCaf(BankCurAndFixedRequest request, EBContext context) {
        FEPAccess access;
        List<Object> result;
        CurAndFixedService curAndFixedService;
        block19: {
            ICurAndFixed caf;
            List curAndFixedInfos;
            block18: {
                String bizSeqID = Sequence.gen18Sequence();
                if (StringUtils.isEmpty((String)request.getHeader().getBizSeqID())) {
                    request.getHeader().setBizSeqID(bizSeqID);
                }
                context.setBizName("currentAndFixed");
                MDCUtil.clearBussinessMDC();
                MDCUtil.initMDC((EBContext)context);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                EBContext.setContext((EBContext)context);
                this.logger.infoIndex("\u5f00\u59cb\u5b9a\u6d3b\u4e92\u8f6c\u4e1a\u52a1\u5904\u7406,{}", (Object)bizSeqID);
                this.logger.info("\u5f00\u59cb\u5b9a\u6d3b\u4e92\u8f6c\u4e1a\u52a1,\u603b\u8bb0\u5f55\u6570\uff1a{}\u6761", (Object)request.getCafInfos().size());
                curAndFixedInfos = request.getCafInfos();
                if (curAndFixedInfos.isEmpty()) {
                    return null;
                }
                curAndFixedService = CurAndFixedService.getInstance();
                String bankVersionID = context.getBankVersionID();
                String implClassName = curAndFixedInfos.get(0).getImplClassName();
                caf = (ICurAndFixed)BankBundleManager.getInstance().getImplByClassName(bankVersionID, ICurAndFixed.class, implClassName);
                this.logger.info("\u94f6\u884c\u63d2\u4ef6\u7684\u5b9e\u73b0\u7c7b\u4e3a\uff1a{}", caf.getClass());
                result = Lists.newArrayListWithCapacity((int)1);
                access = null;
                EBContext.initParameter();
                MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
                curAndFixedInfos = curAndFixedService.compareAndStateState(curAndFixedInfos, CurAndFixedState.PACKAGED, CurAndFixedState.SUBMITED);
                if (!Objects.isNull(curAndFixedInfos) && !curAndFixedInfos.isEmpty()) break block18;
                this.logger.info("\u72b6\u6001\u4fee\u6539\u4e3a\u63d0\u4ea4\u4e2d\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u5176\u4ed6\u8282\u70b9\u5904\u7406\u8fc7\u7684\u8bf7\u6c42.bankBatchSeqId:{}", (Object)request.getBatchSeqId());
                EBBankCurAndFixedResponse eBBankCurAndFixedResponse = null;
                FEPAccessUtil.release((FEPAccess)access);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                return eBBankCurAndFixedResponse;
            }
            try {
                request.setCafInfos(curAndFixedInfos);
                EBBankCurAndFixedResponse response = caf.currentAndFixed(request);
                if (Objects.nonNull(EBContext.getContext().getThrowableAfterSend())) {
                    Throwable t = EBContext.getContext().getThrowableAfterSend();
                    this.logger.error("\u5b9a\u6d3b\u4e92\u8f6c\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", t);
                    if (t instanceof EBServiceException) {
                        if (((EBServiceException)t).getErrorCode().equalsIgnoreCase("ProxyCreateConnectionException")) {
                            CAFUtil.setState(request.getCafInfos(), CurAndFixedState.FAIL, t.getMessage(), "", "");
                        } else if (((EBServiceException)t).getErrorCode().equalsIgnoreCase("ProxyConnectionException")) {
                            CAFUtil.setState(request.getCafInfos(), CurAndFixedState.UNKNOWN, t.getMessage(), "", "");
                        } else {
                            CAFUtil.setState(request.getCafInfos(), CurAndFixedState.UNKNOWN, ResManager.loadKDString((String)"\u4e1a\u52a1\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38\uff0c\u5177\u4f53\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u540c\u6b65\u6267\u884c\u7ed3\u679c\u3002", (String)"BankCurAndFixedTask_0", (String)"ebg-aqap-business", (Object[])new Object[0]), "", "");
                        }
                    } else {
                        CAFUtil.setState(request.getCafInfos(), CurAndFixedState.UNKNOWN, ResManager.loadKDString((String)"\u4e1a\u52a1\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38\uff0c\u5177\u4f53\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u540c\u6b65\u6267\u884c\u7ed3\u679c\u3002", (String)"BankCurAndFixedTask_0", (String)"ebg-aqap-business", (Object[])new Object[0]), "", "");
                    }
                    result = request.getCafInfos();
                    break block19;
                }
                Preconditions.checkState((boolean)Objects.nonNull((Object)response), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankCurAndFixedTask_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
                if (response == null) break block19;
                Preconditions.checkState((boolean)Objects.nonNull(response.getDetails()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u5b9a\u6d3b\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankCurAndFixedTask_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
                result = response.getDetails();
            }
            catch (Exception e) {
                try {
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                    this.logger.error("\u4e1a\u52a1\u5904\u7406\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                    if (e instanceof EBLoginAccessException) {
                        CAFUtil.setState(request.getCafInfos(), CurAndFixedState.PACKAGED, "", "", "");
                        this.logger.error("\u72b6\u6001\u9000\u56de\"\u5df2\u6253\u5305\"\u72b6\u6001");
                    } else {
                        String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u6267\u884c\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002", (String)"BankCurAndFixedTask_3", (String)"ebg-aqap-business", (Object[])new Object[0]);
                        if (!StringUtils.isEmpty((String)e.getMessage())) {
                            errorMsg = errorMsg + "," + e.getMessage();
                        }
                        CAFUtil.setState(request.getCafInfos(), CurAndFixedState.FAIL, errorMsg, "", e.getMessage());
                        for (CurAndFixedInfo info : request.getCafInfos()) {
                            info.setBackErrorMsg(e.getMessage());
                        }
                    }
                    result = request.getCafInfos();
                }
                catch (Throwable throwable) {
                    FEPAccessUtil.release(access);
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                    throw throwable;
                }
                FEPAccessUtil.release((FEPAccess)access);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        curAndFixedService.save((List)result);
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        ebBankCurAndFixedResponse.setHeader(request.getHeader());
        ebBankCurAndFixedResponse.setBatchSeqId(request.getBatchSeqId());
        ebBankCurAndFixedResponse.setDetails(request.getCafInfos());
        return ebBankCurAndFixedResponse;
    }
}

