/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.utils;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.service.keywords.BankKeyWordsService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class AccessUtils {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(AccessUtils.class);

    public static void checkPaymentAllowed(EBContext context) {
        String bankVersionID = context.getBankVersionID();
        boolean isPaymentAllowed = SystemPropertyConfig.PAYMENT_ALLOW.getCurrentValueAsBoolean();
        if (!isPaymentAllowed) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u652f\u4ed8\u901a\u9053\u5df2\u5173\u95ed\uff0c\u8bf7\u5728\u94f6\u4f01\u5168\u5c40\u53c2\u6570\u914d\u7f6e\u4e2d\u5f00\u542f'\u652f\u4ed8\u901a\u9053\u5f00\u5173'\u540e\u91cd\u65b0\u53d1\u8d77\u4ed8\u6b3e\u4ea4\u6613\u3002", (String)"AccessUtils_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (!BankPropertyConfig.isBankPayAllow((String)bankVersionID)) {
            String bankName = bankVersionID;
            List bankKeyWordList = BankKeyWordsService.getInstance().getKeyWords(bankVersionID);
            if (CollectionUtil.isNotEmpty((Collection)bankKeyWordList)) {
                bankName = (String)bankKeyWordList.get(0);
            }
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"%s\u7684\u652f\u4ed8\u901a\u9053\u5df2\u5173\u95ed\uff0c\u8bf7\u5728\u94f6\u884c\u53c2\u6570\u914d\u7f6e\u4e2d\u5f00\u542f'\u94f6\u884c\u652f\u4ed8\u901a\u9053\u5f00\u5173'\u540e\u91cd\u65b0\u53d1\u8d77\u4ed8\u6b3e\u4ea4\u6613\u3002", (String)"AccessUtils_7", (String)"ebg-aqap-business", (Object[])new Object[0]), bankName));
        }
    }

    public static boolean isPaymentAllowed(EBContext context) {
        String bankVersionID = context.getBankVersionID();
        boolean isPaymentAllowed = SystemPropertyConfig.PAYMENT_ALLOW.getCurrentValueAsBoolean();
        if (!isPaymentAllowed) {
            logger.info("\u652f\u4ed8\u901a\u9053\u5df2\u5173\u95ed\uff0c\u8bf7\u5728\u94f6\u4f01\u5168\u5c40\u53c2\u6570\u914d\u7f6e\u4e2d\u5f00\u542f'\u652f\u4ed8\u901a\u9053\u5f00\u5173'\u540e\u91cd\u65b0\u53d1\u8d77\u4ed8\u6b3e\u4ea4\u6613");
            return false;
        }
        if (!BankPropertyConfig.isBankPayAllow((String)bankVersionID)) {
            String bankName = bankVersionID;
            List bankKeyWordList = BankKeyWordsService.getInstance().getKeyWords(bankVersionID);
            if (CollectionUtil.isNotEmpty((Collection)bankKeyWordList)) {
                bankName = (String)bankKeyWordList.get(0);
            }
            logger.info(bankName + "\u7684\u652f\u4ed8\u901a\u9053\u5df2\u5173\u95ed\uff0c\u8bf7\u5728\u94f6\u884c\u53c2\u6570\u914d\u7f6e\u4e2d\u5f00\u542f'\u94f6\u884c\u652f\u4ed8\u901a\u9053\u5f00\u5173'\u540e\u91cd\u65b0\u53d1\u8d77\u4ed8\u6b3e\u4ea4\u6613");
            return false;
        }
        return true;
    }

    public static void checkQueryAllowed(EBContext context) {
        String bankVersionID = context.getBankVersionID();
        boolean isQueryAllowed = SystemPropertyConfig.NOT_PAYMENT_ALLOW.getCurrentValueAsBoolean();
        if (!isQueryAllowed) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u975e\u652f\u4ed8\u901a\u9053\u5df2\u5173\u95ed\uff0c\u8bf7\u5728\u94f6\u4f01\u5168\u5c40\u53c2\u6570\u914d\u7f6e\u4e2d\u5f00\u542f'\u975e\u652f\u4ed8\u901a\u9053\u5f00\u5173'\u540e\u91cd\u65b0\u53d1\u8d77\u8bf7\u6c42\u3002", (String)"AccessUtils_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (!BankPropertyConfig.isBankQueryAllow((String)bankVersionID)) {
            String bankName = bankVersionID;
            List bankKeyWordList = BankKeyWordsService.getInstance().getKeyWords(bankVersionID);
            if (CollectionUtil.isNotEmpty((Collection)bankKeyWordList)) {
                bankName = (String)bankKeyWordList.get(0);
            }
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"%s\u7684\u975e\u652f\u4ed8\u901a\u9053\u5df2\u5173\u95ed\uff0c\u8bf7\u5728\u94f6\u884c\u53c2\u6570\u914d\u7f6e\u4e2d\u5f00\u542f'\u94f6\u884c\u975e\u652f\u4ed8\u901a\u9053\u5f00\u5173'\u540e\u91cd\u65b0\u53d1\u8d77\u8bf7\u6c42\u3002", (String)"AccessUtils_8", (String)"ebg-aqap-business", (Object[])new Object[0]), bankName));
        }
    }

    public static void checkExplanationSpecialCharPool(String bankVersionID, List<String> explanations) {
        List pools;
        if (CollectionUtil.isNotEmpty(explanations) && CollectionUtil.isNotEmpty((Collection)(pools = BankPropertyConfig.getExplanationSpecialCharPool((String)bankVersionID)))) {
            for (String explanation : explanations) {
                AccessUtils.checkExplanationSpecialCharPool(pools, explanation);
            }
        }
    }

    private static void checkExplanationSpecialCharPool(List<String> pools, String explanation) {
        for (String pool : pools) {
            if (!StringUtils.isNotEmpty((String)explanation) || !explanation.contains(pool)) continue;
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u5931\u8d25\uff0c\u4ed8\u6b3e\u5355\u5185\u586b\u5199\u7684\u6458\u8981\u5305\u542b\u4e0d\u89c4\u8303\u7684\u7279\u6b8a\u5b57\u7b26\u4fe1\u606f\uff1b\u8be6\u60c5\u53ef\u4ee5\u67e5\u770b\u67e5\u8be2\u4e0e\u652f\u4ed8-\u94f6\u884c\u53c2\u6570\u914d\u7f6e\u7684\u4ed8\u6b3e\u6458\u8981\u7279\u6b8a\u5b57\u7b26\u6c60\uff1b", (String)"AccessUtils_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
    }
}

