/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.util.BalanceUtils;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BalanceUtil {
    public static void setCurrentBalance(BalanceInfo balanceInfo, String value) {
        BalanceUtil.setBalance(balanceInfo, value, BalanceUtils.currentBalanceVerification);
    }

    public static void setAvailableBalance(BalanceInfo balanceInfo, String value) {
        balanceInfo.setAvailableBalance(BalanceUtils.any(value));
    }

    public static void setLastDayAvlBalance(BalanceInfo balanceInfo, String value) {
        balanceInfo.setLastDayAvlBalance(BalanceUtils.any(value));
    }

    public static void setFreezeBalance(BalanceInfo balanceInfo, String value) {
        balanceInfo.setFreezeBalance(BalanceUtils.any(value));
    }

    public static void setDepositBalance(BalanceInfo balanceInfo, String value) {
        balanceInfo.setDepositBalance(BalanceUtils.any(value));
    }

    public static void setBankCurrency(BalanceInfo balanceInfo, String value) {
        balanceInfo.setBankCurrency(value);
    }

    public static void setBankCurrency(BalanceInfo balanceInfo, String reqBankCurrency, String resBankCurrency) {
        if (StringUtils.isEmpty((String)resBankCurrency)) {
            BalanceUtil.setBankCurrency(balanceInfo, reqBankCurrency);
        } else if (reqBankCurrency.equalsIgnoreCase(resBankCurrency)) {
            BalanceUtil.setBankCurrency(balanceInfo, resBankCurrency);
        } else {
            BalanceUtil.setBankCurrency(balanceInfo, reqBankCurrency);
            balanceInfo.setError(BalanceUtils.inconsistentCurrency());
        }
    }

    public static void setBankAcnt(BalanceInfo balanceInfo, List<BankAcnt> bankAccounts, String resAccount) {
        if (CollectionUtil.isEmpty(bankAccounts)) {
            BankAcnt bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(resAccount);
            BalanceUtil.setBankAcnt(balanceInfo, bankAcnt);
            return;
        }
        if (bankAccounts.size() > 1) {
            boolean flag = false;
            for (BankAcnt bankAccount : bankAccounts) {
                flag = bankAccount.getAccNo().equalsIgnoreCase(resAccount);
                if (!flag) continue;
                BalanceUtil.setBankAcnt(balanceInfo, bankAccount);
                break;
            }
            if (!flag) {
                BankAcnt bankAcnt = new BankAcnt();
                bankAcnt.setAccNo(resAccount);
                balanceInfo.setError(BalanceUtils.inconsistentAcc());
                BalanceUtil.setBankAcnt(balanceInfo, bankAcnt);
            }
        } else {
            BankAcnt bankAcnt = bankAccounts.get(0);
            if (StringUtils.isEmpty((String)bankAcnt.getAccNo())) {
                bankAcnt.setAccNo(resAccount);
                BalanceUtil.setBankAcnt(balanceInfo, bankAcnt);
            } else if (bankAcnt.getAccNo().equalsIgnoreCase(resAccount)) {
                BalanceUtil.setBankAcnt(balanceInfo, bankAcnt);
            } else {
                balanceInfo.setError(BalanceUtils.inconsistentAcc());
                BalanceUtil.setBankAcnt(balanceInfo, bankAcnt);
            }
        }
    }

    public static void setBankAcnt(BalanceInfo balanceInfo, BankAcnt bankAcnt) {
        balanceInfo.setBankAcnt(bankAcnt);
    }

    public static void setBalanceDateTime(BalanceInfo balanceInfo, String resDateTimeStr, DateTimeFormatter formatter) {
        try {
            BalanceUtil.setBalanceDateTime(balanceInfo, LocalDateTime.parse(resDateTimeStr, formatter));
        }
        catch (Exception e) {
            balanceInfo.setError(BalanceUtils.wrongDateFormatter());
        }
    }

    public static void setBalanceDateTime(BalanceInfo balanceInfo, LocalDateTime balanceDateTime) {
        balanceInfo.setBalanceDateTime(balanceDateTime);
    }

    public static void setBalanceDate(BalanceInfo balanceInfo, LocalDate balanceDate) {
        balanceInfo.setBalanceDateTime(balanceDate.atTime(0, 0));
    }

    public static void setBalanceDate(BalanceInfo balanceInfo, String resDateTimeStr, DateTimeFormatter formatter) {
        try {
            BalanceUtil.setBalanceDate(balanceInfo, LocalDate.parse(resDateTimeStr, formatter));
        }
        catch (Exception e) {
            balanceInfo.setError(BalanceUtils.wrongDateFormatter());
        }
    }

    public static void setBalance(BalanceInfo balanceInfo, String value, BalanceUtils.Verification verification) {
        if (verification.apply(value)) {
            balanceInfo.setCurrentBalance(new BigDecimal(value));
        } else {
            balanceInfo.setError(verification.message());
        }
    }

    public static void setBalance(BalanceInfo balanceInfo, String value, BalanceUtils.Verification verification, int decimal) {
        if (decimal == 0) {
            decimal = 1;
        }
        if (verification.apply(value)) {
            balanceInfo.setCurrentBalance(BalanceUtil.scale(value, decimal));
        } else {
            balanceInfo.setError(verification.message());
        }
    }

    public static BigDecimal scale(String value, int decimal) {
        if (decimal == 0) {
            decimal = 1;
        }
        try {
            return new BigDecimal(value).divide(new BigDecimal(decimal), 2, 0);
        }
        catch (Exception e) {
            return null;
        }
    }
}

