/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.MutexRequest;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.ebBusiness.serviceHelper.AppCacheServiceHelper;

public class AppCacheMutexRequestService {
    private IFormView iFormView;
    private String mutexCacheKey;
    private Log logger = LogFactory.getLog(AppCacheMutexRequestService.class);

    public AppCacheMutexRequestService(IFormView iFormView, String mutexCacheKey) {
        this.iFormView = iFormView;
        this.mutexCacheKey = mutexCacheKey;
    }

    public boolean requestMutex(String mutexKey) {
        return this.requestMutex(mutexKey, null);
    }

    public boolean requestMutex(String mutexKey, String failTips) {
        return this.batchRequestMutex(Collections.singleton(mutexKey), failTips);
    }

    public boolean batchRequestMutex(Set<String> mutexKeys) {
        return this.batchRequestMutex(mutexKeys, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean batchRequestMutex(Set<String> mutexKeys, String failTips) {
        if (StringUtils.isEmpty((CharSequence)this.mutexCacheKey) || mutexKeys == null || this.getView() == null) {
            return true;
        }
        Class<AppCacheMutexRequestService> clazz = AppCacheMutexRequestService.class;
        synchronized (AppCacheMutexRequestService.class) {
            HashMap<String, String> mutexCache = AppCacheServiceHelper.get(this.getMutexCacheKey(), Map.class);
            if (mutexCache == null) {
                mutexCache = new HashMap<String, String>(16);
            }
            String currentUser = RequestContext.get().getUserName();
            HashSet<String> lockHolders = new HashSet<String>(16);
            boolean updateCache = false;
            boolean success = true;
            for (String mutexKey : mutexKeys) {
                if (mutexCache.containsKey(mutexKey)) {
                    String[] info = ((String)mutexCache.get(mutexKey)).split("#####");
                    String pageId = info[0];
                    if (!ObjectUtils.isEmpty((Object)this.getView().getParentView()) && this.getView().getParentView().existView(pageId)) {
                        if (currentUser.equals(info[1])) continue;
                        lockHolders.add(info[1]);
                        success = false;
                        this.logger.info("batchRequestMutex failed, mutexKey=" + mutexKey + ",currentUser=" + currentUser + ",info=" + (String)mutexCache.get(mutexKey));
                        continue;
                    }
                    mutexCache.remove(mutexKey);
                    updateCache = true;
                    this.logger.info("batchRequestMutex invalid pageId, remove mutexKey=" + mutexKey + ",currentUser=" + currentUser + ",info=" + (String)mutexCache.get(mutexKey));
                    continue;
                }
                mutexCache.put(mutexKey, this.getView().getPageId() + "#####" + currentUser);
                updateCache = true;
                this.logger.info("batchRequestMutex updated mutexKey=" + mutexKey + ",value=" + this.getView().getPageId() + "#####" + currentUser);
            }
            if (updateCache) {
                AppCacheServiceHelper.put(this.getMutexCacheKey(), mutexCache);
            }
            if (!lockHolders.isEmpty()) {
                String infos = failTips == null ? ResManager.loadResFormat((String)"\u7528\u6237 %1 \u6b63\u5728\u7f16\u8f91\uff0c\u53ea\u80fd\u67e5\u770b\u3002", (String)"AppCacheMutexRequestService_0", (String)"epm-eb-spread", (Object[])new Object[]{lockHolders}) : String.format(failTips, lockHolders);
                this.getView().getPageCache().put("excellock", infos);
                this.getView().showTipNotification(infos, Integer.valueOf(3000));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return success;
        }
    }

    public boolean releaseMutexLock(String mutexKey, boolean ischeckview) {
        return this.batchReleaseMutexLock(Collections.singleton(mutexKey), ischeckview);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean batchReleaseMutexLock(Set<String> mutexKeys, boolean ischeckview) {
        if (StringUtils.isEmpty((CharSequence)this.mutexCacheKey) || mutexKeys == null || mutexKeys.isEmpty()) {
            return true;
        }
        boolean success = false;
        Class<AppCacheMutexRequestService> clazz = AppCacheMutexRequestService.class;
        synchronized (AppCacheMutexRequestService.class) {
            Map mutexCache = AppCacheServiceHelper.get(this.getMutexCacheKey(), Map.class);
            for (String mutexKey : mutexKeys) {
                if (mutexCache == null || mutexCache.get(mutexKey) == null) continue;
                String[] info = ((String)mutexCache.get(mutexKey)).split("#####");
                String pageId = this.getView().getPageId();
                if (!ischeckview || info[0].equals(pageId)) {
                    mutexCache.remove(mutexKey);
                    success = true;
                    this.logger.info("batchReleaseMutexLock removed mutexKey=" + mutexKey + ", currentUser=" + RequestContext.get().getUserName());
                    continue;
                }
                this.logger.info("batchReleaseMutexLock missed removing mutexKey=" + mutexKey + ", ischeckview=" + ischeckview + ", currentUser=" + RequestContext.get().getUserName());
            }
            AppCacheServiceHelper.put(this.getMutexCacheKey(), mutexCache);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceReleaseMutex(boolean isClearAll) {
        Class<AppCacheMutexRequestService> clazz = AppCacheMutexRequestService.class;
        synchronized (AppCacheMutexRequestService.class) {
            Map mutexCache = AppCacheServiceHelper.get(this.getMutexCacheKey(), Map.class);
            String userName = RequestContext.get().getUserName();
            if (isClearAll) {
                this.logger.info(userName + " forceReleaseMutex clearAll: mutexKey=" + mutexCache);
                AppCacheServiceHelper.put(this.getMutexCacheKey(), null);
            } else {
                String lockSufix = "#####" + userName;
                this.logger.info(userName + " forceReleaseMutex: mutexKey=" + mutexCache);
                if (mutexCache != null) {
                    Iterator it = mutexCache.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        if (entry == null || entry.getValue() == null || !((String)entry.getValue()).endsWith(lockSufix)) continue;
                        it.remove();
                    }
                    AppCacheServiceHelper.put(this.getMutexCacheKey(), mutexCache);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private String getMutexCacheKey() {
        return this.mutexCacheKey;
    }

    private IFormView getView() {
        return this.iFormView;
    }

    public void setiFormView(IFormView iFormView) {
        this.iFormView = iFormView;
    }
}

