/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.computing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebComputing.bizrule.BizRuleExecParam;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.BRExecStatusEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;

public class BizRuleExecStarter {
    private static final ThreadPool threadPool;
    private static WatchLogger log;

    public static boolean execBizRuleWhenOpen(Object templateId, BizRuleExecParam param) {
        return BizRuleExecStarter.execBizRule(templateId, param, "execwhenopen", null);
    }

    private static boolean execBizRule(Object templateId, BizRuleExecParam param, String property, ApplicationTypeEnum app) {
        boolean isFalse = false;
        QFilter filter = new QFilter("template", "=", templateId);
        boolean flag = StringUtils.isEmpty((String)property);
        long modelId = 0L;
        String modelNumber = null;
        DynamicObjectCollection bizRules = null;
        if (app != null && ApplicationTypeEnum.isEBOrBGMDOrBGBDOrBGM((ApplicationTypeEnum)app)) {
            Collection catalog = BusinessDataServiceHelper.loadFromCache((String)"eb_brallocateentity", (String)"id,model.id,model.number,catalog.id ", (QFilter[])new QFilter[]{filter}, (String)"execseq").values();
            if (catalog.size() < 1) {
                return false;
            }
            bizRules = new DynamicObjectCollection();
            QFilter statusQfilter1 = new QFilter("status", "=", (Object)"1");
            DynamicObject dyna = null;
            Iterator iterator = catalog.iterator();
            while (iterator.hasNext()) {
                DynamicObject doj;
                dyna = doj = (DynamicObject)iterator.next();
                QFilter catalogQfilter = new QFilter("catalog", "=", (Object)doj.getString("catalog.id"));
                bizRules.addAll(BusinessDataServiceHelper.loadFromCache((String)"eb_bizruleentity", (String)"id, name, number, content, processcatalog", (QFilter[])new QFilter[]{statusQfilter1, catalogQfilter}, (String)"executeseq").values());
            }
            if (dyna != null) {
                modelId = dyna.getLong("model.id");
                modelNumber = dyna.getString("model.number");
            }
        }
        if (bizRules == null || bizRules.size() < 1) {
            return false;
        }
        ArrayList bizRuleIdList = new ArrayList();
        bizRules.forEach(e -> bizRuleIdList.add(e.getLong("id")));
        ArrayList<Pair> bizRuleList = new ArrayList<Pair>();
        for (int i = 0; i < bizRules.size(); ++i) {
            String content = ((DynamicObject)bizRules.get(i)).getString("content");
            if (!StringUtils.isNotEmpty((String)content)) continue;
            bizRuleList.add(Pair.onePair((Object)((DynamicObject)bizRules.get(i)).getLong("id"), (Object)content));
        }
        if (bizRuleList.isEmpty()) {
            return false;
        }
        DynamicObject[] records = BizRuleExecStarter.createExecRecord((DynamicObject[])bizRules.toArray((Object[])new DynamicObject[0]), param, modelId);
        param.setBizRuleList(bizRuleList);
        ArrayList<BizRuleExecParam> excuteParams = new ArrayList<BizRuleExecParam>();
        excuteParams.add(param);
        Map<Long, String> result = OlapServiceHelper.excuteScript4ReportParams(modelNumber, excuteParams, app);
        for (DynamicObject record : records) {
            long bizRuleId = record.getLong("bizrule");
            String reason = result.get(bizRuleId);
            if (StringUtils.isNotEmpty((String)reason)) {
                record.set("execstatus", (Object)BRExecStatusEnum.FAILED.getIndex());
                record.set("endtime", (Object)System.currentTimeMillis());
                record.set("reason", (Object)reason);
                continue;
            }
            record.set("execstatus", (Object)BRExecStatusEnum.SUCCESS.getIndex());
            record.set("endtime", (Object)System.currentTimeMillis());
        }
        SaveServiceHelper.save((DynamicObject[])records);
        return true;
    }

    public static DynamicObject[] createExecRecord(DynamicObject[] bizRules, BizRuleExecParam param, Object modelId) {
        DynamicObject[] execInfos = new DynamicObject[bizRules.length];
        Map idMap = param.getIdParam();
        for (int i = 0; i < bizRules.length; ++i) {
            execInfos[i] = BusinessDataServiceHelper.newDynamicObject((String)"eb_brexecuteinfoentity");
            Long processId = bizRules[i].get("processcatalog") instanceof Long ? (Long)bizRules[i].get("processcatalog") : Long.valueOf(bizRules[i].getLong("processcatalog.id"));
            BizRuleExecStarter.setExecRecord(execInfos[i], modelId, bizRules[i].getLong("id"), (Long)idMap.get(DimTypesEnum.ENTITY), (Long)idMap.get(DimTypesEnum.SCENARIO), (Long)idMap.get(DimTypesEnum.YEAR), (Long)idMap.get(DimTypesEnum.PERIOD), (Long)idMap.get(DimTypesEnum.CURRENCY), processId);
        }
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])execInfos);
    }

    private static void setExecRecord(DynamicObject execInfo, Object modelId, Object bizRuleId) {
        execInfo.set("bizrule", bizRuleId);
        execInfo.set("model", modelId);
        execInfo.set("starttime", (Object)System.currentTimeMillis());
        execInfo.set("execstatus", (Object)BRExecStatusEnum.EXECUTING.getIndex());
        execInfo.set("executor", (Object)UserUtils.getUserId());
    }

    private static void setExecRecord(DynamicObject execInfo, Object modelId, Object bizRuleId, Long entity, Long scenario, Long year, Long period, Long currency, Long bizrulecatalog) {
        BizRuleExecStarter.setExecRecord(execInfo, modelId, bizRuleId);
        execInfo.set("entity", (Object)entity);
        execInfo.set("scenario", (Object)scenario);
        execInfo.set("year", (Object)year);
        execInfo.set("period", (Object)period);
        execInfo.set("currency", (Object)currency);
        execInfo.set("bizrulecatalog", (Object)bizrulecatalog);
    }

    static {
        log = BcmLogFactory.getWatchLogInstance(BizRuleExecStarter.class);
        threadPool = ThreadPools.newCachedThreadPool((String)"bg_BizRuleExecuteThreadPool");
    }
}

