/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.convert.ctx;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.Tuple;
import kd.epm.eb.common.ebcommon.common.enums.ChangewayEnum;
import kd.epm.eb.common.ebcommon.common.enums.ConvertFormulaEnum;
import kd.epm.eb.common.ebcommon.common.enums.DChangeTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.ExchangeEnum;
import kd.epm.eb.common.ebcommon.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.ebcommon.common.util.PeriodUtils;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.ebBusiness.convert.ctx.FixScopeParameter;
import kd.epm.eb.ebBusiness.convert.ctx.ICvtContext;
import kd.epm.eb.ebBusiness.convert.ctx.SimpleVo;
import kd.epm.eb.ebBusiness.convert.query.BaseConvertFormula;
import kd.epm.eb.ebBusiness.convert.query.ExchangeQueryService;
import kd.epm.eb.ebBusiness.convert.query.RateModel;
import kd.epm.eb.ebBusiness.exception.CvtExchangeException;
import kd.epm.eb.ebBusiness.olap.OrgRelaMembSupplier;
import kd.epm.eb.ebBusiness.serviceHelper.ConvertSchemeServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;
import kd.epm.eb.ebBusiness.sql.Row;

public class CvtContext
implements ICvtContext {
    private SimpleVo modelVo;
    private SimpleVo cvtCurrVo;
    private Map<String, Pair<String, String[]>> scopes = new HashMap<String, Pair<String, String[]>>();
    private List<String> selectDimKeys;
    private Map<String, ExchangeEnum> acctExchangeCache = new HashMap<String, ExchangeEnum>();
    private Map<String, ChangewayEnum> changeTypeWayCache = new HashMap<String, ChangewayEnum>();
    private Map<String, RateModel> rateModel = new HashMap<String, RateModel>();
    private Map<String, RateModel> preRateModel = new HashMap<String, RateModel>();
    private boolean willBeConvert = true;
    private FixScopeParameter fixScopeParameter;
    private List<Pair<String[], Object>> saveValPairs = new ArrayList<Pair<String[], Object>>();
    private DChangeTypeEnum dchangeTypeEnum = null;
    private String prePeriod;
    private Map<String, ConvertFormulaEnum> convertFormulaType;
    private String[] exchangeTypeDefaultFilter;
    private String orgRelaMemb;
    private boolean isNeedMonitorDataStatus = true;
    private Map<Object, Object> userDefineData;
    private Object templateId;
    private Map<String, Tuple<String, BigDecimal, BigDecimal>> converPathRateMap = new HashMap<String, Tuple<String, BigDecimal, BigDecimal>>(16);
    private List<String> noclearChangeTypes;

    public CvtContext(SimpleVo modelVo, SimpleVo cvtCurrVo, FixScopeParameter fixScopeParameter) {
        this.modelVo = modelVo;
        this.cvtCurrVo = cvtCurrVo;
        this.fixScopeParameter = fixScopeParameter;
        this.init();
    }

    private void init() {
        this.addFixedScope();
        this.initCondition();
    }

    protected void initCondition() {
        this.initQueryScenarioInputChangeType();
        this.initConvertFormulaType();
        this.initExchangeTypeDefaultFilter();
    }

    protected void initConvertFormulaType() {
        BaseConvertFormula baseConvertFormula = ConvertSchemeServiceHelper.getBaseConvertFormula(this.getModelVo().id, this.getScenarioVo().id);
        this.convertFormulaType = new HashMap<String, ConvertFormulaEnum>();
        this.convertFormulaType.put("balance", ConvertFormulaEnum.getConvertFormulaByIndex((int)baseConvertFormula.getBalance()));
        this.convertFormulaType.put("profitloss", ConvertFormulaEnum.getConvertFormulaByIndex((int)baseConvertFormula.getProfitloss()));
        this.convertFormulaType.put("rights", ConvertFormulaEnum.getConvertFormulaByIndex((int)baseConvertFormula.getRights()));
    }

    protected void initExchangeTypeDefaultFilter() {
        this.exchangeTypeDefaultFilter = this.queryCanCvtChangeType();
    }

    protected void initQueryScenarioInputChangeType() {
        this.dchangeTypeEnum = ExchangeQueryService.queryScenarioInputChangType(this);
    }

    private String[] queryCanCvtChangeType() {
        ArrayList nums = new ArrayList();
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.getModelVo().id);
        qf.add("isleaf", "=", (Object)Character.valueOf('1'));
        qf.add("changeway", "not in", Arrays.asList(ChangewayEnum.NONE.index, ChangewayEnum.ACCOUNT.index, ChangewayEnum.EARLYYEARTURN.index));
        qf.add("number", "!=", (Object)"BFLY");
        qf.add("number", "!=", (Object)"BOP");
        BusinessDataServiceHelper.loadFromCache((String)"epm_changetypemembertree", (String)"number", (QFilter[])qf.toArray()).values().forEach(d -> nums.add(d.getString("number")));
        return nums.toArray(new String[0]);
    }

    protected void addFixedScope() {
        this.fixScopeParameter.iterator().forEachRemaining(c -> {
            if (c.getKey() == DimTypesEnum.ENTITY) {
                this.addScope(((DimTypesEnum)c.getKey()).getNumber(), (Pair<String, String[]>)Pair.onePair((Object)((DimTypesEnum)c.getKey()).getNumber(), (Object)this.toStringArray(((SimpleVo)c.getValue()).number, this.getRelaWithParentMemb())));
            } else {
                this.addScope(((DimTypesEnum)c.getKey()).getNumber(), (Pair<String, String[]>)Pair.onePair((Object)((DimTypesEnum)c.getKey()).getNumber(), (Object)this.toStringArray(((SimpleVo)c.getValue()).number)));
            }
        });
    }

    protected final String[] toStringArray(String ... s) {
        return s;
    }

    @Override
    public void addScope(String dimNum, Pair<String, String[]> scope) {
        this.scopes.put(dimNum, scope);
    }

    @Override
    public SimpleVo getCvtCurrencyVo() {
        return this.cvtCurrVo;
    }

    @Override
    public SimpleVo getSrcCurrencyVo() {
        return this.fixScopeParameter.getFixScopeByDimType(DimTypesEnum.CURRENCY);
    }

    @Override
    public SimpleVo getCvtOrgVo() {
        return this.fixScopeParameter.getFixScopeByDimType(DimTypesEnum.ENTITY);
    }

    @Override
    public SimpleVo getModelVo() {
        return this.modelVo;
    }

    @Override
    public SimpleVo getCvtYearVo() {
        return this.fixScopeParameter.getFixScopeByDimType(DimTypesEnum.YEAR);
    }

    @Override
    public SimpleVo getCvtPeriodVo() {
        return this.fixScopeParameter.getFixScopeByDimType(DimTypesEnum.PERIOD);
    }

    @Override
    public SimpleVo getScenarioVo() {
        return this.fixScopeParameter.getFixScopeByDimType(DimTypesEnum.SCENARIO);
    }

    @Override
    public Collection<Pair<String, String[]>> getScopes() {
        return this.scopes.values();
    }

    protected boolean containsScope(String dimKey) {
        return this.scopes.containsKey(dimKey);
    }

    protected void removeScope(String dimKey) {
        Pair<String, String[]> remove = this.scopes.remove(dimKey);
        this.put("scopes_" + dimKey, remove);
    }

    @Override
    public String[] getSelectDimKes() {
        if (this.selectDimKeys == null) {
            this.selectDimKeys = DimensionServiceHelper.getDimensionNumListByModel(this.modelVo.id);
        }
        return this.selectDimKeys.toArray(new String[0]);
    }

    @Override
    public String[] getMeasures() {
        return new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()};
    }

    @Override
    public String[] getFixDims() {
        ArrayList dims = new ArrayList();
        this.fixScopeParameter.iterator().forEachRemaining(e -> {
            if (e.getKey() != DimTypesEnum.ENTITY && e.getKey() != DimTypesEnum.CURRENCY) {
                dims.add(((DimTypesEnum)e.getKey()).getNumber());
            }
        });
        return dims.toArray(new String[0]);
    }

    @Override
    public void add2cacheAccountCvtExchange(Map<String, ExchangeEnum> cacheItems) {
        this.acctExchangeCache.putAll(cacheItems);
    }

    @Override
    public void add2CacheChangeTypeChangeWay(Map<String, ChangewayEnum> cacheItems) {
        this.changeTypeWayCache.putAll(cacheItems);
    }

    @Override
    public ExchangeEnum getCvtExchangeOfAccount(String acctNum) {
        return this.acctExchangeCache.get(acctNum);
    }

    @Override
    public ChangewayEnum getChangeWayOfChangeType(String changeTypeNum) {
        return this.changeTypeWayCache.get(changeTypeNum);
    }

    @Override
    public void setRateModel(RateModel rate) {
        this.rateModel.put(this.getCvtCurrencyVo().number, rate);
    }

    @Override
    public RateModel getRateModel(String cvtCurrencyNum) {
        if (!this.rateModel.containsKey(cvtCurrencyNum)) {
            try {
                this.rateModel.put(cvtCurrencyNum, ExchangeQueryService.queryExchange(this, true, cvtCurrencyNum));
            }
            catch (Exception e) {
                this.rateModel.put(cvtCurrencyNum, null);
                throw e;
            }
        }
        if (this.rateModel.get(cvtCurrencyNum) == null) {
            throw new CvtExchangeException(ResManager.loadResFormat((String)"\u8bf7\u7ef4\u62a4\u539f\u5e01[%1]\u5bf9\u6298\u7b97\u5e01[%2]\u7684\u6c47\u7387\u3002", (String)"CvtContext_0", (String)"epm-eb-spread", (Object[])new Object[]{this.getSrcCurrencyVo().number, cvtCurrencyNum}));
        }
        return this.rateModel.get(cvtCurrencyNum);
    }

    @Override
    public boolean willBeConvert() {
        return this.willBeConvert;
    }

    protected void setWillBeNotConvert() {
        this.willBeConvert = false;
    }

    @Override
    public void addSaveValPair(Pair<String[], Object> p) {
        this.saveValPairs.add(p);
    }

    @Override
    public List<Pair<String[], Object>> getSaveValPairs() {
        return this.saveValPairs;
    }

    @Override
    public DChangeTypeEnum getScenarioInputChangType() {
        return this.dchangeTypeEnum;
    }

    @Override
    public String getPrePeriod() {
        if (this.prePeriod == null) {
            this.prePeriod = (String)PeriodUtils.getLastPeriod((String)this.getModelVo().number, (String)this.getCvtPeriodVo().number, (boolean)true).get();
        }
        return this.prePeriod;
    }

    @Override
    public ConvertFormulaEnum getConvertFormulaEnumByType(String type) {
        return this.convertFormulaType.get(type);
    }

    @Override
    public String[] getExchangeTypeFilter() {
        return this.exchangeTypeDefaultFilter;
    }

    @Override
    public String getRelaWithParentMemb() {
        if (StringUtils.isEmpty((String)this.orgRelaMemb)) {
            this.orgRelaMemb = new OrgRelaMembSupplier(this.getCvtOrgVo().id, this.getCvtOrgVo().number, this.getModelVo().id).access(this.getCvtOrgVo().number);
        }
        return this.orgRelaMemb;
    }

    @Override
    public void removeHasQueryAccountCvtExchange(Set<String> newList) {
        if (newList == null) {
            return;
        }
        newList.removeAll(this.acctExchangeCache.keySet());
    }

    @Override
    public void removeHasQueryChangeTypeChangeWay(Set<String> newList) {
        if (newList == null) {
            return;
        }
        newList.removeAll(this.changeTypeWayCache.keySet());
    }

    @Override
    public boolean isNeedMonitorDataStatus() {
        return this.isNeedMonitorDataStatus;
    }

    @Override
    public void setNeedMonitorDataStatus(boolean isMonitored) {
        this.isNeedMonitorDataStatus = isMonitored;
    }

    @Override
    public RateModel getPreRateModel(String cvtCurrencyNum) {
        if (!this.preRateModel.containsKey(cvtCurrencyNum)) {
            this.preRateModel.put(cvtCurrencyNum, ExchangeQueryService.queryExchange(this, false, cvtCurrencyNum));
        }
        return this.preRateModel.get(cvtCurrencyNum);
    }

    @Override
    public boolean isFirstPeriod() {
        return PeriodUtils.isFirstPeriod((String)this.getCvtPeriodVo().number);
    }

    @Override
    public boolean filterRecord(Row row, String ... acctType) {
        return false;
    }

    @Override
    public boolean isConvert4Checking() {
        return false;
    }

    @Override
    public <K, V> void put(K k, V v) {
        if (this.userDefineData == null) {
            this.userDefineData = new HashMap<Object, Object>();
        }
        this.userDefineData.put(k, v);
    }

    @Override
    public <K, V> V get(K k) {
        if (this.userDefineData == null) {
            return null;
        }
        return (V)this.userDefineData.get(k);
    }

    @Override
    public SimpleVo switchCvtCurrencyVo(SimpleVo newVal) {
        SimpleVo oldVal = this.cvtCurrVo;
        this.cvtCurrVo = newVal;
        return oldVal;
    }

    public void setTemplateId(Object templateId) {
        this.templateId = templateId;
    }

    @Override
    public Object getTemplateId() {
        return this.templateId;
    }

    @Override
    public List<String> getNoClearChangeType() {
        if (this.noclearChangeTypes == null) {
            this.noclearChangeTypes = BusinessDataServiceHelper.loadFromCache((String)"epm_changetypemembertree", (String)"number", (QFilter[])new QFBuilder("model", "=", (Object)this.getModelVo().id).add("number", "in", (Object)new String[]{"BOP"}).or("changeway", "=", (Object)ChangewayEnum.EARLYYEARTURN.index).toArray()).values().stream().map(d -> d.getString("number")).collect(Collectors.toList());
        }
        return this.noclearChangeTypes;
    }

    @Override
    public Map<String, Tuple<String, BigDecimal, BigDecimal>> getConvertPathRate() {
        return this.converPathRateMap;
    }

    @Override
    public void addConvertPathRate(String key, Tuple<String, BigDecimal, BigDecimal> value) {
        this.converPathRateMap.put(key, value);
    }
}

