/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.convert.ctx;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.Recorder;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.ebcommon.common.util.ConvertScopeUtil;
import kd.epm.eb.ebBusiness.convert.ctx.CvtContext;
import kd.epm.eb.ebBusiness.convert.ctx.FixScopeParameter;
import kd.epm.eb.ebBusiness.convert.ctx.SimpleVo;
import kd.epm.eb.ebBusiness.permission.cache.MembRangeItem;
import kd.epm.eb.ebBusiness.serviceHelper.TemplateServiceHelper;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;

public class ReportCvtContext
extends CvtContext {
    public ReportCvtContext(SimpleVo modelVo, SimpleVo cvtCurrVo, FixScopeParameter fixScopeParameter, Object templateId) {
        super(modelVo, cvtCurrVo, fixScopeParameter);
        this.addOtherScope(TemplateServiceHelper.getTemplateModelById(templateId));
    }

    public ReportCvtContext(SimpleVo modelVo, SimpleVo cvtCurrVo, FixScopeParameter fixScopeParameter, TemplateModel model) {
        super(modelVo, cvtCurrVo, fixScopeParameter);
        this.addOtherScope(model);
    }

    public ReportCvtContext(SimpleVo modelVo, SimpleVo cvtCurrVo, FixScopeParameter fixScopeParameter) {
        super(modelVo, cvtCurrVo, fixScopeParameter);
    }

    protected void addCommonScope(TemplateModel model) {
        this.setTemplateId(model.getId());
        model.getViewPointDimensionEntries().forEach(v -> {
            String dimNum = v.getDimension().getNumber();
            if (!this.containsScope(dimNum)) {
                this.addScope(v.getDimension().getNumber(), (Pair<String, String[]>)Pair.onePair((Object)dimNum, (Object)this.toStringArray(v.getMember().getNumber())));
            }
        });
        model.getPageDimensionEntries().forEach(p -> {
            String dimNum = p.getDimension().getNumber();
            if (!this.containsScope(dimNum) && this.isIncludeDim(dimNum)) {
                ArrayList scopeMembs = new ArrayList();
                p.getMembers().forEach(m -> new MembRangeItem(m.getDataEntityNumber(), m.getId(), m.getNumber(), RangeEnum.getRangeByVal((int)m.getScope()), false, model.getModelId()).matchItems(c -> scopeMembs.add(c.number)));
                if (!scopeMembs.isEmpty()) {
                    this.addScope(dimNum, (Pair<String, String[]>)Pair.onePair((Object)dimNum, (Object)scopeMembs.toArray(new String[0])));
                }
            }
        });
        model.getPagePropEntries().forEach(p -> {
            String dimNum = p.getDimension().getNumber();
            if (!this.containsScope(dimNum) && this.isIncludeDim(dimNum)) {
                ArrayList scopeMembs = new ArrayList();
                p.getAllMembProperties().forEach(m -> new MembRangeItem(p.getDimension().getMemberEntityNumber(), m.getId(), m.getNumber(), RangeEnum.getRangeByVal((int)m.getScope()), true, model.getModelId()).matchItems(c -> scopeMembs.add(c.number)));
                if (!scopeMembs.isEmpty()) {
                    this.addScope(dimNum, (Pair<String, String[]>)Pair.onePair((Object)dimNum, (Object)scopeMembs.toArray(new String[0])));
                }
            }
        });
    }

    private void addOtherScope(TemplateModel model) {
        boolean isFalse = false;
        this.addCommonScope(model);
        HashMultimap set = HashMultimap.create();
        Recorder hasCross = new Recorder((Object)isFalse);
        model.getAreaRangeEntries().forEach(e -> {
            e.getRowDimEntries().forEach(r -> {
                String dimNum = r.getDimension().getNumber();
                if (!this.containsScope(dimNum) && this.isIncludeDim(dimNum)) {
                    r.getMembers().forEach(m -> set.put((Object)r.getDimension().getNumber(), (Object)m.getNumber()));
                }
            });
            e.getColDimEntries().forEach(c -> {
                String dimNum = c.getDimension().getNumber();
                if (!this.containsScope(dimNum) && this.isIncludeDim(dimNum)) {
                    c.getMembers().forEach(m -> set.put((Object)c.getDimension().getNumber(), (Object)m.getNumber()));
                }
            });
            if (!((Boolean)hasCross.getRecord()).booleanValue()) {
                hasCross.setRecord((Object)(!e.getRowDimEntries().isEmpty() && !e.getColDimEntries().isEmpty() ? 1 : 0));
            }
        });
        if (set.isEmpty() && !((Boolean)hasCross.getRecord()).booleanValue()) {
            this.setWillBeNotConvert();
        } else {
            set.asMap().entrySet().forEach(e -> this.addScope((String)e.getKey(), (Pair<String, String[]>)Pair.onePair(e.getKey(), (Object)((Collection)e.getValue()).toArray(new String[0]))));
        }
        this.removeScope(DimTypesEnum.CHANGETYPE.getNumber());
    }

    protected boolean isIncludeDim(String dimNum) {
        return ConvertScopeUtil.isIncludeDim((String)dimNum);
    }
}

