/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.convert.factor;

import kd.epm.eb.common.ebcommon.common.PresetConstant;
import kd.epm.eb.ebBusiness.convert.ctx.ICvtContext;
import kd.epm.eb.ebBusiness.convert.factor.CvtFactor;
import kd.epm.eb.ebBusiness.exception.CvtExchangeException;
import kd.epm.eb.ebBusiness.sql.MDResultSetMetaData;

public class CvtFactorParser {
    public static String[] parseParamsByFactor(CvtFactor factor, MDResultSetMetaData metadata, ICvtContext ctx) {
        String[] params = factor.getParams();
        switch (factor.getFactor()) {
            case PeriodSumAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "CurrentPeriod", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                break;
            }
            case PeriodSumCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "CurrentPeriod", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case PeriodInputCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "CurrentPeriod", metadata);
                CvtFactorParser.replayAudittrialBy(params, "EntityInput", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case PeriodAdjCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "CurrentPeriod", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ADJE", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case PeriodYDTSumAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                break;
            }
            case PreYDTSumCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayPeriodBy(params, ctx.getPrePeriod(), metadata);
                break;
            }
            case PeriodYDTSumCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case PeriodYDTInputAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayAudittrialBy(params, "EntityInput", metadata);
                break;
            }
            case PeriodYDTInputCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayAudittrialBy(params, "EntityInput", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case EndPeriodInputCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "EndingBalance", metadata);
                CvtFactorParser.replayAudittrialBy(params, "EntityInput", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case EndPeriodSumAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "EndingBalance", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                break;
            }
            case PreEndPeriodSumCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "EndingBalance", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayPeriodBy(params, ctx.getPrePeriod(), metadata);
                break;
            }
            case PreBeginYSumCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "BBOY", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayPeriodBy(params, ctx.getPrePeriod(), metadata);
                break;
            }
            case BeginYSumAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "BBOY", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                break;
            }
            case BflySumCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "BFLY", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case BeginYSumCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "BBOY", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case PreEndPeriodSumAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "EndingBalance", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                CvtFactorParser.replayPeriodBy(params, ctx.getPrePeriod(), metadata);
                break;
            }
            case PeriodYDTAdjAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ADJE", metadata);
                break;
            }
            case Rate: 
            case PreRate: {
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case PreYDTAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayPeriodBy(params, ctx.getPrePeriod(), metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getSrcCurrencyVo().number, metadata);
                break;
            }
            case PreYDTCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayPeriodBy(params, ctx.getPrePeriod(), metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case PeriodYDTAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getSrcCurrencyVo().number, metadata);
                break;
            }
            case PeriodYDTCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case PeriodCurrPeriodAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "CurrentPeriod", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getSrcCurrencyVo().number, metadata);
                break;
            }
            case PeriodCurrPeriodCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "CurrentPeriod", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case beginPeriodSumAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "BOP", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getSrcCurrencyVo().number, metadata);
                break;
            }
            case beginPeriodInputCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "BOP", metadata);
                CvtFactorParser.replayAudittrialBy(params, "EntityInput", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case beginPeriodSumCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "BOP", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case CurrPeriodSumAmount: {
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                break;
            }
            case CurrPeriodSumCvtAmount: {
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case CurrInputCvtAmount: {
                CvtFactorParser.replayAudittrialBy(params, "EntityInput", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case PrePeriodSumCvtAmount: {
                CvtFactorParser.replayPeriodBy(params, ctx.getPrePeriod(), metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case PrePeriodSumAmount: {
                CvtFactorParser.replayPeriodBy(params, ctx.getPrePeriod(), metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata);
                break;
            }
            default: {
                throw new CvtExchangeException(String.format("not support CvtFactor:%s", factor.getFactor().name()));
            }
        }
        factor.setParams(params);
        return params;
    }

    public static void replaceBy(String[] src, int idx, String instr) {
        src[idx] = instr;
    }

    public static void replayCurrencyBy(String[] src, String instr, MDResultSetMetaData metadata) {
        CvtFactorParser.replaceBy(src, metadata.getColIndex(PresetConstant.CURRENCY_DIM), instr);
    }

    public static void replayPeriodBy(String[] src, String instr, MDResultSetMetaData metadata) {
        CvtFactorParser.replaceBy(src, metadata.getColIndex(PresetConstant.PERIOD_DIM), instr);
    }

    public static void replayFyBy(String[] src, String instr, MDResultSetMetaData metadata) {
        CvtFactorParser.replaceBy(src, metadata.getColIndex(PresetConstant.FY_DIM), instr);
    }

    public static void replayChangeTypeBy(String[] src, String instr, MDResultSetMetaData metadata) {
        CvtFactorParser.replaceBy(src, metadata.getColIndex(PresetConstant.CHANGETYPE_DIM), instr);
    }

    public static void replayAudittrialBy(String[] src, String instr, MDResultSetMetaData metadata) {
        CvtFactorParser.replaceBy(src, metadata.getColIndex(PresetConstant.AUDITTRIAL_DIM), instr);
    }

    public static String getParamValueByMetaData(String[] params, String dimNum, MDResultSetMetaData metadata) {
        return params[metadata.getColIndex(dimNum)];
    }
}

