/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.convert.query;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.PresetConstant;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.DChangeTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.ebcommon.common.graph.Edge;
import kd.epm.eb.common.ebcommon.common.graph.ListDGraph;
import kd.epm.eb.common.ebcommon.common.util.PeriodUtils;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.convert.ctx.ICvtContext;
import kd.epm.eb.ebBusiness.convert.query.RateModel;
import kd.epm.eb.ebBusiness.exception.CvtExchangeException;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.ModelServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.QueryDimensionServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ExchangeQueryService {
    public static final Log log = LogFactory.getLog(ExchangeQueryService.class);
    private static final String[] rateColumns4Olap = new String[]{"beginyear", "boyaveragerate", "boyuserdefinedrate", "periodend", "average", "userdefine"};
    private static final String[] rateColumns = new String[]{"boyaveragerate", "beginyear", "periodend", "average", "userdefine", "boyuserdefinedrate", "userdefinedrate1", "userdefinedrate2", "userdefinedrate3", "userdefinedrate4", "userdefinedrate5", "userdefinedrate6", "userdefinedrate7", "userdefinedrate8", "userdefinedrate9", "userdefinedrate10", "boyuserdefinedrate1", "boyuserdefinedrate2", "boyuserdefinedrate3", "boyuserdefinedrate4", "boyuserdefinedrate5", "boyuserdefinedrate6", "boyuserdefinedrate7", "boyuserdefinedrate8", "boyuserdefinedrate9", "boyuserdefinedrate10"};
    private static final String RatePreset = "RatePreset";

    public static RateModel queryExchangeByGiven(ICvtContext ctx, long orgId, boolean isCurrentPeriod, String cvtCurrencyNum, String srcCurrencyNum) {
        long scenarioId = ctx.getScenarioVo().id;
        long yearId = ctx.getCvtYearVo().id;
        long periodId = 0L;
        long modelId = ctx.getModelVo().id;
        String periodNum = ctx.getCvtPeriodVo().number;
        String fyNum = ctx.getCvtYearVo().number;
        if (isCurrentPeriod) {
            periodId = ctx.getCvtPeriodVo().id;
        } else {
            DynamicObject periodDyna = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_periodmembertree", (String)"id,number", (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).add("number", "=", (Object)ctx.getPrePeriod()).toArray());
            periodId = periodDyna.getLong("id");
            periodNum = periodDyna.getString("number");
            if (PeriodUtils.isFirstPeriod((String)ctx.getCvtPeriodVo().number)) {
                Optional optYear = PeriodUtils.getLastYear((String)ctx.getModelVo().number, (String)ctx.getCvtYearVo().number);
                if (optYear.isPresent()) {
                    DynamicObject fyDyna = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_yearmembertree", (String)"id,number", (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).add("number", "=", optYear.get()).toArray());
                    yearId = fyDyna.getLong("id");
                    fyNum = fyDyna.getString("number");
                } else {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u5f53\u524d\u5e74[%1]\u7684\u4e0a\u4e00\u5e74\u7b2c[%2]\u671f\u6c47\u7387\u65f6\uff0c\u627e\u4e0d\u5230\u5e74\u6210\u5458\u3002", (String)"ExchangeQueryService_0", (String)"epm-eb-spread", (Object[])new Object[]{ctx.getCvtYearVo().number, ctx.getPrePeriod()}));
                }
            }
        }
        return ExchangeQueryService.queryExchangeImpl(modelId, scenarioId, yearId, periodId, orgId, srcCurrencyNum, cvtCurrencyNum, fyNum, periodNum);
    }

    public static RateModel queryExchange(ICvtContext ctx, boolean isCurrentPeriod, String cvtCurrencyNum) {
        return ExchangeQueryService.queryExchangeByGiven(ctx, ctx.getCvtOrgVo().id, isCurrentPeriod, cvtCurrencyNum, ctx.getSrcCurrencyVo().number);
    }

    private static RateModel queryExchangeImpl(long modelId, long scenarioId, long yearId, long periodId, long orgId, String srcCurrencyNum, String cvtCurrencyNum, String fyNum, String periodNum) {
        DynamicObject ratedot = ExchangeQueryService.queryTriangleExchangeRate(modelId, scenarioId, yearId, periodId, orgId, srcCurrencyNum, cvtCurrencyNum);
        if (ratedot != null) {
            boolean isMultiply;
            DynamicObject rightObj = null;
            Long fromid = ratedot.getLong("fromid");
            if (fromid == 0L) {
                rightObj = ratedot;
                isMultiply = true;
            } else {
                isMultiply = false;
                QFilter qfilterid = new QFilter("id", "=", (Object)fromid);
                rightObj = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getSelectFields(), (QFilter[])new QFilter[]{qfilterid});
                if (rightObj == null) {
                    throw new CvtExchangeException(ResManager.loadKDString((String)"\u6c47\u7387\u6570\u636e\u6709\u8bef", (String)"ExchangeQueryService_1", (String)"epm-eb-spread", (Object[])new Object[0]));
                }
            }
            HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>(26);
            rateMap.put("BOYRate", rightObj.getBigDecimal("beginyear"));
            rateMap.put("BOYAverageRate", rightObj.getBigDecimal("boyaveragerate"));
            rateMap.put("BOYUserdefinedRate", rightObj.getBigDecimal("boyuserdefinedrate"));
            rateMap.put("ClosingRate", rightObj.getBigDecimal("periodend"));
            rateMap.put("AverageRate", rightObj.getBigDecimal("average"));
            rateMap.put("UserdefinedRate", rightObj.getBigDecimal("userdefine"));
            for (int i = 1; i <= 10; ++i) {
                rateMap.put("BOYUserdefinedRate" + i, rightObj.getBigDecimal("boyuserdefinedrate" + i));
                rateMap.put("UserdefinedRate" + i, rightObj.getBigDecimal("userdefinedrate" + i));
            }
            RateModel ratemodel = new RateModel(rightObj.getBigDecimal("beginyear"), rightObj.getBigDecimal("boyaveragerate"), rightObj.getBigDecimal("boyuserdefinedrate"), rightObj.getBigDecimal("periodend"), rightObj.getBigDecimal("average"), rightObj.getBigDecimal("userdefine"), rateMap, isMultiply, rightObj.getInt("precision"), rightObj.getString("entity.number"));
            return ratemodel;
        }
        throw new CvtExchangeException(ResManager.loadResFormat((String)"\u8bf7\u7ef4\u62a4[%1]\u5e74[%2]\u671f(%3->%4)\u7684\u6c47\u7387\u3002", (String)"ExchangeQueryService_2", (String)"epm-eb-spread", (Object[])new Object[]{fyNum, periodNum, srcCurrencyNum, cvtCurrencyNum}));
    }

    private static String getSelectFields() {
        return "beginyear,periodend,average,userdefine,boyaveragerate,boyuserdefinedrate,fromid,precision,entity.number,userdefinedrate1,userdefinedrate2,userdefinedrate3,userdefinedrate4,userdefinedrate5,userdefinedrate6,userdefinedrate7,userdefinedrate8,userdefinedrate9,userdefinedrate10,boyuserdefinedrate1,boyuserdefinedrate2,boyuserdefinedrate3,boyuserdefinedrate4,boyuserdefinedrate5,boyuserdefinedrate6,boyuserdefinedrate7,boyuserdefinedrate8,boyuserdefinedrate9,boyuserdefinedrate10,entity,model,scene,fy,period,triangle";
    }

    private static DynamicObject queryExchangeRate(long modelid, long scenarioid, long yearid, long periodid, long orgRateId, String srcCurrencyNum, String cvtCurrencyNum) {
        QFilter modelqfilter = new QFilter("model", "=", (Object)modelid);
        QFilter scenarioqfilter = new QFilter("scene", "=", (Object)scenarioid);
        QFilter yearfilter = new QFilter("fy", "=", (Object)yearid);
        QFilter periodfilter = new QFilter("period", "=", (Object)periodid);
        QFilter cvtorgfilter = new QFilter("entity", "=", (Object)orgRateId);
        QFilter srcCurrencyfilter = new QFilter("source.number", "=", (Object)srcCurrencyNum);
        QFilter cvtCurrencyfilter = new QFilter("target.number", "=", (Object)cvtCurrencyNum);
        String selectFields = ExchangeQueryService.getSelectFields();
        QFilter[] queryqfilter = new QFilter[]{modelqfilter, scenarioqfilter, yearfilter, periodfilter, cvtorgfilter, srcCurrencyfilter, cvtCurrencyfilter};
        DynamicObject ratedot = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_exchagerate", (String)selectFields, (QFilter[])queryqfilter);
        return ratedot;
    }

    public static Map<String, Object> queryOrgRate(Long modelId, Long orgId, Long scenarioId, Long yearId, Long periodId) {
        String key = "rateScheme|" + orgId.toString() + "|" + scenarioId.toString() + "|" + yearId.toString() + "|" + periodId.toString();
        HashMap<String, Object> rateScheme = (HashMap<String, Object>)ThreadCache.get((Object)key);
        if (rateScheme != null) {
            return rateScheme;
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"epm_entitymembertree", (String)"number, level");
        boolean isLevel2 = org.getInt("level") == 2;
        String orgNumber = org.getString("number");
        rateScheme = new HashMap<String, Object>();
        ThreadCache.put((Object)key, rateScheme);
        QFilter modelQfilter = new QFilter("model", "=", (Object)modelId);
        QFilter orgNumberQfilter = new QFilter("number", "=", (Object)RatePreset);
        DynamicObject presetorg = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_entitymembertree", (String)"id, name, number", (QFilter[])new QFilter[]{modelQfilter, orgNumberQfilter});
        if (presetorg != null) {
            rateScheme.put("exchangerate", presetorg.getLong("id"));
            rateScheme.put("isautoconvert", isLevel2 ? Boolean.FALSE : Boolean.TRUE);
            return rateScheme;
        }
        throw new CvtExchangeException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u901a\u7528\u6c47\u7387\u65b9\u6848\u3002", (String)"ExchangeQueryService_3", (String)"epm-eb-spread", (Object[])new Object[0]));
    }

    public static DChangeTypeEnum queryScenarioInputChangType(ICvtContext ctx) {
        DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_scenemembertree", (String)"dchangetype", (QFilter[])new QFBuilder().add("id", "=", (Object)ctx.getScenarioVo().id).toArray());
        String dchangetype = dyna.getString("dchangetype");
        if (dchangetype == null || dchangetype.trim().equals("")) {
            dchangetype = "0";
        }
        return DChangeTypeEnum.valueof((String)dchangetype);
    }

    public static synchronized DynamicObject queryTriangleExchangeRate(long modelid, long scenarioid, long yearid, long periodid, long orgid, String srcCurrencyNum, String cvtCurrencyNum) {
        QFilter numberfilter;
        long orgRateId = (Long)ExchangeQueryService.queryOrgRate(modelid, orgid, scenarioid, yearid, periodid).get("exchangerate");
        DynamicObject nomalRate = ExchangeQueryService.queryExchangeRate(modelid, scenarioid, yearid, periodid, orgRateId, srcCurrencyNum, cvtCurrencyNum);
        QFilter modelfilter = new QFilter("model", "=", (Object)modelid);
        DynamicObject sourceProcess = QueryServiceHelper.queryOne((String)"epm_processmembertree", (String)"id,lockcurr.number as mediumnumber", (QFilter[])new QFilter[]{modelfilter, numberfilter = new QFilter("number", "=", (Object)srcCurrencyNum)});
        String lockcurrNumber = sourceProcess.getString("mediumnumber");
        if (!StringUtils.isEmpty((CharSequence)lockcurrNumber)) {
            QFilter[] rateExitFilter = ExchangeQueryService.createRateExtFilter(modelid, scenarioid, yearid, periodid, orgRateId, srcCurrencyNum, lockcurrNumber);
            DynamicObject lockRate = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getTriangleSelectFields(), (QFilter[])rateExitFilter);
            if (lockRate == null) {
                return null;
            }
            QFilter[] rateExitFilter2 = ExchangeQueryService.createRateExtFilter(modelid, scenarioid, yearid, periodid, orgRateId, lockcurrNumber, cvtCurrencyNum);
            DynamicObject lockRate2 = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getTriangleSelectFields(), (QFilter[])rateExitFilter2);
            if (lockRate2 == null) {
                return null;
            }
            DynamicObject triangleRateObject = ExchangeQueryService.getTriangleRateObject(lockRate, lockRate2, nomalRate);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{triangleRateObject});
            ExchangeQueryService.saveOrUpdateTriangle(triangleRateObject, srcCurrencyNum, cvtCurrencyNum);
            return triangleRateObject;
        }
        if (nomalRate != null && StringUtils.isBlank((CharSequence)nomalRate.getString("triangle"))) {
            return nomalRate;
        }
        return ExchangeQueryService.doTriangleRateConvert(modelid, scenarioid, yearid, periodid, orgRateId, srcCurrencyNum, cvtCurrencyNum, nomalRate);
    }

    private static void saveOrUpdateTriangle(DynamicObject triangleRateObject, String srcCurrencyNum, String cvtCurrencyNum) {
        ApplicationTypeEnum app;
        Pair rule;
        Map<String, String> dimensionNumbers = ExchangeQueryService.getDimensionNumber(triangleRateObject);
        Long modelId = triangleRateObject.get("model") instanceof DynamicObject ? Long.valueOf(((DynamicObject)triangleRateObject.get("model")).getLong("id")) : Long.valueOf(triangleRateObject.getLong("model"));
        QFilter modelFilter = new QFilter("id", "=", (Object)modelId);
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"number,isspptmultrule,isspptdatasort,defineddim", (QFilter[])new QFilter[]{modelFilter});
        String modelnum = model.getString("number");
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        Pair scene = Pair.onePair((Object)DimTypesEnum.SCENARIO.getNumber(), (Object)dimensionNumbers.get(DimTypesEnum.SCENARIO.getNumber()));
        Pair fy = Pair.onePair((Object)DimTypesEnum.YEAR.getNumber(), (Object)dimensionNumbers.get(DimTypesEnum.YEAR.getNumber()));
        Pair period = Pair.onePair((Object)DimTypesEnum.PERIOD.getNumber(), (Object)dimensionNumbers.get(DimTypesEnum.PERIOD.getNumber()));
        Pair entity = Pair.onePair((Object)DimTypesEnum.ENTITY.getNumber(), (Object)dimensionNumbers.get(DimTypesEnum.ENTITY.getNumber()));
        Pair at = Pair.onePair((Object)DimTypesEnum.AUDITTRIAL.getNumber(), PresetConstant.AUDITTRIAL_MEMS.get(2));
        Pair ct = Pair.onePair((Object)DimTypesEnum.CHANGETYPE.getNumber(), PresetConstant.CHANGETYPE_MEMS.get(1));
        Pair interCompany = Pair.onePair((Object)DimTypesEnum.INTERCOMPANY.getNumber(), PresetConstant.INTERNALCOMPANY_MEMS.get(2));
        pairs.add(scene);
        pairs.add(fy);
        pairs.add(period);
        pairs.add(entity);
        pairs.add(at);
        pairs.add(ct);
        pairs.add(interCompany);
        if (model.getBoolean("isspptmultrule")) {
            rule = Pair.onePair((Object)DimTypesEnum.MULTIGAAP.getNumber(), PresetConstant.RULE_MEMS.get(1));
            pairs.add(rule);
        }
        if (model.getBoolean("isspptdatasort")) {
            rule = Pair.onePair((Object)DimTypesEnum.DATASORT.getNumber(), (Object)"Actual");
            pairs.add(rule);
        }
        if (DimensionServiceHelper.existsMyCompanyDim(modelId)) {
            rule = Pair.onePair((Object)DimTypesEnum.MYCOMPANY.getNumber(), (Object)"MCNone");
            pairs.add(rule);
        }
        if ((app = ModelServiceHelper.getModelApp(modelId)) == ApplicationTypeEnum.RPT || app == ApplicationTypeEnum.UNRPT || app == ApplicationTypeEnum.PUB) {
            String defineddim = model.getString("defineddim");
            if (defineddim.contains("1")) {
                pairs.add(Pair.onePair((Object)SysDimensionEnum.Project.getNumber(), (Object)(SysDimensionEnum.Project.getShortnumber() + "None")));
            }
            if (defineddim.contains("2")) {
                pairs.add(Pair.onePair((Object)SysDimensionEnum.BusinessPartner.getNumber(), (Object)(SysDimensionEnum.BusinessPartner.getShortnumber() + "None")));
            }
            if (defineddim.contains("3")) {
                pairs.add(Pair.onePair((Object)SysDimensionEnum.MultiBook.getNumber(), (Object)(SysDimensionEnum.MultiBook.getShortnumber() + "None")));
            }
        }
        List<DynamicObject> userDefines = QueryDimensionServiceHelper.getUserDefineDim(modelId);
        HashSet dimIDs = new HashSet();
        userDefines.forEach(u -> dimIDs.add(u.getLong("id")));
        QFilter dimFilter = new QFilter("dimension", "in", dimIDs);
        QFilter modelFilter4Define = new QFilter("model", "=", (Object)modelId);
        QFilter levelFilter = new QFilter("level", "=", (Object)2);
        QFilter isSysFilter = new QFilter("ISSYSMEMBER", "=", (Object)1);
        QFilter numberFilter = new QFilter("number", "like", (Object)"%None");
        DynamicObjectCollection dimMembers = QueryServiceHelper.query((String)"epm_userdefinedmembertree", (String)"dimension,number", (QFilter[])new QFilter[]{modelFilter4Define, dimFilter, numberFilter, levelFilter, isSysFilter});
        HashMap<Long, String> dimMap = new HashMap<Long, String>();
        for (DynamicObject member : dimMembers) {
            Long dimID = member.getLong("dimension");
            String number = member.getString("number");
            dimMap.put(dimID, number);
        }
        userDefines.forEach(u -> {
            Long dimID = u.getLong("id");
            String dimNumber = u.getString("number");
            Pair userDefineP = Pair.onePair((Object)dimNumber, dimMap.get(dimID));
            pairs.add(userDefineP);
        });
        ArrayList<DynamicObject> rows = new ArrayList<DynamicObject>(1);
        rows.add(triangleRateObject);
        for (String property : rateColumns4Olap) {
            ExchangeQueryService.saveExchangeRate4Rows(pairs, rows, property, modelnum, srcCurrencyNum, cvtCurrencyNum, false);
        }
    }

    private static void saveExchangeRate4Rows(List<Pair<String, String>> pairs, List<DynamicObject> rows, String property, String modelNumber, String srcCurrencyNum, String cvtCurrencyNum, boolean isDelete) {
        HashMap columns = new HashMap();
        columns.put("beginyear", PresetConstant.ACCOUNT_MEMS.get(2));
        columns.put("periodend", PresetConstant.ACCOUNT_MEMS.get(3));
        columns.put("average", PresetConstant.ACCOUNT_MEMS.get(4));
        columns.put("userdefine", PresetConstant.ACCOUNT_MEMS.get(5));
        columns.put("boyaveragerate", PresetConstant.ACCOUNT_MEMS.get(6));
        columns.put("boyuserdefinedrate", PresetConstant.ACCOUNT_MEMS.get(7));
        SaveCommandInfo info = new SaveCommandInfo();
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-ebBatchSave-open");
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)info, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));
        stats.addInfo("end-ebBatchSave-open");
        log.info(stats.toString());
        ExchangeQueryService.addFiexdDimension(info, pairs);
        String account = (String)columns.get(property);
        account = account == null ? property : account;
        info.addfixedDimension(new String[]{DimTypesEnum.ACCOUNT.getNumber(), account});
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        String[] dimKey = new String[]{DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.CURRENCY.getNumber()};
        info.setDimensions(dimKey);
        String[] rowDomain = new String[2];
        CellSet cellSets = new CellSet(dimKey, new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        cellSets.setFromQuery(false);
        for (DynamicObject row : rows) {
            rowDomain[0] = srcCurrencyNum;
            rowDomain[1] = cvtCurrencyNum;
            if (isDelete) {
                cellSets.set(rowDomain, FacTabFieldDefEnum.FIELD_MONEY.getField(), null);
                continue;
            }
            cellSets.set(rowDomain, FacTabFieldDefEnum.FIELD_MONEY.getField(), (Object)row.getBigDecimal(property.toLowerCase()).setScale(row.getInt("precision"), RoundingMode.HALF_UP));
        }
        OlapServiceHelper.saveData(info, cellSets, modelNumber);
    }

    private static void addFiexdDimension(SaveCommandInfo info, List<Pair<String, String>> pairs) {
        for (Pair<String, String> t : pairs) {
            info.addfixedDimension(new String[]{(String)t.p1, (String)t.p2});
        }
    }

    private static Map<String, String> getDimensionNumber(DynamicObject triangleRateObject) {
        HashMap<String, String> number = new HashMap<String, String>(10);
        if (triangleRateObject.get("scene") instanceof DynamicObject) {
            number.put(DimTypesEnum.SCENARIO.getNumber(), ((DynamicObject)triangleRateObject.get("scene")).getString("number"));
        } else {
            QFilter scenarioFilter = new QFilter("id", "=", triangleRateObject.get("scene"));
            DynamicObject scenario = QueryServiceHelper.queryOne((String)"epm_scenemembertree", (String)"number", (QFilter[])new QFilter[]{scenarioFilter});
            number.put(DimTypesEnum.SCENARIO.getNumber(), scenario.getString("number"));
        }
        if (triangleRateObject.get("fy") instanceof DynamicObject) {
            number.put(DimTypesEnum.YEAR.getNumber(), ((DynamicObject)triangleRateObject.get("fy")).getString("number"));
        } else {
            QFilter yearFilter = new QFilter("id", "=", triangleRateObject.get("fy"));
            DynamicObject year = QueryServiceHelper.queryOne((String)"epm_yearmembertree", (String)"number", (QFilter[])new QFilter[]{yearFilter});
            number.put(DimTypesEnum.YEAR.getNumber(), year.getString("number"));
        }
        if (triangleRateObject.get("period") instanceof DynamicObject) {
            number.put(DimTypesEnum.PERIOD.getNumber(), ((DynamicObject)triangleRateObject.get("period")).getString("number"));
        } else {
            QFilter periodFilter = new QFilter("id", "=", triangleRateObject.get("period"));
            DynamicObject period = QueryServiceHelper.queryOne((String)"epm_periodmembertree", (String)"number", (QFilter[])new QFilter[]{periodFilter});
            number.put(DimTypesEnum.PERIOD.getNumber(), period.getString("number"));
        }
        if (triangleRateObject.get("entity") instanceof DynamicObject) {
            number.put(DimTypesEnum.ENTITY.getNumber(), ((DynamicObject)triangleRateObject.get("entity")).getString("number"));
        } else {
            QFilter entityFilter = new QFilter("id", "=", triangleRateObject.get("entity"));
            DynamicObject entity = QueryServiceHelper.queryOne((String)"epm_entitymembertree", (String)"number", (QFilter[])new QFilter[]{entityFilter});
            number.put(DimTypesEnum.ENTITY.getNumber(), entity.getString("number"));
        }
        return number;
    }

    private static DynamicObject doTriangleRateConvert(long modelid, long scenarioid, long yearid, long periodid, long orgRateId, String srcCurrencyNum, String cvtCurrencyNum, DynamicObject oldRate) {
        QFilter[] sourceDynamicsFilter = ExchangeQueryService.createRateExtFilter(modelid, scenarioid, yearid, periodid, orgRateId, srcCurrencyNum, null);
        DynamicObject[] sourceDynamics = BusinessDataServiceHelper.load((String)"eb_exchagerate", (String)ExchangeQueryService.getTriangleSelectFields(), (QFilter[])sourceDynamicsFilter);
        if (sourceDynamics == null || sourceDynamics.length == 0) {
            return null;
        }
        QFilter[] targetDynamicsFilter = ExchangeQueryService.createRateExtFilter(modelid, scenarioid, yearid, periodid, orgRateId, null, cvtCurrencyNum);
        DynamicObject[] targetDynamics = BusinessDataServiceHelper.load((String)"eb_exchagerate", (String)ExchangeQueryService.getTriangleSelectFields(), (QFilter[])targetDynamicsFilter);
        if (targetDynamics == null || targetDynamics.length == 0) {
            return null;
        }
        List<String> mediumnums = ExchangeQueryService.getMediumNum(sourceDynamics, targetDynamics, srcCurrencyNum, cvtCurrencyNum);
        if (mediumnums == null || mediumnums.size() == 0) {
            return null;
        }
        if (mediumnums.size() == 1) {
            String mediumnum = mediumnums.get(0);
            QFilter[] rateExitFilter = ExchangeQueryService.createRateExtFilter(modelid, scenarioid, yearid, periodid, orgRateId, srcCurrencyNum, mediumnum);
            DynamicObject lockRate = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getTriangleSelectFields(), (QFilter[])rateExitFilter);
            if (lockRate == null) {
                return null;
            }
            QFilter[] rateExitFilter2 = ExchangeQueryService.createRateExtFilter(modelid, scenarioid, yearid, periodid, orgRateId, mediumnum, cvtCurrencyNum);
            DynamicObject lockRate2 = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getTriangleSelectFields(), (QFilter[])rateExitFilter2);
            if (lockRate2 == null) {
                return null;
            }
            DynamicObject triangleRateObject = ExchangeQueryService.getTriangleRateObject(lockRate, lockRate2, oldRate);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{triangleRateObject});
            ExchangeQueryService.saveOrUpdateTriangle(triangleRateObject, srcCurrencyNum, cvtCurrencyNum);
            return triangleRateObject;
        }
        QFilter modelFilter = new QFilter("model", "=", (Object)modelid);
        QFilter sourceFilter = new QFilter("parent.number", "=", (Object)"TCF");
        QFilter numberFilter = new QFilter("number", "in", mediumnums);
        QFilter priorityFilter = new QFilter("priority", ">", (Object)0);
        QFilter currencyFilter = modelFilter.and(sourceFilter).and(numberFilter).and(priorityFilter);
        DynamicObject[] currencys = BusinessDataServiceHelper.load((String)"epm_processmembertree", (String)"id,name,number,priority", (QFilter[])new QFilter[]{currencyFilter}, (String)"priority asc", (int)1);
        if (currencys == null || currencys.length == 0) {
            return null;
        }
        String mediumnum = currencys[0].getString("number");
        QFilter[] rateExitFilter = ExchangeQueryService.createRateExtFilter(modelid, scenarioid, yearid, periodid, orgRateId, srcCurrencyNum, mediumnum);
        DynamicObject lockRate = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getTriangleSelectFields(), (QFilter[])rateExitFilter);
        if (lockRate == null) {
            return null;
        }
        QFilter[] rateExitFilter2 = ExchangeQueryService.createRateExtFilter(modelid, scenarioid, yearid, periodid, orgRateId, mediumnum, cvtCurrencyNum);
        DynamicObject lockRate2 = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getTriangleSelectFields(), (QFilter[])rateExitFilter2);
        if (lockRate2 == null) {
            return null;
        }
        DynamicObject triangleRateObject = ExchangeQueryService.getTriangleRateObject(lockRate, lockRate2, oldRate);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{triangleRateObject});
        ExchangeQueryService.saveOrUpdateTriangle(triangleRateObject, srcCurrencyNum, cvtCurrencyNum);
        return triangleRateObject;
    }

    private static List<String> getMediumNum(DynamicObject[] sourceDynamics, DynamicObject[] targetDynamics, String srcCurrencyNum, String cvtCurrencyNum) {
        int i;
        int i2;
        HashSet<String> nodeSet = new HashSet<String>(10);
        for (i2 = 0; i2 < sourceDynamics.length; ++i2) {
            nodeSet.add(((DynamicObject)sourceDynamics[i2].get("source")).getString("number"));
            nodeSet.add(((DynamicObject)sourceDynamics[i2].get("target")).getString("number"));
        }
        for (i2 = 0; i2 < targetDynamics.length; ++i2) {
            nodeSet.add(((DynamicObject)targetDynamics[i2].get("source")).getString("number"));
            nodeSet.add(((DynamicObject)targetDynamics[i2].get("target")).getString("number"));
        }
        ListDGraph currDG = new ListDGraph();
        for (String number : nodeSet) {
            currDG.add((Object)number);
        }
        for (i = 0; i < sourceDynamics.length; ++i) {
            currDG.add(new Edge((Object)((DynamicObject)sourceDynamics[i].get("source")).getString("number"), (Object)((DynamicObject)sourceDynamics[i].get("target")).getString("number")));
        }
        for (i = 0; i < targetDynamics.length; ++i) {
            currDG.add(new Edge((Object)((DynamicObject)targetDynamics[i].get("source")).getString("number"), (Object)((DynamicObject)targetDynamics[i].get("target")).getString("number")));
        }
        return currDG.visit((Object)srcCurrencyNum, (Object)cvtCurrencyNum);
    }

    private static DynamicObject getTriangleRateObject(DynamicObject lockRate, DynamicObject lockRate2, DynamicObject oldRate) {
        int precision = Math.max(lockRate.getInt("precision"), lockRate2.getInt("precision"));
        if (oldRate == null) {
            DynamicObject newTriangleRate = BusinessDataServiceHelper.newDynamicObject((String)"eb_exchagerate");
            newTriangleRate.set("source", lockRate.get("source"));
            newTriangleRate.set("target", lockRate2.get("target"));
            newTriangleRate.set("entity", lockRate.get("entity"));
            newTriangleRate.set("model", lockRate.get("model"));
            newTriangleRate.set("scene", lockRate.get("scene"));
            newTriangleRate.set("fy", lockRate.get("fy"));
            newTriangleRate.set("period", lockRate.get("period"));
            newTriangleRate.set("triangle", (Object)(lockRate.getString("sourcename") + " -> " + lockRate.getString("targetname") + " -> " + lockRate2.getString("targetname")));
            newTriangleRate.set("precision", (Object)Math.max(lockRate.getInt("precision"), lockRate2.getInt("precision")));
            if (lockRate.getLong("fromid") == 0L && lockRate2.getLong("fromid") == 0L) {
                Stream.of(rateColumns).forEach(rate -> newTriangleRate.set(rate, (Object)lockRate.getBigDecimal(rate).multiply(lockRate2.getBigDecimal(rate)).setScale(precision, RoundingMode.HALF_UP)));
            } else if (lockRate.getLong("fromid") != 0L && lockRate2.getLong("fromid") == 0L) {
                QFilter qfilterid = new QFilter("id", "=", (Object)lockRate.getLong("fromid"));
                DynamicObject fromObj = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getSelectFields(), (QFilter[])new QFilter[]{qfilterid});
                Stream.of(rateColumns).forEach(rate -> newTriangleRate.set(rate, (Object)(fromObj.getBigDecimal(rate).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : lockRate2.getBigDecimal(rate).divide(fromObj.getBigDecimal(rate), precision, RoundingMode.HALF_UP))));
            } else if (lockRate.getLong("fromid") == 0L && lockRate2.getLong("fromid") != 0L) {
                QFilter qfilterid = new QFilter("id", "=", (Object)lockRate2.getLong("fromid"));
                DynamicObject fromObj = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getSelectFields(), (QFilter[])new QFilter[]{qfilterid});
                Stream.of(rateColumns).forEach(rate -> newTriangleRate.set(rate, (Object)(fromObj.getBigDecimal(rate).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : lockRate.getBigDecimal(rate).divide(fromObj.getBigDecimal(rate), precision, RoundingMode.HALF_UP))));
            } else if (lockRate.getLong("fromid") != 0L && lockRate2.getLong("fromid") != 0L) {
                QFilter qfilterid = new QFilter("id", "=", (Object)lockRate.getLong("fromid"));
                DynamicObject fromObj = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getSelectFields(), (QFilter[])new QFilter[]{qfilterid});
                QFilter qfilterid2 = new QFilter("id", "=", (Object)lockRate2.getLong("fromid"));
                DynamicObject fromObj2 = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getSelectFields(), (QFilter[])new QFilter[]{qfilterid2});
                Stream.of(rateColumns).forEach(rate -> newTriangleRate.set(rate, (Object)(fromObj.getBigDecimal(rate).compareTo(BigDecimal.ZERO) == 0 || fromObj2.getBigDecimal(rate).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : BigDecimal.ONE.divide(fromObj.getBigDecimal(rate).multiply(fromObj2.getBigDecimal(rate)), precision, RoundingMode.HALF_UP))));
            }
            newTriangleRate.set("modifier", (Object)UserUtils.getUserId());
            newTriangleRate.set("modifytime", (Object)TimeServiceHelper.now());
            return newTriangleRate;
        }
        oldRate.set("triangle", (Object)(lockRate.getString("sourcename") + " -> " + lockRate.getString("targetname") + " -> " + lockRate2.getString("targetname")));
        oldRate.set("precision", (Object)Math.max(lockRate.getInt("precision"), lockRate2.getInt("precision")));
        if (lockRate.getLong("fromid") == 0L && lockRate2.getLong("fromid") == 0L) {
            Stream.of(rateColumns).forEach(rate -> oldRate.set(rate, (Object)lockRate.getBigDecimal(rate).multiply(lockRate2.getBigDecimal(rate)).setScale(precision, RoundingMode.HALF_UP)));
        } else if (lockRate.getLong("fromid") != 0L && lockRate2.getLong("fromid") == 0L) {
            QFilter qfilterid = new QFilter("id", "=", (Object)lockRate.getLong("fromid"));
            DynamicObject fromObj = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getSelectFields(), (QFilter[])new QFilter[]{qfilterid});
            Stream.of(rateColumns).forEach(rate -> oldRate.set(rate, (Object)(fromObj.getBigDecimal(rate).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : lockRate2.getBigDecimal(rate).divide(fromObj.getBigDecimal(rate), precision, RoundingMode.HALF_UP))));
        } else if (lockRate.getLong("fromid") == 0L && lockRate2.getLong("fromid") != 0L) {
            QFilter qfilterid = new QFilter("id", "=", (Object)lockRate2.getLong("fromid"));
            DynamicObject fromObj = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getSelectFields(), (QFilter[])new QFilter[]{qfilterid});
            Stream.of(rateColumns).forEach(rate -> oldRate.set(rate, (Object)(fromObj.getBigDecimal(rate).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : lockRate.getBigDecimal(rate).divide(fromObj.getBigDecimal(rate), precision, RoundingMode.HALF_UP))));
        } else if (lockRate.getLong("fromid") != 0L && lockRate2.getLong("fromid") != 0L) {
            QFilter qfilterid = new QFilter("id", "=", (Object)lockRate.getLong("fromid"));
            DynamicObject fromObj = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getSelectFields(), (QFilter[])new QFilter[]{qfilterid});
            QFilter qfilterid2 = new QFilter("id", "=", (Object)lockRate2.getLong("fromid"));
            DynamicObject fromObj2 = QueryServiceHelper.queryOne((String)"eb_exchagerate", (String)ExchangeQueryService.getSelectFields(), (QFilter[])new QFilter[]{qfilterid2});
            Stream.of(rateColumns).forEach(rate -> oldRate.set(rate, (Object)(fromObj.getBigDecimal(rate).compareTo(BigDecimal.ZERO) == 0 || fromObj2.getBigDecimal(rate).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : BigDecimal.ONE.divide(fromObj.getBigDecimal(rate).multiply(fromObj2.getBigDecimal(rate)), precision, RoundingMode.HALF_UP))));
        }
        return oldRate;
    }

    private static QFilter[] createRateExtFilter(long modelid, long scenarioid, long yearid, long periodid, long orgRateId, String srcCurrencyNum, String cvtCurrencyNum) {
        QFilter qfilter = new QFilter("model", "=", (Object)modelid);
        qfilter.and("scene", "=", (Object)scenarioid);
        qfilter.and("fy", "=", (Object)yearid);
        qfilter.and("period", "=", (Object)periodid);
        qfilter.and("entity", "=", (Object)orgRateId);
        if (srcCurrencyNum != null) {
            qfilter.and("source.number", "=", (Object)srcCurrencyNum);
        }
        if (cvtCurrencyNum != null) {
            qfilter.and("target.number", "=", (Object)cvtCurrencyNum);
        }
        return qfilter.toArray();
    }

    private static String getTriangleSelectFields() {
        return "id,source,target,target.number as targetnumber,target.name as targetname,source.number as sourcenumber,source.name as sourcename,source.priority as priority,entity,model,scene,fy,period,beginyear,periodend,triangle,average,userdefine,boyaveragerate,boyuserdefinedrate,fromid,precision,userdefinedrate1,userdefinedrate2,userdefinedrate3,userdefinedrate4,userdefinedrate5,userdefinedrate6,userdefinedrate7,userdefinedrate8,userdefinedrate9,userdefinedrate10,boyuserdefinedrate1,boyuserdefinedrate2,boyuserdefinedrate3,boyuserdefinedrate4,boyuserdefinedrate5,boyuserdefinedrate6,boyuserdefinedrate7,boyuserdefinedrate8,boyuserdefinedrate9,boyuserdefinedrate10";
    }
}

