/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.dimension.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class DataPermTreeNode
implements Comparable,
Serializable {
    private List<Integer> permNums;
    private String oldPermNumsStr;
    private String number;
    private Long id;
    private String name;
    private List<DataPermTreeNode> children = new LinkedList<DataPermTreeNode>();
    private Map<String, Object> detailData;
    private int dseq = 0;
    private DataPermTreeNode parent;
    private boolean enable = true;
    private boolean isShareNode = false;

    public DataPermTreeNode(Long id, String name) {
        this.id = id;
        this.name = name;
    }

    public DataPermTreeNode(Long id, String name, String number) {
        this.id = id;
        this.name = name;
        this.number = number;
    }

    public List<Integer> getPermNums() {
        if (this.permNums == null) {
            this.permNums = new ArrayList<Integer>();
        }
        return this.permNums;
    }

    public void setPermNums(List<Integer> permNums) {
        this.permNums = permNums;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getOldPermNumsStr() {
        return this.oldPermNumsStr;
    }

    public void setOldPermNumsStr(String oldPermNumsStr) {
        this.oldPermNumsStr = oldPermNumsStr;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public List<DataPermTreeNode> getChilds() {
        return this.children;
    }

    public boolean isShareNode() {
        return this.isShareNode;
    }

    public void setShareNode(boolean shareNode) {
        this.isShareNode = shareNode;
    }

    public int getDseq() {
        return this.dseq;
    }

    public void setDseq(int dseq) {
        this.dseq = dseq;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Object getData() {
        return this.detailData;
    }

    public DataPermTreeNode getParent() {
        return this.parent;
    }

    public void setParent(DataPermTreeNode parent) {
        this.parent = parent;
    }

    public List<DataPermTreeNode> getChildren() {
        return this.children;
    }

    public void addChild(DataPermTreeNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    public boolean removeChild(DataPermTreeNode child) {
        return this.children.removeIf(p -> child.getId().equals(p.getId()));
    }

    public boolean isLeaf() {
        if (this.getChildren() == null || this.getChildren().size() == 0) {
            return true;
        }
        for (DataPermTreeNode node : this.getChildren()) {
            if (node == null) continue;
            return false;
        }
        return true;
    }

    public void iterate(int maxLevel, Consumer<DataPermTreeNode> callback) {
        callback.accept(this);
        if (maxLevel > 0 && this.getChildren() != null) {
            for (DataPermTreeNode child : this.getChildren()) {
                child.iterate(maxLevel - 1, callback);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getDetailData() {
        return this.detailData;
    }

    public void setDetailData(Map<String, Object> detailData) {
        this.detailData = detailData;
    }

    public int compareTo(Object o) {
        return this.getDseq() - ((DataPermTreeNode)o).getDseq();
    }

    public DataPermTreeNode getChildNodeByNodeId(Long nodeId) {
        DataPermTreeNode node;
        block2: {
            DataPermTreeNode childNode;
            block1: {
                node = null;
                if (!nodeId.equals(this.getId())) break block1;
                node = this;
                break block2;
            }
            if (this.getChildren() == null) break block2;
            Iterator<DataPermTreeNode> iterator = this.getChildren().iterator();
            while (iterator.hasNext() && (node = (childNode = iterator.next()).getChildNodeByNodeId(nodeId)) == null) {
            }
        }
        return node;
    }
}

