/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.formula.register;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.GlobalCacheServiceHelper;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;
import kd.epm.eb.ebBusiness.formula.register.ExternalFormulaCatlog;
import kd.epm.eb.ebBusiness.formula.register.ExternalFormulaConfig;
import kd.epm.eb.ebBusiness.formula.register.ExternalFormulaServiceConfig;
import kd.epm.eb.ebBusiness.serviceHelper.MsServiceHelper;

public class ExternalFormulaLoader {
    private static ExternalFormulaLoader loader;
    private static Object lock;
    private static WatchLogger log;

    private ExternalFormulaLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExternalFormulaLoader getInstance() {
        if (loader != null) {
            return loader;
        }
        Object object = lock;
        synchronized (object) {
            if (loader != null) {
                return loader;
            }
            loader = new ExternalFormulaLoader();
        }
        return loader;
    }

    public List<ExternalFormulaConfig> loadExternalFormulaConfig() {
        return (List)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)"externalFormulaConfig", () -> {
            log.startWatch();
            DynamicObjectCollection colls = QueryServiceHelper.query((String)"eb_formularegister", (String)"cloudid,appid,service,method,classpath", null);
            ArrayList<ExternalFormulaConfig> configs = new ArrayList<ExternalFormulaConfig>();
            for (DynamicObject dyna : colls) {
                String cloudId = dyna.getString("cloudid");
                String appId = dyna.getString("appid");
                String serviceName = dyna.getString("service");
                String methodName = dyna.getString("method");
                String clazzPath = dyna.getString("classpath");
                try {
                    String json = (String)MsServiceHelper.invokeService(cloudId, appId, serviceName, methodName, new Object[0]);
                    Map jsonArr = (Map)JSON.parseObject((String)json, Map.class);
                    Pair<List<ExternalFormulaCatlog>, ExternalFormulaServiceConfig> catlog = this.parseFormulaCatlogConfig((String)jsonArr.get("formula_catalog_list"));
                    List<Map> formulas = this.parseFormulaConfig((String)jsonArr.get("formula_def_list"));
                    ExternalFormulaConfig config = new ExternalFormulaConfig();
                    config.setCatlogs((List)catlog.p1);
                    config.setServiceConfig((ExternalFormulaServiceConfig)catlog.p2);
                    ((ExternalFormulaServiceConfig)catlog.p2).setClazzPath(clazzPath);
                    config.setFormulas(formulas);
                    configs.add(config);
                }
                catch (Exception e) {
                    log.error(String.format("loadExternalFormulaConfig failed,cloudId::%s, appId::%s, serviceName::%s, methodName::%s", cloudId, appId, serviceName, methodName), (Throwable)e);
                }
            }
            log.info("loaded external formula config ");
            return configs;
        });
    }

    public ExternalFormulaServiceConfig getFormulaServiceConfig(String formulaName) {
        List<ExternalFormulaConfig> configs = this.loadExternalFormulaConfig();
        for (ExternalFormulaConfig cfg : configs) {
            if (!cfg.containsFormula(formulaName)) continue;
            return cfg.getServiceConfig();
        }
        throw new RuntimeException(String.format("not found formula [%s] service", formulaName));
    }

    public Map getFormulaConfig(String formulaName) {
        List<ExternalFormulaConfig> configs = this.loadExternalFormulaConfig();
        for (ExternalFormulaConfig cfg : configs) {
            if (!cfg.containsFormula(formulaName)) continue;
            return cfg.getFormulaByName(formulaName);
        }
        throw new RuntimeException(String.format("not found formula [%s] config", formulaName));
    }

    private Pair<List<ExternalFormulaCatlog>, ExternalFormulaServiceConfig> parseFormulaCatlogConfig(String json) {
        ExternalFormulaServiceConfig service = new ExternalFormulaServiceConfig();
        Map catlogMap = (Map)JSON.parseObject((String)json, Map.class);
        List items = (List)catlogMap.get("catalogs");
        ArrayList<ExternalFormulaCatlog> catlogs = new ArrayList<ExternalFormulaCatlog>(items.size());
        for (Object item : items) {
            Map map = (Map)item;
            catlogs.add(ExternalFormulaCatlog.of((String)map.get("name"), (String)map.get("number")));
        }
        Map serviceCfg = (Map)catlogMap.get("mservice");
        service.setCloudId((String)serviceCfg.get("cloudId"));
        service.setAppId((String)serviceCfg.get("appId"));
        service.setService((String)serviceCfg.get("service"));
        service.setMethod((String)serviceCfg.get("method"));
        return Pair.onePair(catlogs, (Object)service);
    }

    private List<Map> parseFormulaConfig(String json) {
        List formulas = JSON.parseArray((String)json, Map.class);
        return formulas;
    }

    static {
        lock = new Object();
        log = BcmLogFactory.getWatchLogInstance((boolean)false, ExternalFormulaLoader.class);
    }
}

