/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.formula.rptformula;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.ebBusiness.formula.rptformula.IFormula;
import kd.epm.eb.ebBusiness.formula.rptformula.RptFormulaUtil;

public class RptDateFormula
implements IFormula {
    public String getResult(String express, Long templateId, String groupId) {
        String dateString = "";
        String[] params = express.split("\"");
        if (params.length == 5) {
            Date currentTime = this.getResultDate(params, templateId, groupId);
            if (currentTime == null) {
                return dateString;
            }
            String pattern = params[3].replace('Y', 'y').replace('D', 'd');
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            dateString = format.format(currentTime);
        }
        return dateString;
    }

    @Override
    public <T> T getResult(String express, DynamicObject period, DynamicObject year, DynamicObject report) {
        return null;
    }

    public Calendar getCurrentDate() {
        Calendar nowc = Calendar.getInstance();
        nowc.set(11, 0);
        nowc.set(14, 0);
        nowc.set(13, 0);
        return nowc;
    }

    public Date getResultDate(String[] params, Long templateId, String groupId) {
        String selectField = String.format("fyear.number,period.effmonth,period.effday,period.expmonth,period.expday,%s", params[1]);
        DynamicObject yearPeriod = RptFormulaUtil.getRptInfoDyc(templateId, selectField, groupId);
        if (yearPeriod == null) {
            return null;
        }
        Date result = yearPeriod.getDate(params[1]) != null ? this.getDateByRange(yearPeriod, yearPeriod.getDate(params[1])) : this.getDateByRange(yearPeriod, this.getCurrentDate().getTime());
        return result;
    }

    public Date getDateByRange(DynamicObject yearPeriod, Date current) {
        Calendar currentc = Calendar.getInstance();
        Calendar beginc = Calendar.getInstance();
        Calendar endc = Calendar.getInstance();
        int fYear = Integer.parseInt(yearPeriod.getString("fyear.number").replace("FY", ""));
        int lastDay = RptDateFormula.getPeriodLastDay(fYear, yearPeriod.getInt("period.expmonth") - 1, yearPeriod.getInt("period.expday"));
        currentc.setTime(current);
        beginc.set(fYear, yearPeriod.getInt("period.effmonth") - 1, yearPeriod.getInt("period.effday"));
        endc.set(fYear, yearPeriod.getInt("period.expmonth") - 1, lastDay);
        Calendar result = currentc.before(beginc) || currentc.equals(beginc) ? beginc : (currentc.after(beginc) && currentc.before(endc) ? currentc : endc);
        return result.getTime();
    }

    public static int getPeriodLastDay(int year, int month, int day) {
        int result = day;
        if (month == 1) {
            Calendar c = Calendar.getInstance();
            c.set(year, 2, 1);
            c.add(5, -1);
            result = c.get(5);
        }
        return result;
    }
}

