/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.formula.rptformula;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.ebBusiness.formula.rptformula.IFormula;
import kd.epm.eb.ebBusiness.formula.rptformula.RptDateFormula;

public class YearPeriodRPTFormula
implements IFormula {
    private RptDateFormula rptDateFormula = new RptDateFormula();

    @Override
    public <T> T getResult(String express, Long templateId, String groupId) {
        return null;
    }

    @Override
    public <T> T getResult(String express, DynamicObject year, DynamicObject period, DynamicObject report) {
        String dateString = "";
        String[] params = express.split("\"");
        if (params.length == 5) {
            Date currentTime = this.getResultDate(params, year, period, report);
            if (currentTime == null) {
                return (T)dateString;
            }
            String pattern = params[3].replace('Y', 'y').replace('D', 'd');
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            dateString = format.format(currentTime);
        }
        return (T)dateString;
    }

    public Date getResultDate(String[] params, DynamicObject year, DynamicObject period, DynamicObject report) {
        if (report == null) {
            return this.getDateByRange(year, period, this.rptDateFormula.getCurrentDate().getTime());
        }
        Date result = report.get(params[1]) != null ? this.getDateByRange(year, period, report.getDate(params[1])) : this.getDateByRange(year, period, this.rptDateFormula.getCurrentDate().getTime());
        return result;
    }

    public Date getDateByRange(DynamicObject year, DynamicObject period, Date current) {
        Calendar currentc = Calendar.getInstance();
        Calendar beginc = Calendar.getInstance();
        Calendar endc = Calendar.getInstance();
        int fYear = Integer.parseInt(year.getString("number").replace("FY", ""));
        int lastDay = RptDateFormula.getPeriodLastDay(fYear, period.getInt("expmonth") - 1, period.getInt("expday"));
        currentc.setTime(current);
        beginc.set(fYear, period.getInt("effmonth") - 1, period.getInt("effday"));
        endc.set(fYear, period.getInt("expmonth") - 1, lastDay);
        Calendar result = currentc.before(beginc) || currentc.equals(beginc) ? beginc : (currentc.after(beginc) && currentc.before(endc) ? currentc : endc);
        return result.getTime();
    }
}

