/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.invest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.ebBusiness.invest.AbstractDimensionMember;
import kd.epm.eb.ebBusiness.invest.DimensionMember;
import kd.epm.eb.ebBusiness.invest.SysPropertyDimensionMember;
import kd.epm.eb.ebBusiness.scheme.Dimension;

public class DimensionScope
implements Serializable {
    private String modelId;
    private Dimension dimension;
    private Map<String, String> dimensionMemberMap = new HashMap<String, String>();
    private List<AbstractDimensionMember> dimensionMembers = new ArrayList<AbstractDimensionMember>();
    private Set<String> resolveScopes = new HashSet<String>();
    private List<Map<String, String>> dimMembers = new ArrayList<Map<String, String>>();
    private boolean isSysProperty = false;

    public DimensionScope(String modelId, Dimension dimension, List<DynamicObject> dimMembers) {
        QFilter[] qFilterArray;
        this.dimension = dimension;
        this.modelId = modelId;
        QFilter qf = new QFilter("1", "!=", (Object)1);
        dimMembers.stream().forEach(dimMember -> qf.or(new QFilter("id", "=", dimMember.get("dimensionmember"))));
        boolean isUserdefine = "epm_userdefinedmembertree".equalsIgnoreCase(dimension.getEntity());
        String string = dimension.getEntity();
        if (isUserdefine) {
            QFilter[] qFilterArray2 = new QFilter[2];
            qFilterArray2[0] = qf;
            qFilterArray = qFilterArray2;
            qFilterArray2[1] = new QFilter("dimension", "=", (Object)dimension.getId());
        } else {
            qFilterArray = qf.toArray();
        }
        Map result = BusinessDataServiceHelper.loadFromCache((String)string, (String)"number,name", (QFilter[])qFilterArray);
        if (result.isEmpty()) {
            this.isSysProperty = true;
            result = BusinessDataServiceHelper.loadFromCache((String)"bcm_definedpropertyvalue", (String)"number,name", (QFilter[])new QFilter[]{qf, new QFilter("dimension", "=", (Object)dimension.getId())});
        }
        dimMembers.stream().forEach(dimMember -> this.dimensionMembers.add(this.isSysProperty ? new SysPropertyDimensionMember(dimension, (DynamicObject)dimMember) : new DimensionMember(dimension, (DynamicObject)dimMember)));
        result.values().stream().forEach(dimMember -> this.dimensionMemberMap.put(dimMember.getString("number"), dimMember.getString("name")));
    }

    public DimensionScope(String modelId, Dimension dimension, DynamicObjectCollection dimMembers) {
        this.modelId = modelId;
        this.dimension = dimension;
        this.isSysProperty = dimMembers.stream().anyMatch(p -> StringUtils.isNotEmpty((CharSequence)p.getString("pid1")));
        dimMembers.stream().forEach(dimMember -> {
            String number = dimMember.getString("mnum1");
            this.dimensionMembers.add(this.isSysProperty ? new SysPropertyDimensionMember(dimension, number, dimMember.getString("mid1"), dimMember.getInt("filltypevalue1")) : new DimensionMember(dimension, number, dimMember.getString("mid1"), dimMember.getInt("filltypevalue1")));
            this.dimensionMemberMap.put(this.isSysProperty ? number.split("\\:")[1] : number, dimMember.getString("mname1"));
        });
    }

    public Set<String> getResolveScopes() {
        if (this.resolveScopes.isEmpty()) {
            this.dimensionMembers.stream().forEach(dimensionMember -> this.resolveScopes.addAll(dimensionMember.resolveItems(this.modelId)));
        }
        return this.resolveScopes;
    }

    public void getDys(DynamicObjectCollection dys) {
        this.dimensionMembers.stream().forEach(dimensionMember -> dimensionMember.toDy(dys));
    }

    public List<Map<String, String>> getdimMembers() {
        if (this.dimMembers == null || this.dimMembers.isEmpty()) {
            this.dimMembers = this.dimensionMembers.stream().map(dimensionMember -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", dimensionMember.getId());
                map.put("number", dimensionMember.getNumber());
                map.put("name", this.dimensionMemberMap.get(this.isSysProperty ? dimensionMember.getNumber().split(":")[1] : dimensionMember.getNumber()));
                map.put("scope", dimensionMember.getScope() + "");
                map.put("pid", this.isSysProperty ? dimensionMember.getId() : null);
                return map;
            }).collect(Collectors.toList());
        }
        return this.dimMembers;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof DimensionScope) {
            DimensionScope ds = (DimensionScope)o;
            Set<String> resolveScopes = this.getResolveScopes();
            Set<String> resolveScopesDs = ds.getResolveScopes();
            if (resolveScopes == null || resolveScopesDs.size() == 0) {
                return true;
            }
            HashSet<String> temp = new HashSet<String>();
            temp.addAll(resolveScopes);
            temp.addAll(resolveScopesDs);
            return temp.size() != resolveScopesDs.size() + resolveScopes.size();
        }
        return true;
    }

    public boolean contains(String number) {
        return this.getResolveScopes().contains(number);
    }

    public boolean isEmpty() {
        return this.getResolveScopes().isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dimensionMembers.stream().forEach(dimensionMember -> sb.append(dimensionMember.toString(this.dimensionMemberMap)));
        return sb.toString();
    }
}

