/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.ebcommon.common.enums.FetchTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.ebBusiness.model.AbstractFormula;
import kd.epm.eb.ebBusiness.util.IntergrationUtil;

public abstract class FormulaModel
extends AbstractFormula {
    public static final String ORGNUM = "orgNum";
    public static final String ORGID = "orgID";
    public static final String FY = "fyear";
    public static final String PERIOD = "period";
    public static final String CURRENCY = "currency";
    public static final char SPLIT = ',';
    protected String groupCondition = "";
    protected String formulaType;
    protected Long orgid;
    private String orgNumber;
    private String orgName;
    private long bookTypeId;
    private String bookTypeNumber;
    private String bookTypeName;
    private String fetchType;
    protected String fetchField;
    private int year;
    private int fy;
    private int period;
    private int periodAct;
    private long periodId;
    protected long startPeriodId;
    private Long currencyId;
    private String currencyNumber;
    private String currencyName;
    private String accountAndAssvalStr;
    protected Long accountId;
    protected String accountNumber;
    protected String accountName;
    protected List<String> asstNum = new ArrayList<String>();
    protected List<String> asstVal = new ArrayList<String>();
    protected boolean hasCheck = false;
    protected long accounttable;
    private Class<?>[] types = new Class[]{String.class, String.class, String.class, String.class, Long.class, Long.class, String.class};
    protected List<Map<String, Long>> asstFilter = new ArrayList<Map<String, Long>>();

    public void setHasCheck(boolean hasCheck) {
        this.hasCheck = hasCheck;
    }

    public FormulaModel(String formulaStr) {
        super(formulaStr);
    }

    public Long getStartPeriod() {
        return this.startPeriodId;
    }

    public boolean check(boolean checkAccoutExists) {
        if (StringUtils.isNotEmpty((CharSequence)this.msg)) {
            return true;
        }
        try {
            if (!this.hasCheck) {
                this.doCheckAndParse(this.formulaStr, checkAccoutExists);
            }
        }
        catch (Exception e) {
            this.msg = e.getMessage();
        }
        finally {
            this.hasCheck = true;
        }
        return StringUtils.isNotEmpty((CharSequence)this.msg);
    }

    private void doCheckAndParse(String formulaStr, boolean checkAccoutExists) throws KDBizException {
        DynamicObject bookType;
        QFilter bookTypeFilter;
        String bookTypeNum;
        int index2;
        if (StringUtils.isEmpty((CharSequence)formulaStr)) {
            return;
        }
        formulaStr = formulaStr.replaceAll("\\s*", "");
        int index1 = formulaStr.indexOf(40);
        if (StringUtils.isEmpty((CharSequence)(formulaStr = formulaStr.substring(index1 + 1, index2 = formulaStr.indexOf(41))))) {
            return;
        }
        String[] formulaStrs = formulaStr.split(String.valueOf(','));
        if (StringUtils.isNotEmpty((CharSequence)this.getMsg())) {
            return;
        }
        if (formulaStrs.length != 7) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u5b57\u7b26\u4e32\u53c2\u6570\u5e94\u8be5\u4e3a7\u4e2a\u3002", (String)"FormulaModel_0", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        for (int i = 0; i < formulaStrs.length; ++i) {
            if (this.types[i] != String.class) continue;
            String str = formulaStrs[i];
            if ("\"\"".equals(str)) {
                formulaStrs[i] = "";
                continue;
            }
            String[] subStr = str.split("\"");
            if (subStr.length != 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u5b57\u7b26\u4e32\u53c2\u6570\u7c7b\u578b\u9519\u8bef\u3002", (String)"FormulaModel_1", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
            formulaStrs[i] = subStr[1];
        }
        String orgnum = formulaStrs[0];
        if (!StringUtils.isEmpty((CharSequence)orgnum)) {
            QFilter orgFilter = new QFilter("number", "=", (Object)orgnum);
            if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])new QFilter[]{orgFilter})) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u7ec4\u7ec7\u7f16\u7801\u9519\u8bef\uff0c\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"FormulaModel_3", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{orgFilter});
            this.orgid = org.getLong("id");
            this.orgNumber = org.getString("number");
            this.orgName = org.getString("name");
        }
        if (!StringUtils.isEmpty((CharSequence)(bookTypeNum = formulaStrs[1]))) {
            bookTypeFilter = new QFilter("number", "=", (Object)bookTypeNum);
            if (!QueryServiceHelper.exists((String)"bd_accountbookstype", (QFilter[])new QFilter[]{bookTypeFilter})) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801\u9519\u8bef\uff0c\u8d26\u7c3f\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"FormulaModel_4", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
            bookType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbookstype", (String)"id,number,name", (QFilter[])new QFilter[]{bookTypeFilter});
            this.bookTypeId = bookType.getLong("id");
            this.bookTypeNumber = bookType.getString("number");
            this.bookTypeName = bookType.getString("name");
        } else {
            bookTypeFilter = new QFilter("accounttype", "=", (Object)"1");
            bookType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbookstype", (String)"id,number,name", (QFilter[])new QFilter[]{bookTypeFilter});
            this.bookTypeId = bookType.getLong("id");
            this.bookTypeNumber = bookType.getString("number");
            this.bookTypeName = bookType.getString("name");
        }
        String accountStr = formulaStrs[2];
        this.parseAssvalStr(formulaStr, accountStr, checkAccoutExists);
        String currencyStr = formulaStrs[6];
        if (!StringUtils.isEmpty((CharSequence)currencyStr)) {
            String currencyNum = currencyStr;
            QFilter currencyNumFilter = new QFilter("number", "=", (Object)currencyNum);
            if (!QueryServiceHelper.exists((String)"bd_currency", (QFilter[])new QFilter[]{currencyNumFilter})) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u5e01\u79cd\u7f16\u7801\u9519\u8bef\uff0c\u5e01\u79cd\u4e0d\u5b58\u5728\u3002", (String)"FormulaModel_5", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
            DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id,name,number", (QFilter[])new QFilter[]{currencyNumFilter});
            this.currencyId = currency.getLong("id");
            this.currencyNumber = currency.getString("number");
            this.currencyName = currency.getString("name");
        }
        this.fetchType = formulaStrs[3];
        if (StringUtils.isEmpty((CharSequence)this.fetchType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570\u7c7b\u578b\u9519\u8bef\u3002", (String)"FormulaModel_6", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        this.fetchField = FetchTypeEnum.getField((String)this.fetchType.toUpperCase(Locale.getDefault()), (String)this.formulaType, (Long)this.currencyId);
        if (StringUtils.isEmpty((CharSequence)this.fetchField)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570\u7c7b\u578b\u9519\u8bef\u3002", (String)"FormulaModel_6", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        String fyStr = formulaStrs[4];
        if (!StringUtils.isEmpty((CharSequence)fyStr)) {
            if (fyStr.length() > 4) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u65e0\u6cd5\u83b7\u53d6\u8d22\u5e74\u3002", (String)"FormulaModel_16", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u516c\u5f0f\u8d22\u5e74\u201d\u3002", (String)"FormulaModel_8", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        this.year = Integer.parseInt(fyStr);
        String periodStr = formulaStrs[5];
        if (StringUtils.isEmpty((CharSequence)periodStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u516c\u5f0f\u671f\u95f4\u201d\u3002", (String)"FormulaModel_9", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        this.period = Integer.parseInt(periodStr);
    }

    @Override
    public void excute(Long modelId) {
        if (this.check(false)) {
            return;
        }
        try {
            this.initCondition(modelId);
            this.getAccountItem(this.accounttable, this.orgid);
            List<Map<String, Object>> data = this.query();
            if (data != null) {
                for (Map<String, Object> value : data) {
                    this.result = this.getResult(value);
                }
            }
        }
        catch (Exception e) {
            this.log.error(ThrowableHelper.toString((Exception)e));
            this.msg = StringUtils.isEmpty((CharSequence)e.getMessage()) ? e.toString() : e.getMessage();
        }
    }

    public void initCondition(Long modelId) {
        QFilter fyFilter;
        boolean isFalse = false;
        boolean isRelative = false;
        if (this.year <= 0) {
            isRelative = true;
        } else if (this.year < 1000) {
            isRelative = true;
        }
        if (isRelative) {
            if (this.params.get(FY) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u8d22\u5e74\u3002", (String)"FormulaModel_7", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
            String fyParam = this.params.get(FY).toString();
            fyParam = fyParam.replaceAll("FY", "");
            this.fy = Integer.parseInt(fyParam) + this.year;
        } else {
            this.fy = this.year;
        }
        isRelative = false;
        if (this.period <= 0) {
            isRelative = true;
        }
        if (isRelative) {
            if (this.params.get(PERIOD) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u671f\u95f4\u3002", (String)"FormulaModel_10", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
            String periodParam = this.params.get(PERIOD).toString();
            periodParam = periodParam.replaceAll("M_M", "");
            this.periodAct = Integer.parseInt(periodParam) + this.period;
        } else {
            this.periodAct = this.period;
        }
        if (StringUtils.isEmpty((CharSequence)this.orgNumber)) {
            if (this.params.get(ORGID) != null) {
                this.orgid = (Long)this.params.get(ORGID);
            } else if (this.params.get(ORGNUM) != null) {
                String orgnum = this.params.get(ORGNUM).toString();
                if (!StringUtils.isEmpty((CharSequence)orgnum)) {
                    QFilter orgFilter = new QFilter("number", "=", (Object)orgnum);
                    if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])new QFilter[]{orgFilter})) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u7ec4\u7ec7\u3002", (String)"FormulaModel_11", (String)"epm-eb-spread", (Object[])new Object[0]));
                    }
                    DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{orgFilter});
                    this.orgid = org.getLong("id");
                    this.orgNumber = org.getString("number");
                    this.orgName = org.getString("name");
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u7ec4\u7ec7\u3002", (String)"FormulaModel_11", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
        }
        QFilter orgFilter = new QFilter("org.id", "=", (Object)this.orgid);
        QFilter bookFilter = new QFilter("bookstype.id", "=", (Object)this.bookTypeId);
        DynamicObject book = BusinessDataServiceHelper.loadSingleFromCache((String)IntergrationUtil.getAccountBookMetadataNumber(), (String)"startperiod.id,accounttable.id,periodType.id", (QFilter[])new QFilter[]{orgFilter, bookFilter});
        if (book == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u8d26\u7c3f\u3002", (String)"FormulaModel_12", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        this.accounttable = book.getLong("accounttable.id");
        long periodType = book.getLong("periodType.id");
        this.startPeriodId = book.getLong("startperiod.id");
        if (this.accounttable == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u79d1\u76ee\u8868\u3002", (String)"FormulaModel_13", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        if (periodType == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u671f\u95f4\u3002", (String)"FormulaModel_10", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        if (this.startPeriodId == 0L && this.getFetchType().equals(FetchTypeEnum.NCYE.getValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5f00\u59cb\u671f\u95f4\u3002", (String)"FormulaModel_14", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        DynamicObject period = null;
        if (this.periodAct == 0) {
            QFilter periodTypeFilter;
            QFilter adjustFilter;
            fyFilter = new QFilter("periodyear", "=", (Object)(this.fy - 1));
            DynamicObjectCollection periodCollection = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fyFilter, adjustFilter = new QFilter("isadjustperiod", "=", (Object)isFalse), periodTypeFilter = new QFilter("periodtype", "=", (Object)periodType)}, (String)"periodnumber desc");
            if (periodCollection != null && periodCollection.size() > 0) {
                period = (DynamicObject)periodCollection.get(0);
            }
        } else {
            fyFilter = new QFilter("periodyear", "=", (Object)this.fy);
            QFilter periodFilter = new QFilter("periodnumber", "=", (Object)this.periodAct);
            QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)periodType);
            period = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fyFilter, periodFilter, periodTypeFilter});
        }
        if (period == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u671f\u95f4\u3002", (String)"FormulaModel_10", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        this.periodId = period.getLong("id");
        if (StringUtils.isEmpty((CharSequence)this.currencyNumber)) {
            QFilter currencyNumFilter;
            DynamicObject currency;
            if (this.params.get(CURRENCY) != null) {
                this.currencyNumber = this.params.get(CURRENCY).toString();
            }
            if ((currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id,name,number", (QFilter[])new QFilter[]{currencyNumFilter = new QFilter("number", "=", (Object)this.currencyNumber)})) == null) {
                this.currencyId = 0L;
            } else {
                this.currencyId = currency == null ? 0L : currency.getLong("id");
                this.currencyNumber = currency.getString("number");
                this.currencyName = currency.getString("name");
            }
        }
    }

    public abstract void getAccountItem(long var1, long var3);

    public void getAccountItem4Group(DynamicObjectCollection accountColl, long accounttableG) {
        for (DynamicObject account : accountColl) {
            if (accounttableG != account.getLong("accounttable") || !this.accountNumber.equals(account.getString("number"))) continue;
            this.accountId = account.getLong("id");
            this.accountName = account.getString("name");
            break;
        }
        if (this.accountId == null || this.accountId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u5b58\u5728\uff01", (String)"FormulaModel_15", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
    }

    protected Double getResult(Map<String, Object> value) {
        return this.getDoubleValue(value.get(this.fetchField));
    }

    protected Double getDoubleValue(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        return obj instanceof Double ? (Double)obj : Double.valueOf(obj.toString());
    }

    public abstract void parseAssvalStr(String var1, String var2, boolean var3);

    public abstract String unParse();

    public abstract List<Map<String, Object>> query();

    protected StringBuffer arrangeFormula() {
        StringBuffer formulaStr = new StringBuffer();
        Object[] formulaArray = new Object[]{this.getOrgNumber(), this.getBookTypeNumber(), this.getAccountAndAssvalStr(), this.getFetchType(), this.getYear(), this.getPeriod(), this.getCurrencyNumber()};
        for (int i = 0; i < formulaArray.length; ++i) {
            if (this.types[i] == String.class) {
                formulaStr.append('\"').append(formulaArray[i] == null ? "" : formulaArray[i]).append('\"').append(',');
                continue;
            }
            formulaStr.append(formulaArray[i]).append(',');
        }
        formulaStr = formulaStr.replace(formulaStr.length() - 1, formulaStr.length(), "");
        return formulaStr;
    }

    public Long getOrgid() {
        return this.orgid;
    }

    public void setOrgid(Long orgid) {
        this.orgid = orgid;
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public void setOrgNumber(String orgNumber) {
        this.orgNumber = orgNumber;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public long getBookTypeId() {
        return this.bookTypeId;
    }

    public void setBookTypeId(long bookTypeId) {
        this.bookTypeId = bookTypeId;
    }

    public String getBookTypeNumber() {
        return this.bookTypeNumber;
    }

    public void setBookTypeNumber(String bookTypeNumber) {
        this.bookTypeNumber = bookTypeNumber;
    }

    public String getBookTypeName() {
        return this.bookTypeName;
    }

    public void setBookTypeName(String bookTypeName) {
        this.bookTypeName = bookTypeName;
    }

    public String getFetchType() {
        return this.fetchType;
    }

    public void setFetchType(String fetchType) {
        this.fetchType = fetchType;
    }

    public String getFetchField() {
        return this.fetchField;
    }

    public void setFetchField(String fetchField) {
        this.fetchField = fetchField;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public void setCurrencyNumber(String currencyNumber) {
        this.currencyNumber = currencyNumber;
    }

    public String getCurrencyName() {
        return this.currencyName;
    }

    public void setCurrencyName(String currencyName) {
        this.currencyName = currencyName;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public List<String> getAsstNum() {
        return this.asstNum;
    }

    public void setAsstNum(List<String> asstNum) {
        this.asstNum = asstNum;
    }

    public List<String> getAsstVal() {
        return this.asstVal;
    }

    public void setAsstVal(List<String> asstVal) {
        this.asstVal = asstVal;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public String getAccountAndAssvalStr() {
        return this.accountAndAssvalStr;
    }

    public void setAccountAndAssvalStr(String accountStr) {
        this.accountAndAssvalStr = accountStr;
    }

    public int getFy() {
        return this.fy;
    }

    public void setFy(int fy) {
        this.fy = fy;
    }

    public int getPeriodAct() {
        return this.periodAct;
    }

    public void setPeriodAct(int periodAct) {
        this.periodAct = periodAct;
    }

    public long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(long periodId) {
        this.periodId = periodId;
    }

    public String getFormulaType() {
        return this.formulaType;
    }

    public void setFormulaType(String formulaType) {
        this.formulaType = formulaType;
    }

    public boolean isHasCheck() {
        return this.hasCheck;
    }

    public String getGroupCondition() {
        return this.groupCondition;
    }

    public void addGroupCondition(Object addGroupCondition) {
        this.groupCondition = this.groupCondition + addGroupCondition;
    }

    public long getAccounttable() {
        return this.accounttable;
    }

    public void setAccounttable(long accounttable) {
        this.accounttable = accounttable;
    }

    public String getMatchStr() {
        StringBuilder str = new StringBuilder();
        str.append(this.formulaType).append(',').append(this.orgNumber != null ? this.orgNumber : this.params.get(ORGNUM).toString()).append(',').append(this.bookTypeNumber).append(',').append(this.year).append(',').append(this.period).append(',').append(this.fetchType).append(',').append(this.currencyId).append(',').append(this.fetchField);
        for (String asstN : this.asstNum) {
            str.append(',');
            str.append(asstN.trim());
        }
        for (String asstV : this.asstVal) {
            str.append(',');
            str.append(StringUtils.isNotEmpty((CharSequence)asstV) ? "XXX" : asstV);
        }
        return str.toString();
    }

    public void setAsstFilter(List<Map<String, Long>> asstFilter) {
        this.asstFilter = asstFilter;
    }

    public List<Map<String, Long>> getAsstFilter() {
        return this.asstFilter;
    }
}

