/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.model.formula;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.ebcommon.common.enums.AcctTypeEnum;
import kd.epm.eb.ebBusiness.model.CashflowQueryParam;
import kd.epm.eb.ebBusiness.model.FormulaModel;
import kd.epm.eb.ebBusiness.model.GlServiceHelper;

public class AcctCFFormulaModel
extends FormulaModel {
    public AcctCFFormulaModel(String formulaStr) {
        super(formulaStr);
        this.formulaType = AcctTypeEnum.ACCTCF.index;
    }

    @Override
    public void parseAssvalStr(String formulaStr, String subjectStr, boolean checkAccoutExists) {
        if (StringUtils.isEmpty((CharSequence)subjectStr.trim())) {
            return;
        }
        this.setAccountAndAssvalStr(subjectStr);
        subjectStr = subjectStr.replaceAll("\\|", "\\| ");
        String[] subjectValues = subjectStr.split("\\|");
        if (subjectValues.length == 1) {
            this.accountNumber = subjectValues[0];
        } else {
            if ((subjectValues.length - 1) % 2 != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u9519\u8bef\u3002", (String)"AcctCFFormulaModel_1", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
            this.accountNumber = subjectValues[0];
        }
        if (StringUtils.isEmpty((CharSequence)this.accountNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"AcctCFFormulaModel_2", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        if (checkAccoutExists) {
            QFilter accountFilter = new QFilter("number", "=", (Object)this.accountNumber);
            if (!QueryServiceHelper.exists((String)"gl_cashflowitem", (QFilter[])new QFilter[]{accountFilter})) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u5b58\u5728\u3002", (String)"AcctCFFormulaModel_4", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
            DynamicObject account = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)"id,number,name", (QFilter[])new QFilter[]{accountFilter});
            this.accountId = account.getLong("id");
            this.accountName = account.getString("name");
        }
        for (int i = 1; i < subjectValues.length; i += 2) {
            this.asstNum.add(subjectValues[i]);
            if (StringUtils.isNotEmpty((CharSequence)subjectValues[i + 1].trim())) {
                this.asstVal.add(subjectValues[i + 1].trim());
                continue;
            }
            this.asstVal.add("");
        }
    }

    @Override
    public String unParse() {
        StringBuilder formulaStr = new StringBuilder();
        formulaStr.append("acctcf(");
        formulaStr.append(this.arrangeFormula());
        formulaStr.append(')');
        return formulaStr.toString();
    }

    @Override
    public List<Map<String, Object>> query() {
        CashflowQueryParam param = new CashflowQueryParam();
        param.setCfitemIds(new long[]{this.accountId});
        param.setBookTypeId(this.getBookTypeId());
        param.setCurrencyId(this.getCurrencyId());
        param.setOrgId(this.getOrgid());
        param.setPeriodId(this.getPeriodId());
        param.addSelector(this.getFetchField());
        param.addSelector("cfitem");
        this.log.startWatch();
        this.log.info("\u53d6\u6570\u516c\u5f0f:" + this.getFormulaStr() + ";\u53d6\u6570\u7c7b\u578b:" + this.getFetchType() + ";\u8bf7\u6c42\u53c2\u6570:" + param);
        List<Map<String, Object>> result = GlServiceHelper.getCashFlowAmount(param);
        this.log.info("\u8fd4\u56de\u6570\u636e:" + (result == null ? "null" : result.toString()));
        return result;
    }

    @Override
    public void getAccountItem(long accounttable, long orgid) {
        QFilter acNumberFilter = new QFilter("number", "=", (Object)this.accountNumber);
        DynamicObject account = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)"id,number,name", (QFilter[])new QFilter[]{acNumberFilter});
        if (account == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u5b58\u5728\u3002", (String)"AcctCFFormulaModel_3", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        this.accountId = account.getLong("id");
        this.accountName = account.getString("name");
    }
}

