/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.model.formula;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.epm.eb.common.ebcommon.common.enums.AcctTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.FetchTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.MapInitHelper;
import kd.epm.eb.ebBusiness.model.BalanceQueryParam;
import kd.epm.eb.ebBusiness.model.FormulaModel;
import kd.epm.eb.ebBusiness.model.GlServiceHelper;

public class AcctFormulaModel
extends FormulaModel {
    private boolean isSubAmountOfCurYear = false;
    private ArrayList<String> flexs = new ArrayList();

    public AcctFormulaModel(String formulaStr) {
        super(formulaStr);
        this.formulaType = AcctTypeEnum.ACCT.index;
    }

    @Override
    public void parseAssvalStr(String formulaStr, String accountStr, boolean checkAccoutExists) {
        if (StringUtils.isEmpty((CharSequence)accountStr.trim())) {
            return;
        }
        this.setAccountAndAssvalStr(accountStr);
        accountStr = accountStr.replaceAll("\\|", "\\| ");
        String[] accountValues = accountStr.split("\\|");
        if (accountValues.length == 1) {
            this.accountNumber = accountValues[0];
        } else {
            if ((accountValues.length - 1) % 2 != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u6709\u8bef\u3002", (String)"AcctFormulaModel_1", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
            this.accountNumber = accountValues[0];
        }
        if (StringUtils.isEmpty((CharSequence)this.accountNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u516c\u5f0f\u79d1\u76ee\u7f16\u7801\u201d\u3002", (String)"AcctFormulaModel_2", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        if (checkAccoutExists) {
            QFilter accountFilter = new QFilter("number", "=", (Object)this.accountNumber);
            if (!QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])new QFilter[]{accountFilter})) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u4f1a\u8ba1\u79d1\u76ee\u7f16\u7801\u9519\u8bef\uff0c\u79d1\u76ee\u4e0d\u5b58\u5728\u3002", (String)"AcctFormulaModel_3", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
            DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (String)"id,number,name", (QFilter[])new QFilter[]{accountFilter});
            this.accountId = account.getLong("id");
        }
        for (int i = 1; i < accountValues.length; i += 2) {
            this.asstNum.add(accountValues[i].trim());
            if (StringUtils.isNotEmpty((CharSequence)accountValues[i + 1].trim())) {
                this.asstVal.add(accountValues[i + 1].trim());
                continue;
            }
            this.asstVal.add("");
        }
    }

    @Override
    public String unParse() {
        StringBuilder formulaStr = new StringBuilder();
        formulaStr.append("acct(");
        formulaStr.append(this.arrangeFormula());
        formulaStr.append(')');
        return formulaStr.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Map<String, Object>> query() {
        QFilter[] filters;
        String selectFields;
        DynamicObject[] asstArray;
        boolean isTrue = true;
        BalanceQueryParam param = new BalanceQueryParam();
        param.setBookTypeId(this.getBookTypeId());
        param.setCurrencyId(this.getCurrencyId());
        param.setOrgId(this.getOrgid());
        if (this.getFetchType().equals(FetchTypeEnum.NCYE.getValue())) {
            String sql = "SELECT MIN(FID) ID FROM  T_BD_PERIOD WHERE FPERIODYEAR=(SELECT FPERIODYEAR FROM T_BD_PERIOD WHERE FID=? ) AND FTYPEID=(SELECT FTYPEID FROM T_BD_PERIOD WHERE FID= ?) ";
            DataSet periodOfYearDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{this.getPeriodId(), this.getPeriodId()});
            Long periodOfYear = 0L;
            while (periodOfYearDataSet.hasNext()) {
                Row curr = periodOfYearDataSet.next();
                periodOfYear = curr.getLong("ID");
            }
            if (periodOfYear == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5e74\u521d\u671f\u95f4\u5931\u8d25", (String)"AcctFormulaModel_4", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
            if (periodOfYear >= this.startPeriodId) {
                param.setPeriodId(periodOfYear);
            } else {
                param.setPeriodId(this.startPeriodId);
                this.isSubAmountOfCurYear = true;
            }
        } else {
            param.setPeriodId(this.getPeriodId());
        }
        FetchTypeEnum[] ft = FetchTypeEnum.values();
        Arrays.stream(ft).filter(p -> AcctTypeEnum.ACCT.index.equals(p.getType())).map(p -> p.getField(Long.valueOf(param.getCurrencyId()))).distinct().forEach(p -> param.addSelector((String)p));
        param.addGroupBy("account");
        if (this.getFetchType().equals(FetchTypeEnum.BQFSE_1.getValue()) || this.getFetchType().equals(FetchTypeEnum.BNLJFSE_1.getValue()) || this.getFetchType().equals(FetchTypeEnum.QMJFYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.QMDFYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.NCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.JFNCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFNCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.SY.getValue()) || this.getFetchType().equals(FetchTypeEnum.SL.getValue()) || this.getFetchType().equals(FetchTypeEnum.JFQCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFQCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.JFQMYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFQMYE.getValue())) {
            param.addGroupBy("account.dc dc");
        }
        ArrayList<Map<String, Long>> assgrps = new ArrayList();
        List<Map<String, Long>> oldlist = param.getAccountAssgrp().get(this.accountId);
        if (oldlist != null) {
            assgrps = oldlist;
        }
        if ((this.getFetchType().equals(FetchTypeEnum.JFNCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFNCYE.getValue())) && this.asstNum.isEmpty() && (asstArray = BusinessDataServiceHelper.load((String)"bd_accountview", (String)(selectFields = "id, checkitementry, checkitementry.asstactitem, checkitementry.asstactitem.number"), (QFilter[])(filters = new QFilter[]{new QFilter("id", "=", (Object)this.getAccountId())}))) != null) {
            for (DynamicObject dynamicObject : asstArray) {
                DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("checkitementry");
                for (DynamicObject object : entry) {
                    DynamicObject asstactitem = object.getDynamicObject("asstactitem");
                    this.asstNum.add(asstactitem.getString("number"));
                    this.asstVal.add("");
                }
            }
        }
        if (this.asstNum.size() > 0) {
            HashMap match = new HashMap(this.asstNum.size());
            for (int i = 0; i < this.asstNum.size(); ++i) {
                match.put(this.asstNum.get(i), this.asstVal.get(i));
            }
            String selectFields2 = "number,valuesource,valuetype,flexfield,assistanttype";
            QFilter[] filters2 = new QFilter[]{new QFilter("number", "in", (Object)this.asstNum)};
            DynamicObjectCollection assts = QueryServiceHelper.query((String)"bd_asstacttype", (String)selectFields2, (QFilter[])filters2);
            if (assts == null || assts.size() <= 0) throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"AcctFormulaModel_5", (String)"epm-eb-spread", (Object[])new Object[0]));
            if (assts.size() != this.asstNum.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"AcctFormulaModel_5", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            for (DynamicObject asst : assts) {
                String number = asst.getString("number");
                String valuetype = asst.getString("valuetype");
                String flexfield = asst.getString("flexfield");
                String f7Model = asst.getString("valuesource");
                long assistantType = asst.getLong("assistanttype");
                if ("3".equals(valuetype)) {
                    if (StringUtils.isNotEmpty((CharSequence)((String)match.get(number)).trim())) {
                        hashMap.put(flexfield, Long.valueOf((String)match.get(number)));
                        param.addGroupBy(flexfield);
                        continue;
                    }
                    if (this.getFetchType().equals(FetchTypeEnum.JFQCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFQCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.JFQMYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFQMYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.JFNCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFNCYE.getValue())) {
                        param.setSpecialAccount(false);
                        param.addGroupBy(flexfield);
                    }
                    hashMap.put(flexfield, null);
                    continue;
                }
                if ("1".equals(valuetype)) {
                    if (StringUtils.isNotEmpty((CharSequence)((String)match.get(number)).trim())) {
                        QFilter[] itemFilters = new QFilter[]{new QFilter("number", "=", match.get(number))};
                        DynamicObject asstItem = BusinessDataServiceHelper.loadSingleFromCache((String)f7Model, (String)"id", (QFilter[])itemFilters);
                        if (asstItem == null) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u9879\u76ee\u4e0d\u5b58\u5728\u3002", (String)"AcctFormulaModel_6", (String)"epm-eb-spread", (Object[])new Object[0]));
                        }
                        hashMap.put(flexfield, asstItem.getLong("id"));
                        param.addGroupBy(flexfield);
                        continue;
                    }
                    if (this.getFetchType().equals(FetchTypeEnum.JFQCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFQCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.JFQMYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFQMYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.JFNCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFNCYE.getValue())) {
                        param.setSpecialAccount(false);
                        param.addGroupBy(flexfield);
                    }
                    hashMap.put(flexfield, null);
                    continue;
                }
                if (!"2".equals(valuetype)) continue;
                if (StringUtils.isNotEmpty((CharSequence)((String)match.get(number)).trim())) {
                    QFilter filter = new QFilter("number", "=", match.get(number));
                    filter.and(new QFilter("group", "=", (Object)assistantType));
                    DynamicObject assitantData = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_assistantdata_detail", (String)"id", (QFilter[])new QFilter[]{filter});
                    if (assitantData == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u9879\u76ee\u4e0d\u5b58\u5728\u3002", (String)"AcctFormulaModel_6", (String)"epm-eb-spread", (Object[])new Object[0]));
                    }
                    hashMap.put(flexfield, assitantData.getLong("id"));
                    param.addGroupBy(flexfield);
                    continue;
                }
                if (this.getFetchType().equals(FetchTypeEnum.JFQCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFQCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.JFQMYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFQMYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.JFNCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFNCYE.getValue())) {
                    param.setSpecialAccount(false);
                    param.addGroupBy(flexfield);
                }
                hashMap.put(flexfield, null);
            }
            hashMap.entrySet().stream().forEach(p -> this.flexs.add((String)p.getKey()));
            assgrps.add(hashMap);
            param.setAccountAssgrp(this.accountId, assgrps);
        } else {
            param.setAccountAssgrp(this.accountId, assgrps);
        }
        if (this.getFetchType().equals(FetchTypeEnum.QCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.QMYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.QMJFYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.QMDFYE.getValue())) {
            param.setSubstractPL(false);
        }
        if (this.getFetchType().equals(FetchTypeEnum.SY.getValue()) || this.getFetchType().equals(FetchTypeEnum.SL.getValue())) {
            param.setSubstractPL(true);
        }
        if (this.getFetchType().equals(FetchTypeEnum.JFNCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFNCYE.getValue())) {
            param.setSpecialAccount(false);
        }
        HashMap<Long, Set> idMap = new HashMap<Long, Set>();
        HashMap<Long, Set> accountAssgrpMap = new HashMap<Long, Set>();
        if (this.getFetchType().equals(FetchTypeEnum.QMJFYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.QMDFYE.getValue())) {
            HashSet<Long> keySet = new HashSet<Long>(param.getAccountAssgrp().keySet());
            for (Long l : keySet) {
                Object basedataFilter;
                Long masterId;
                if (param.getAccountAssgrp().get(l).isEmpty()) {
                    masterId = l;
                    QFilter filter = new QFilter("masterid", "=", (Object)masterId);
                    DynamicObjectCollection accountColl = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number,name,masterid,accounttable,parent", (QFilter[])new QFilter[]{filter});
                    QFilter filter2 = new QFilter("parent", "=", (Object)((DynamicObject)accountColl.get(0)).getLong("id"));
                    DynamicObjectCollection childrenColl = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number,name,masterid,accounttable,parent", (QFilter[])new QFilter[]{filter2, basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)this.getOrgid())});
                    if (childrenColl.isEmpty()) continue;
                    for (DynamicObject dynamicObject : childrenColl) {
                        Set set = idMap.getOrDefault(masterId, new HashSet());
                        set.add(dynamicObject.getLong("masterid"));
                        idMap.put(masterId, set);
                        param.setAccountAssgrp(dynamicObject.getLong("masterid"), new ArrayList<Map<String, Long>>());
                    }
                    continue;
                }
                masterId = l;
                List<Map<String, Long>> value = param.getAccountAssgrp().get(l);
                for (Map<String, Long> map : value) {
                    basedataFilter = map.entrySet().iterator();
                    while (basedataFilter.hasNext()) {
                        Map.Entry<String, Long> entry = basedataFilter.next();
                        String k = entry.getKey();
                        param.addGroupBy(k);
                        if (entry.getValue() != null) continue;
                        Set set = accountAssgrpMap.getOrDefault(masterId, new HashSet());
                        set.add(k);
                        accountAssgrpMap.put(masterId, set);
                    }
                }
            }
        }
        this.log.startWatch();
        this.log.info("\u53d6\u6570\u516c\u5f0f:" + this.getFormulaStr() + ";\u53d6\u6570\u7c7b\u578b:" + this.getFetchType() + ";\u8bf7\u6c42\u53c2\u6570:" + param);
        List<Map<String, Object>> result = GlServiceHelper.getBalance(param);
        this.log.info("\u8fd4\u56de\u6570\u636e:" + (result == null ? "null" : result.toString()));
        if (this.getFetchType().equals(FetchTypeEnum.JFQCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFQCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.JFQMYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFQMYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.JFNCYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.DFNCYE.getValue())) {
            if (result == null || !this.getFetchType().equals(FetchTypeEnum.JFNCYE.getValue()) && !this.getFetchType().equals(FetchTypeEnum.DFNCYE.getValue()) || !param.getAccountAssgrp().get(this.accountId).isEmpty()) return this.sum(result);
            return this.handleJFDFNCYE(param, result);
        }
        if (!idMap.isEmpty()) {
            for (Map.Entry entry : idMap.entrySet()) {
                Long parentId = (Long)entry.getKey();
                Set childrenSet = (Set)entry.getValue();
                Map<Long, Double> resultMap = this.transferToMap(result);
                Double parentValue = 0.0;
                for (Long childId : childrenSet) {
                    parentValue = parentValue + this.getDoubleValue(resultMap.get(childId));
                }
                if (result == null) continue;
                Iterator<Map<String, Object>> it = result.iterator();
                while (it.hasNext()) {
                    Map<String, Object> map = it.next();
                    if (((Long)map.get("account")).equals(parentId)) {
                        map.put("endlocal", String.valueOf(parentValue));
                        map.put("dc", "1");
                    }
                    if (!childrenSet.contains((Long)map.get("account"))) continue;
                    it.remove();
                }
            }
            return result;
        }
        if (accountAssgrpMap.isEmpty()) return result;
        if (result == null) return result;
        for (Map.Entry entry : accountAssgrpMap.entrySet()) {
            Double accountResult = this.getAccountResult(result, entry);
            result.add(MapInitHelper.ofMap((Object)"account", entry.getKey(), (Object)"endlocal", (Object)String.valueOf(Math.abs(accountResult)), (Object)"dc", (Object)(accountResult > 0.0 ? "1" : "-1"), (Object)"isfinal", (Object)isTrue));
        }
        result.removeIf(e -> e.get("isfinal") == null);
        return result;
    }

    private List<Map<String, Object>> handleJFDFNCYE(BalanceQueryParam param, List<Map<String, Object>> result) {
        ArrayList<Map<String, Object>> resLs = new ArrayList<Map<String, Object>>();
        QFilter filter = new QFilter("parent", "=", (Object)this.accountId);
        DynamicObjectCollection childrenCollection = QueryServiceHelper.query((String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{filter});
        if (!childrenCollection.isEmpty()) {
            HashSet set = new HashSet();
            childrenCollection.forEach(e -> set.add(e.getLong("id")));
            ArrayList<Double> yeardebitlocal = new ArrayList<Double>();
            ArrayList<Double> yearcreditlocal = new ArrayList<Double>();
            for (Map<String, Object> map : result) {
                if (!set.contains(map.get("account"))) continue;
                String dc = (String)map.get("dc");
                double yearlocal = "1".equals(dc) ? this.getDoubleValue(map.get("endlocal")) - (this.getDoubleValue(map.get("yeardebitlocal")) - this.getDoubleValue(map.get("yearcreditlocal"))) : this.getDoubleValue(map.get("endlocal")) - (this.getDoubleValue(map.get("yearcreditlocal")) - this.getDoubleValue(map.get("yeardebitlocal")));
                if ("1".equals(dc)) {
                    if (yearlocal > 0.0) {
                        yeardebitlocal.add(yearlocal);
                        continue;
                    }
                    yearcreditlocal.add(-1.0 * yearlocal);
                    continue;
                }
                if (yearlocal > 0.0) {
                    yearcreditlocal.add(yearlocal);
                    continue;
                }
                yeardebitlocal.add(-1.0 * yearlocal);
            }
            HashMap<String, Double> res = new HashMap<String, Double>();
            res.put("yeardebitlocal", yeardebitlocal.stream().reduce(Double::sum).orElseGet(() -> 0.0));
            res.put("yearcreditlocal", yearcreditlocal.stream().reduce(Double::sum).orElseGet(() -> 0.0));
            resLs.add(res);
        }
        return resLs;
    }

    private Double getAccountResult(List<Map<String, Object>> result, Map.Entry<Long, Set<String>> entry) {
        Long accountId = entry.getKey();
        Set<String> assgrpNum = entry.getValue();
        Double re = 0.0;
        for (Map<String, Object> map : result) {
            if (!((Long)map.get("account")).equals(accountId) || !this.isContainsAllAssgrpInKeySet(map, assgrpNum)) continue;
            Double value = this.getDoubleValue(map.get("endlocal")) * (double)Integer.parseInt(map.get("dc").toString());
            if (value > 0.0) {
                if (this.getFetchType().equals(FetchTypeEnum.QMDFYE.getValue())) {
                    value = 0.0;
                }
            } else if (value < 0.0) {
                if (this.getFetchType().equals(FetchTypeEnum.QMJFYE.getValue())) {
                    value = 0.0;
                }
            } else if (BigDecimal.valueOf(value).compareTo(BigDecimal.valueOf(0.0)) == 0) {
                value = 0.0;
            }
            re = re + value;
        }
        return re;
    }

    private boolean isContainsAllAssgrpInKeySet(Map<String, Object> map, Set<String> assgrpNum) {
        for (String ass : assgrpNum) {
            if (map.containsKey(ass)) continue;
            return false;
        }
        return true;
    }

    private Map<Long, Double> transferToMap(List<Map<String, Object>> result) {
        LinkedHashMap<Long, Double> resultMap = new LinkedHashMap<Long, Double>();
        for (Map<String, Object> map : result) {
            Double value = this.getDoubleValue(map.get("endlocal")) * (double)Integer.parseInt(map.get("dc").toString());
            if (this.getFetchType().equals(FetchTypeEnum.QMJFYE.getValue())) {
                if (value > 0.0) {
                    resultMap.put((Long)map.get("account"), value);
                    continue;
                }
                resultMap.put((Long)map.get("account"), 0.0);
                continue;
            }
            if (value < 0.0) {
                resultMap.put((Long)map.get("account"), value);
                continue;
            }
            resultMap.put((Long)map.get("account"), 0.0);
        }
        return resultMap;
    }

    @Override
    public void getAccountItem(long accounttable, long orgid) {
        QFilter acTableFilter = new QFilter("accounttable.id", "=", (Object)accounttable);
        QFilter acNumberFilter = new QFilter("number", "=", (Object)this.accountNumber);
        QFilter qc = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgid);
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (String)"id,number,name,masterid", (QFilter[])new QFilter[]{acNumberFilter, acTableFilter, qc});
        if (account == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u5b58\u5728\uff01", (String)"AcctFormulaModel_7", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        this.accountId = account.getLong("id");
        this.accountName = account.getString("name");
        this.accountNumber = account.getString("number");
    }

    private List<Map<String, Object>> sum(List<Map<String, Object>> result) {
        if (result == null || result.size() == 0) {
            return result;
        }
        Map<String, List<Map>> flexMap = result.stream().filter(p -> Long.toString(this.accountId).equals(p.get("account").toString())).collect(Collectors.groupingBy(p -> {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.flexs.size(); ++i) {
                builder.append(p.get(this.flexs.get(i)));
            }
            return builder.toString();
        }));
        ArrayList sumByflex = new ArrayList(flexMap.size());
        for (Map.Entry<String, List<Map>> entry : flexMap.entrySet()) {
            List<Map> currrow = entry.getValue();
            HashMap outrow = new HashMap();
            outrow.put("dc", currrow.get(0).get("dc"));
            outrow.put("beginlocal", currrow.stream().map(p -> this.getDoubleValue(p.get("beginlocal"))).reduce(Double::sum).orElseGet(() -> 0.0));
            outrow.put("endlocal", currrow.stream().map(p -> this.getDoubleValue(p.get("endlocal"))).reduce(Double::sum).orElseGet(() -> 0.0));
            outrow.put("yeardebitlocal", currrow.stream().map(p -> this.getDoubleValue(p.get("yeardebitlocal"))).reduce(Double::sum).orElseGet(() -> 0.0));
            outrow.put("yearcreditlocal", currrow.stream().map(p -> this.getDoubleValue(p.get("yearcreditlocal"))).reduce(Double::sum).orElseGet(() -> 0.0));
            sumByflex.add(outrow);
        }
        HashMap<String, Double> res = new HashMap<String, Double>();
        ArrayList begindebitfor = new ArrayList();
        ArrayList begincreditfor = new ArrayList();
        ArrayList enddebitlocal = new ArrayList();
        ArrayList endcreditlocal = new ArrayList();
        ArrayList yeardebitlocal = new ArrayList();
        ArrayList yearcreditlocal = new ArrayList();
        sumByflex.forEach(p -> {
            String dc = (String)p.get("dc");
            double yearlocal = "1".equals(dc) ? this.getDoubleValue(p.get("endlocal")) - (this.getDoubleValue(p.get("yeardebitlocal")) - this.getDoubleValue(p.get("yearcreditlocal"))) : this.getDoubleValue(p.get("endlocal")) - (this.getDoubleValue(p.get("yearcreditlocal")) - this.getDoubleValue(p.get("yeardebitlocal")));
            if ("1".equals(dc)) {
                if (this.getDoubleValue(p.get("beginlocal")) > 0.0) {
                    begindebitfor.add(this.getDoubleValue(p.get("beginlocal")));
                } else {
                    begincreditfor.add(-1.0 * this.getDoubleValue(p.get("beginlocal")));
                }
                if (this.getDoubleValue(p.get("endlocal")) > 0.0) {
                    enddebitlocal.add(this.getDoubleValue(p.get("endlocal")));
                } else {
                    endcreditlocal.add(-1.0 * this.getDoubleValue(p.get("endlocal")));
                }
                if (yearlocal > 0.0) {
                    yeardebitlocal.add(yearlocal);
                } else {
                    yearcreditlocal.add(-1.0 * yearlocal);
                }
            } else {
                if (this.getDoubleValue(p.get("beginlocal")) > 0.0) {
                    begincreditfor.add(this.getDoubleValue(p.get("beginlocal")));
                } else {
                    begindebitfor.add(-1.0 * this.getDoubleValue(p.get("beginlocal")));
                }
                if (this.getDoubleValue(p.get("endlocal")) > 0.0) {
                    endcreditlocal.add(this.getDoubleValue(p.get("endlocal")));
                } else {
                    enddebitlocal.add(-1.0 * this.getDoubleValue(p.get("endlocal")));
                }
                if (yearlocal > 0.0) {
                    yearcreditlocal.add(yearlocal);
                } else {
                    yeardebitlocal.add(-1.0 * yearlocal);
                }
            }
        });
        res.put("begindebitfor", begindebitfor.stream().reduce(Double::sum).orElseGet(() -> 0.0));
        res.put("begincreditfor", begincreditfor.stream().reduce(Double::sum).orElseGet(() -> 0.0));
        res.put("enddebitlocal", enddebitlocal.stream().reduce(Double::sum).orElseGet(() -> 0.0));
        res.put("endcreditlocal", endcreditlocal.stream().reduce(Double::sum).orElseGet(() -> 0.0));
        res.put("yeardebitlocal", yeardebitlocal.stream().reduce(Double::sum).orElseGet(() -> 0.0));
        res.put("yearcreditlocal", yearcreditlocal.stream().reduce(Double::sum).orElseGet(() -> 0.0));
        ArrayList<Map<String, Object>> resLs = new ArrayList<Map<String, Object>>();
        resLs.add(res);
        return resLs;
    }

    @Override
    protected Double getResult(Map<String, Object> value) {
        if (this.getFetchType().equals(FetchTypeEnum.BQFSE_1.getValue()) || this.getFetchType().equals(FetchTypeEnum.SY.getValue())) {
            String dc = (String)value.get("dc");
            if ("1".equals(dc)) {
                return this.getDoubleValue(value.get("debitlocal")) - this.getDoubleValue(value.get("creditlocal"));
            }
            return this.getDoubleValue(value.get("creditlocal")) - this.getDoubleValue(value.get("debitlocal"));
        }
        if (this.getFetchType().equals(FetchTypeEnum.BNLJFSE_1.getValue()) || this.getFetchType().equals(FetchTypeEnum.SL.getValue())) {
            String dc = (String)value.get("dc");
            if ("1".equals(dc)) {
                return this.getDoubleValue(value.get("yeardebitlocal")) - this.getDoubleValue(value.get("yearcreditlocal"));
            }
            return this.getDoubleValue(value.get("yearcreditlocal")) - this.getDoubleValue(value.get("yeardebitlocal"));
        }
        if (this.getFetchType().equals(FetchTypeEnum.QMJFYE.getValue())) {
            String dc = (String)value.get("dc");
            if ("1".equals(dc)) {
                return this.getDoubleValue(value.get(this.fetchField));
            }
            return this.getDoubleValue(value.get(this.fetchField)) * -1.0;
        }
        if (this.getFetchType().equals(FetchTypeEnum.QMDFYE.getValue())) {
            String dc = (String)value.get("dc");
            if ("1".equals(dc)) {
                return this.getDoubleValue(value.get(this.fetchField)) * -1.0;
            }
            return this.getDoubleValue(value.get(this.fetchField));
        }
        if (this.getFetchType().equals(FetchTypeEnum.NCYE.getValue())) {
            String dc = (String)value.get("dc");
            if (this.isSubAmountOfCurYear) {
                if ("1".equals(dc)) {
                    return this.getDoubleValue(value.get("endlocal")) - (this.getDoubleValue(value.get("yeardebitlocal")) - this.getDoubleValue(value.get("yearcreditlocal")));
                }
                return this.getDoubleValue(value.get("endlocal")) - (this.getDoubleValue(value.get("yearcreditlocal")) - this.getDoubleValue(value.get("yeardebitlocal")));
            }
            return this.getDoubleValue(value.get(this.fetchField));
        }
        if (this.getFetchType().equals(FetchTypeEnum.JFNCYE.getValue())) {
            return this.getDoubleValue(value.get("yeardebitlocal"));
        }
        if (this.getFetchType().equals(FetchTypeEnum.DFNCYE.getValue())) {
            return this.getDoubleValue(value.get("yearcreditlocal"));
        }
        if (this.getFetchType().equals(FetchTypeEnum.JFQCYE.getValue())) {
            return this.getDoubleValue(value.get("begindebitfor"));
        }
        if (this.getFetchType().equals(FetchTypeEnum.DFQCYE.getValue())) {
            return this.getDoubleValue(value.get("begincreditfor"));
        }
        if (this.getFetchType().equals(FetchTypeEnum.JFQMYE.getValue())) {
            return this.getDoubleValue(value.get("enddebitlocal"));
        }
        if (this.getFetchType().equals(FetchTypeEnum.DFQMYE.getValue())) {
            return this.getDoubleValue(value.get("endcreditlocal"));
        }
        if (this.getFetchType().equals(FetchTypeEnum.QCJDYE.getValue()) || this.getFetchType().equals(FetchTypeEnum.QMJDYE.getValue())) {
            return Math.abs(this.getDoubleValue(value.get(this.fetchField)));
        }
        return this.getDoubleValue(value.get(this.fetchField));
    }
}

