/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.mq;

import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;
import kd.epm.eb.common.ebcommon.common.util.MapInitHelper;
import kd.epm.eb.common.enums.CacheTypeEnum;
import kd.epm.eb.ebBusiness.mq.MQMessage;
import kd.epm.eb.ebBusiness.mq.MQMessageTypeEnum;
import kd.epm.eb.ebBusiness.mq.consumer.MessageConsumerFactory;

public final class MQMessagePublisherServiceHelper {
    public static final String MQ_REGION = "epm";
    public static final String MQ_APPID = "eb";
    public static final String MQ_QUEUE_NAME = "eb_queue";
    public static final String MQ_CALC_QUEUE = "eb_calc_queue";
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(MQMessagePublisherServiceHelper.class);

    public static void publishMessage(MQMessage msg, boolean isTranscation) {
        if (ThreadCache.get((Object)msg.genSendMQFormatMessage()) != null) {
            return;
        }
        log.info(String.format("publish-bcm-mq-message{%s}", msg.genSendMQFormatMessage()));
        MessageConsumerFactory.getConsumer(msg).onMessage(msg, null, false, null);
        ThreadCache.put((Object)msg.genSendMQFormatMessage(), (Object)Boolean.TRUE);
    }

    public static void publishClearDimMemberCache(String modelNum, String dimNum) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_Local_Cache_Clear);
        msg.setSendMessage(MapInitHelper.ofMap((Object)"cache_type", (Object)CacheTypeEnum.DimMemberCache, (Object)"clear_type", (Object)"clear_all_like", (Object)"model", (Object)modelNum, (Object)"dim", (Object)dimNum));
        MQMessagePublisherServiceHelper.publishMessage(msg, false);
    }

    public static void publishClearAllCacheByType(CacheTypeEnum cacheType) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_Local_Cache_Clear);
        msg.setSendMessage(MapInitHelper.ofMap((Object)"clear_type", (Object)"clear_all_cache", (Object)"cache_type", (Object)cacheType));
        MQMessagePublisherServiceHelper.publishMessage(msg, false);
    }

    public static void publishInvalidateTemplateModel(List<String> ids) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_Template_Cache_Clear);
        msg.setSendMessage(MapInitHelper.ofMap((Object)"templateIds", ids));
        MQMessagePublisherServiceHelper.publishMessage(msg, false);
    }

    public static void publishInvalidateTemplateDispense(String modelNum) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_TemplateDispense_Cache_Clear);
        msg.setSendMessage(MapInitHelper.ofMap((Object)"modelNum", (Object)modelNum));
        MQMessagePublisherServiceHelper.publishMessage(msg, false);
    }
}

