/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.olap;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.ebBusiness.olap.IRelaMembSupplier;
import kd.epm.eb.ebBusiness.serviceHelper.MemberServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.TreeStructureServiceHelper;

public class OrgRelaMembSupplier
implements IRelaMembSupplier<String, String> {
    private static final long serialVersionUID = 1L;
    private Long _mainOrgId;
    private String _mainOrgNum;
    private Long _modelId;
    private String superParentLongNum;
    private Map<String, String> snapshot;

    public Long get_mainOrgId() {
        return this._mainOrgId;
    }

    public OrgRelaMembSupplier(Long mainOrgId, String mainOrgNum, Long modelId) {
        this._mainOrgId = mainOrgId;
        this._mainOrgNum = mainOrgNum;
        this._modelId = modelId;
        this.snapshot = new HashMap<String, String>(1);
        this.initSuperParentLongNumber();
    }

    @Override
    public String access(String orgNum) {
        if (!this.snapshot.containsKey(orgNum)) {
            this.snapshot.put(orgNum, this.getRelaMembInMainOrgTreeStruct(orgNum));
        }
        return this.snapshot.get(orgNum);
    }

    private String getRelaMembInMainOrgTreeStruct(String orgNum) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this._modelId);
        qf.add("longnumber", "like", (Object)(this.superParentLongNum + '!' + "%"));
        qf.add("number", "=", (Object)orgNum);
        DynamicObject dyna = null;
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"longnumber,parent.number", (QFilter[])qf.toArray());
        if (coll != null && coll.size() == 1) {
            dyna = (DynamicObject)coll.get(0);
        }
        if (dyna == null) {
            dyna = MemberServiceHelper.getBaseMember("epm_entitymembertree", "parent.number", new QFBuilder().add("model", "=", (Object)this._modelId).and("number", "=", (Object)orgNum).toArray()[0]);
        }
        if (dyna == null || "Entity".equals(dyna.getString("parent.number"))) {
            return orgNum;
        }
        return String.join((CharSequence)"_", dyna.getString("parent.number"), orgNum);
    }

    private void initSuperParentLongNumber() {
        DynamicObject dyna = TreeStructureServiceHelper.getSelfById("epm_entitymembertree", this._mainOrgId, "longnumber,parent.number");
        String split = String.valueOf('!');
        String[] splitArr = dyna.getString("longnumber").split(split);
        String string = this.superParentLongNum = splitArr.length >= 2 ? String.join((CharSequence)split, splitArr[0], splitArr[1]) : splitArr[0];
        if (!"Entity".equals(dyna.getString("parent.number"))) {
            this.snapshot.put(this._mainOrgNum, String.join((CharSequence)"_", dyna.getString("parent.number"), this._mainOrgNum));
        }
    }
}

