/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.olap.dynamic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.enums.AggOprtEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimEntityNumEnum;
import kd.epm.eb.common.ebcommon.common.enums.StorageTypeEnum;
import kd.epm.eb.ebBusiness.serviceHelper.MemberTreeNode;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.TreeStructureServiceHelper;

public class DynamicOlapHelper {
    public static void setDynamicModel(long modelId, String cube, boolean isDynamic) {
        if (StringUtils.isEmpty((String)cube)) {
            DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"epm_model", (String)"number");
            cube = model.getString("number");
        }
        ArrayList<DynamicObject> changeDim = new ArrayList<DynamicObject>();
        for (DynamicObject dim : BusinessDataServiceHelper.load((String)"epm_dimension", (String)"id,number,membermodel,isexcdycompute", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)})) {
            String membermodel = dim.getString("membermodel");
            if (isDynamic && (DimEntityNumEnum.ENTITY.getEntityNum().equals(membermodel) || DimEntityNumEnum.YEAR.getEntityNum().equals(membermodel) || DimEntityNumEnum.PERIOD.getEntityNum().equals(membermodel) || DimEntityNumEnum.SCENARIO.getEntityNum().equals(membermodel) || DimEntityNumEnum.CURRENCY.getEntityNum().equals(membermodel))) continue;
            String number = dim.getString("number");
            dim.set("isexcdycompute", (Object)isDynamic);
            changeDim.add(dim);
            if (isDynamic) {
                DynamicOlapHelper.setDynamicDim(modelId, cube, number);
                continue;
            }
            DynamicOlapHelper.unSetDynamicDim(modelId, cube, number);
        }
        if (!changeDim.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])changeDim.toArray(new DynamicObject[0]));
        }
    }

    public static void setDynamicDim(long modelId, String cube, String dimnum) {
        String entity = DimEntityNumEnum.getEntieyNumByNumber((String)dimnum);
        Map<Long, MemberTreeNode> membersMap = TreeStructureServiceHelper.getAllMember(entity, modelId, (Pair<Supplier<String>, Function<DynamicObject, Map<String, Object>>>)Pair.onePair(() -> "storagetype,aggoprt,", obj -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("storagetype", obj.getString("storagetype"));
            map.put("aggoprt", obj.getString("aggoprt"));
            return map;
        }));
        List<Long> ids = DynamicOlapHelper.getCanChangeIds(membersMap);
        if (!ids.isEmpty()) {
            DynamicObject[] mbs = BusinessDataServiceHelper.load((String)entity, (String)"number,storagetype", (QFilter[])new QFilter[]{new QFilter("dimension.number", "=", (Object)dimnum), new QFilter("id", "in", ids)});
            try (TXHandle tx = TX.required();){
                try {
                    for (DynamicObject mb : mbs) {
                        if (dimnum.equals(mb.getString("number"))) continue;
                        mb.set("storagetype", (Object)StorageTypeEnum.DYNAMIC.index);
                        OlapServiceHelper.alterMemberStorageType(cube, dimnum, mb.getString("number"), MemberStorageTypes.DynamicCalc);
                    }
                    SaveServiceHelper.update((DynamicObject[])mbs);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
        }
    }

    public static void unSetDynamicDim(long modelId, String cube, String dimnum) {
        String entity = DimEntityNumEnum.getEntieyNumByNumber((String)dimnum);
        DynamicObject dim = BusinessDataServiceHelper.loadSingle((String)"epm_dimension", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)dimnum)});
        DynamicObject[] mems = BusinessDataServiceHelper.load((String)entity, (String)"number,storagetype", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("dimension", "=", dim.get("id")), new QFilter("storagetype", "=", (Object)StorageTypeEnum.DYNAMIC.index)});
        if (mems != null && mems.length > 0) {
            try (TXHandle tx = TX.required();){
                try {
                    for (DynamicObject mb : mems) {
                        if (dimnum.equals(mb.getString("number"))) continue;
                        mb.set("storagetype", (Object)StorageTypeEnum.STORAGE.index);
                        OlapServiceHelper.alterMemberStorageType(cube, dimnum, mb.getString("number"), MemberStorageTypes.Stored);
                    }
                    SaveServiceHelper.update((DynamicObject[])mems);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
        }
    }

    private static List<Long> getCanChangeIds(Map<Long, MemberTreeNode> membersMap) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (MemberTreeNode m : membersMap.values()) {
            boolean canChange;
            boolean bl = canChange = m.getChildren() != null && !m.getChildren().isEmpty();
            if (canChange) {
                String st = m.getData().get("storagetype").toString();
                boolean bl2 = canChange = StorageTypeEnum.STORAGE.index.equals(st) || StorageTypeEnum.UNSHARE.index.equals(st);
            }
            if (canChange) {
                for (MemberTreeNode c : m.getChildren()) {
                    String agg = c.getData().get("aggoprt").toString();
                    if (AggOprtEnum.ADD.sign.equals(agg) || AggOprtEnum.SUBSTRACT.sign.equals(agg) || AggOprtEnum.SKIP.sign.equals(agg) || AggOprtEnum.NONE.sign.equals(agg)) continue;
                    canChange = false;
                    break;
                }
            }
            if (!canChange) continue;
            ids.add(m.getId());
        }
        return ids;
    }
}

