/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.olap.shield;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.enums.DimEntityNumEnum;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;

public class ShieldRuleBulider {
    private Object modelId;
    private String modelNumber;
    private Collection<DynamicObject> dimObjs;
    public static final String other = "other";
    public static final String all = "all";
    public static final String none = "none";
    public static final String NULL = "null";

    public ShieldRuleBulider(Object modelId) {
        this.modelId = modelId;
    }

    private String getModelNumber() {
        if (StringUtils.isEmpty((String)this.modelNumber)) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)this.modelId, (String)"epm_model", (String)"number");
            this.modelNumber = obj.getString("number");
        }
        return this.modelNumber;
    }

    private Collection<DynamicObject> getDimObjs() {
        if (this.dimObjs == null) {
            this.dimObjs = BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"id,name,shortnumber,number", (QFilter[])new QFilter[]{new QFilter("model", "=", this.modelId)}).values();
        }
        return this.dimObjs;
    }

    public long getShieldRule(Object dimensionId, String dims) {
        if (StringUtils.isEmpty((String)dims)) {
            return 0L;
        }
        Object[] ds = dims.split(",");
        Arrays.sort(ds);
        ArrayList<Object> dimensions = new ArrayList<Object>();
        for (Object object : ds) {
            if (!StringUtils.isNotEmpty((String)object)) continue;
            dimensions.add(object);
        }
        if (dimensions.isEmpty()) {
            return 0L;
        }
        ArrayList<String> others = new ArrayList<String>();
        String thisDim = "";
        for (DynamicObject dynamicObject : this.getDimObjs()) {
            if (!dimensionId.toString().equals(dynamicObject.getString("id"))) {
                others.add(dynamicObject.getString("shortnumber"));
                continue;
            }
            thisDim = dynamicObject.getString("shortnumber");
        }
        if (dimensions.containsAll(others) && !dimensions.contains(thisDim)) {
            return this.getRule(other, other, other);
        }
        String dimStr = String.join((CharSequence)",", dimensions);
        String string = String.join((CharSequence)"", dimensions);
        return this.getRule(string, string, dimStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRule(String number, String name, String rule) {
        DynamicObject obj;
        block32: {
            obj = QueryServiceHelper.queryOne((String)"eb_aggshieldrule", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", this.modelId), new QFilter("rule", "=", (Object)rule)});
            if (obj == null) {
                try (DLock lock = DLock.create((String)("SRU" + rule + this.modelId));){
                    try {
                        if (!lock.tryLock(1000L)) break block32;
                        obj = BusinessDataServiceHelper.newDynamicObject((String)"eb_aggshieldrule");
                        obj.set("number", (Object)number);
                        obj.set("name", (Object)name);
                        obj.set("model", this.modelId);
                        obj.set("rule", (Object)rule);
                        try (TXHandle tx = TX.required();){
                            try {
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                                if (!other.equals(number)) {
                                    this.addToOlap(number, rule);
                                }
                            }
                            catch (Throwable e) {
                                tx.markRollback();
                                throw new KDBizException(e.getMessage());
                            }
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
        }
        if (obj != null) {
            return obj.getLong("id");
        }
        return 0L;
    }

    private List<String> changeShortNumToNum(String rule) {
        ArrayList<String> nums = new ArrayList<String>();
        List<String> shortnums = Arrays.asList(rule.split(","));
        for (DynamicObject dim : this.getDimObjs()) {
            String sn = dim.getString("shortnumber");
            if (!shortnums.contains(sn)) continue;
            nums.add(dim.getString("number"));
        }
        return nums;
    }

    private void addToOlap(String number, String rule) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)this.modelId, (String)"epm_model", (String)"number");
        String cubeNum = obj.getString("number");
        List<String> dims = this.changeShortNumToNum(rule);
        OlapServiceHelper.createAggShieldRule(cubeNum, number, dims);
    }

    public List<ComboItem> getComboItem(Object dimensionId) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"id,name,shortnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", this.modelId)}, (String)"dseq").values().forEach(d -> {
            if (!dimensionId.toString().equals(d.getString("id"))) {
                items.add(new ComboItem(new LocaleString(d.getString("name")), d.getString("shortnumber")));
            }
        });
        return items;
    }

    public void save(long dimId, long membId, long ruleId) {
        DeleteServiceHelper.delete((String)"eb_aggshieldruledis", (QFilter[])new QFilter[]{new QFilter("member", "=", (Object)membId)});
        String dimNum = "";
        for (DynamicObject dim : this.getDimObjs()) {
            if (dimId != dim.getLong("id")) continue;
            dimNum = dim.getString("number");
            break;
        }
        DynamicObject member = BusinessDataServiceHelper.loadSingle((Object)membId, (String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), (String)"number");
        if (ruleId == 0L) {
            OlapServiceHelper.setMemberAggShieldRule(this.getModelNumber(), dimNum, member.getString("number"), all);
            return;
        }
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"eb_aggshieldrule", (String)"number");
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"eb_aggshieldruledis");
        obj.set("member", (Object)membId);
        obj.set("rule", (Object)ruleId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        OlapServiceHelper.setMemberAggShieldRule(this.getModelNumber(), dimNum, member.getString("number"), rule.getString("number"));
    }

    public static String getRuleStrByMem(Object dimensionId, Object membId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_aggshieldruledis", (String)"rule.rule,rule.model.id", (QFilter[])new QFilter[]{new QFilter("member", "=", membId)});
        if (obj != null) {
            String rule = obj.getString("rule.rule");
            if (other.equals(rule)) {
                StringBuilder sb = new StringBuilder();
                BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"id,name,shortnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", obj.get("rule.model.id"))}, (String)"dseq").values().forEach(d -> {
                    if (!dimensionId.toString().equals(d.getString("id"))) {
                        sb.append(d.getString("shortnumber"));
                        sb.append(',');
                    }
                });
                rule = sb.toString();
            } else {
                List<String> dims = Arrays.asList(rule.split(","));
                StringBuilder sb = new StringBuilder();
                BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"id,name,shortnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", obj.get("rule.model.id"))}, (String)"dseq").values().forEach(d -> {
                    String sn = d.getString("shortnumber");
                    if (dims.contains(sn)) {
                        sb.append(sn);
                        sb.append(',');
                    }
                });
                rule = sb.toString();
            }
            return rule;
        }
        return null;
    }
}

