/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.page.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.epm.eb.ebBusiness.page.model.Area;
import kd.epm.eb.ebBusiness.page.model.Element;
import kd.epm.eb.ebBusiness.page.model.PageBasicInfo;
import kd.epm.eb.ebBusiness.page.model.entry.DynamicEntry;

public class Page
extends PageBasicInfo {
    private static final long serialVersionUID = 1L;
    private List<Area> areaList = new ArrayList<Area>();
    private List<DynamicEntry> entryList = new ArrayList<DynamicEntry>();
    private boolean isChangeable;

    public List<Area> getAreaList() {
        return this.areaList;
    }

    public void addArea(Area area) {
        this.areaList.add(area);
    }

    public void addEntry(DynamicEntry entry) {
        this.entryList.add(entry);
    }

    public void setChangeable(boolean changeable) {
        this.isChangeable = changeable;
    }

    public boolean isChangeable() {
        return this.isChangeable;
    }

    public void bulidPage(IFormView view) {
    }

    @Override
    public void bindCtrlMapping(IFormView view) {
        MainEntityType mainEntityType = view.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        this.check(view);
        this.areaList.forEach(a -> a.bindCtrlMapping(view));
        this.entryList.forEach(a -> a.bindCtrlMapping(view));
    }

    @Override
    public void addToFront() {
        this.areaList.forEach(a -> a.addToFront());
        this.entryList.forEach(a -> a.addToFront());
    }

    public Control findControlBySign(IFormView view, String sign) {
        for (Area area : this.areaList) {
            for (Element ele : area.getElementListList()) {
                if (!ele.getSign().equals(sign)) continue;
                return ele.getControl(view);
            }
        }
        return null;
    }

    public Element findElementBySign(String sign) {
        for (Area area : this.areaList) {
            for (Element ele : area.getElementListList()) {
                if (!ele.getSign().equalsIgnoreCase(sign)) continue;
                return ele;
            }
        }
        for (DynamicEntry entry : this.entryList) {
            for (Element ele : entry.getElementListList()) {
                if (!ele.getSign().equalsIgnoreCase(sign)) continue;
                return ele;
            }
        }
        return null;
    }

    public Area findAreaBySign(String sign) {
        for (Area area : this.areaList) {
            if (!area.getSign().equals(sign)) continue;
            return area;
        }
        return null;
    }

    public DynamicEntry findEntryBySign(String sign) {
        for (DynamicEntry entry : this.entryList) {
            if (!entry.getSign().equals(sign)) continue;
            return entry;
        }
        return null;
    }

    public void updatePage(IFormView view) {
        this.bindCtrlMapping(view);
        this.addToFront();
        this.areaList.forEach(a -> view.updateControlMetadata(a.getSign(), a.getContainerap().createControl()));
        this.entryList.forEach(a -> {
            HashMap<String, String> mapEntry = new HashMap<String, String>();
            mapEntry.put("id", a.getSign());
            mapEntry.put("columns", (String)a.getEntryAp().createControl().get("columns"));
            IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            clientViewProxy.preInvokeControlMethod("entryentity", "createGridColumns", new Object[]{mapEntry});
            view.updateView(a.getSign());
        });
    }

    public PageBasicInfo seaechSign(String sign) {
        for (Area area : this.areaList) {
            if (area.getSign().equals(sign)) {
                return area;
            }
            for (Element ele : area.getElementListList()) {
                if (!ele.getSign().equals(sign)) continue;
                return ele;
            }
        }
        return null;
    }

    public void clearOldValue(AbstractFormPlugin plugin) {
        for (Area area : this.areaList) {
            for (Element ele : area.getElementListList()) {
                plugin.getView().getModel().getDataEntity().set(ele.getSign(), null);
                ele.setValue(plugin.getPageCache(), null);
                plugin.getPageCache().put(ele.getSign(), null);
            }
        }
    }

    @Override
    public void check(IFormView view) {
        super.check(view);
        if (this.entityMeta == null) {
            MainEntityType mainEntityType = view.getModel().getDataEntityType();
            FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            this.entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        }
        this.areaList.forEach(a -> a.getElementListList().forEach(e -> e.setEntityMeta(this.entityMeta)));
        this.entryList.forEach(a -> a.getElementListList().forEach(e -> e.setEntityMeta(this.entityMeta)));
    }
}

