/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.permission.cache;

import java.io.Serializable;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.ebBusiness.model.SimpleItem;
import kd.epm.eb.ebBusiness.permission.strategy.PermControlStrategy;

public class MembBaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long mId;
    private String mLongNumber;
    private RangeEnum range;
    private String number;
    private String entityNum;
    private boolean isCustom = false;
    private Object modelId;

    public MembBaseItem(String entityNum, Long mId, String mLongNumber, String mnumber, RangeEnum range, boolean isCustom, Object modelId) {
        this.mId = mId;
        this.mLongNumber = mLongNumber;
        this.range = range;
        this.number = mnumber;
        this.entityNum = entityNum;
        this.isCustom = isCustom;
        this.modelId = modelId;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public Long getmId() {
        return this.mId;
    }

    public String getmLongNumber() {
        return this.mLongNumber;
    }

    public void setLongNumber(String longNumber) {
        this.mLongNumber = longNumber;
    }

    public RangeEnum getRange() {
        return this.range;
    }

    public String getNumber() {
        if (StringUtils.isNotEmpty((CharSequence)this.number)) {
            return this.number;
        }
        this.number = MemberReader.findMemberById((long)Long.parseLong(this.modelId.toString()), (String)(this.isCustom ? "eb_definedpropertyvalue" : this.entityNum), (Long)this.mId).getNumber();
        return this.number;
    }

    public String getEntityNum() {
        return this.entityNum;
    }

    public Object getModelId() {
        return this.modelId;
    }

    public void setModelId(Object modelId) {
        this.modelId = modelId;
    }

    public boolean isMatched(Object cpId) {
        return PermControlStrategy.getStrategy(this.range).isMatchPermission(this, cpId);
    }

    public void matchItems(Consumer<SimpleItem> c) {
        PermControlStrategy.getStrategy(this.range).matchItems(this, c);
    }

    public QFilter buildFilterByScope() {
        return PermControlStrategy.getStrategy(this.range).buildFilterByScope(this);
    }

    public long getParentId() {
        String parent;
        DynamicObject dyna = QueryServiceHelper.queryOne((String)(this.isCustom ? "eb_definedpropertyvalue" : this.entityNum), (String)(parent = this.isCustom ? "parentid" : "parent"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.mId)});
        Object obj = dyna.get(parent);
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id");
        }
        return (Long)obj;
    }

    public String genKey(Object cpId) {
        return "" + this.modelId + this.mId + this.range + this.isCustom + cpId;
    }

    public String toString() {
        return String.format("mId:%s, mLongNumber:%s, range:%s, number:%s, entityNum:%s, isCustom:%s, modelId:%s", this.mId, this.mLongNumber, this.range, this.number, this.entityNum, this.isCustom, this.modelId);
    }
}

