/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.permission.strategy;

import java.util.List;
import java.util.function.Consumer;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.ebBusiness.model.SimpleItem;
import kd.epm.eb.ebBusiness.permission.cache.MembBaseItem;
import kd.epm.eb.ebBusiness.permission.strategy.IControl;
import kd.epm.eb.ebBusiness.permission.strategy.PermControlCacheHelper;
import kd.epm.eb.ebBusiness.serviceHelper.TreeStructureServiceHelper;

public class AllChildrenIncSelfControl
implements IControl {
    @Override
    public boolean isMatchPermission(MembBaseItem pitem, Object cpId) {
        return PermControlCacheHelper.isMatch(pitem, cpId, () -> {
            if (pitem.isCustom()) {
                return pitem.getmId().equals(cpId) || TreeStructureServiceHelper.isChildByCustom(pitem.getEntityNum(), cpId, pitem.getmId(), pitem.getModelId());
            }
            return pitem.getmId().equals(cpId) || TreeStructureServiceHelper.isChild(pitem.getEntityNum(), pitem.getmId(), cpId, pitem.getModelId());
        });
    }

    @Override
    public void matchItems(MembBaseItem pitem, Consumer<SimpleItem> c) {
        List<SimpleItem> s2 = PermControlCacheHelper.matchItems(pitem, () -> {
            if (pitem.isCustom()) {
                return TreeStructureServiceHelper.getChildByCustom(pitem.getEntityNum(), pitem.getmId(), pitem.getmLongNumber(), true);
            }
            List<SimpleItem> s = TreeStructureServiceHelper.getChild(pitem.getEntityNum(), pitem.getmId(), pitem.getModelId());
            s.add(SimpleItem.newOne(pitem.getmId(), pitem.getNumber()));
            return s;
        });
        for (SimpleItem s1 : s2) {
            c.accept(s1);
        }
    }

    @Override
    public QFilter buildFilterByScope(MembBaseItem pitem) {
        if (pitem.isCustom()) {
            return TreeStructureServiceHelper.getFilterByCustomScope(pitem.getRange(), pitem.getmId(), pitem.getModelId());
        }
        return new QFilter("longnumber", "like", (Object)(pitem.getmLongNumber() + "!%")).or("id", "=", (Object)pitem.getmId());
    }
}

