/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.permission.strategy;

import java.util.List;
import java.util.function.Consumer;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.ebBusiness.model.SimpleItem;
import kd.epm.eb.ebBusiness.permission.cache.MembBaseItem;
import kd.epm.eb.ebBusiness.permission.strategy.IControl;
import kd.epm.eb.ebBusiness.permission.strategy.PermControlCacheHelper;
import kd.epm.eb.ebBusiness.serviceHelper.TreeStructureServiceHelper;

public class DirectChildrenIncSelfControl
implements IControl {
    @Override
    public boolean isMatchPermission(MembBaseItem pitem, Object cpId) {
        return PermControlCacheHelper.isMatch(pitem, cpId, () -> {
            if (pitem.isCustom()) {
                return cpId.equals(pitem.getmId()) || TreeStructureServiceHelper.isDirectChildByCustom(pitem.getEntityNum(), cpId, pitem.getmId());
            }
            return cpId.equals(pitem.getmId()) || TreeStructureServiceHelper.isDirectChild(pitem.getEntityNum(), pitem.getmId(), cpId, pitem.getModelId());
        });
    }

    @Override
    public void matchItems(MembBaseItem pitem, Consumer<SimpleItem> c) {
        List<SimpleItem> s = PermControlCacheHelper.matchItems(pitem, () -> {
            if (pitem.isCustom()) {
                return TreeStructureServiceHelper.getDirectChildByCustom(pitem.getEntityNum(), pitem.getmId(), true);
            }
            List<SimpleItem> s2 = TreeStructureServiceHelper.getDirectChild(pitem.getEntityNum(), (Object)pitem.getmId(), pitem.getModelId());
            s2.add(SimpleItem.newOne(pitem.getmId(), pitem.getNumber()));
            return s2;
        });
        for (SimpleItem s1 : s) {
            c.accept(s1);
        }
    }

    @Override
    public QFilter buildFilterByScope(MembBaseItem pitem) {
        if (pitem.isCustom()) {
            return TreeStructureServiceHelper.getFilterByCustomScope(pitem.getRange(), pitem.getmId(), pitem.getModelId());
        }
        return new QFilter("id", "=", (Object)pitem.getmId()).or("parent", "=", (Object)pitem.getmId());
    }
}

