/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.permission.strategy;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.ebBusiness.model.SimpleItem;
import kd.epm.eb.ebBusiness.permission.cache.MembBaseItem;
import kd.epm.eb.ebBusiness.permission.strategy.IControl;
import kd.epm.eb.ebBusiness.permission.strategy.PermControlCacheHelper;
import kd.epm.eb.ebBusiness.serviceHelper.TreeStructureServiceHelper;

public class OnlySelfControl
implements IControl {
    @Override
    public boolean isMatchPermission(MembBaseItem pitem, Object cpId) {
        return PermControlCacheHelper.isMatch(pitem, cpId, () -> {
            if (pitem.isCustom()) {
                return TreeStructureServiceHelper.isSelfByCustom(pitem.getEntityNum(), cpId, pitem.getmId());
            }
            return pitem.getmId().equals(cpId);
        });
    }

    @Override
    public void matchItems(MembBaseItem pitem, Consumer<SimpleItem> c) {
        List<SimpleItem> s = PermControlCacheHelper.matchItems(pitem, () -> {
            if (pitem.isCustom()) {
                return TreeStructureServiceHelper.getSelfByCustom(pitem.getEntityNum(), pitem.getmId());
            }
            return Lists.newArrayList((Object[])new SimpleItem[]{SimpleItem.newOne(pitem.getmId(), pitem.getNumber())});
        });
        if (s == null) {
            return;
        }
        for (SimpleItem s1 : s) {
            c.accept(s1);
        }
    }

    @Override
    public QFilter buildFilterByScope(MembBaseItem pitem) {
        if (pitem.isCustom()) {
            return TreeStructureServiceHelper.getFilterByCustomScope(pitem.getRange(), pitem.getmId(), pitem.getModelId());
        }
        return new QFilter("id", "=", (Object)pitem.getmId());
    }
}

