/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.permission.strategy;

import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.ebBusiness.permission.strategy.AllChildrenExcludSelfControl;
import kd.epm.eb.ebBusiness.permission.strategy.AllChildrenIncSelfControl;
import kd.epm.eb.ebBusiness.permission.strategy.AllChildrenOnlyDetailControl;
import kd.epm.eb.ebBusiness.permission.strategy.AllChildrenOnlyNonDetailControl;
import kd.epm.eb.ebBusiness.permission.strategy.BrotherExcludeSelfControl;
import kd.epm.eb.ebBusiness.permission.strategy.BrotherIncSelfControl;
import kd.epm.eb.ebBusiness.permission.strategy.DirectChildrenExcludSelfControl;
import kd.epm.eb.ebBusiness.permission.strategy.DirectChildrenIncSelfControl;
import kd.epm.eb.ebBusiness.permission.strategy.IControl;
import kd.epm.eb.ebBusiness.permission.strategy.OnlySelfControl;

public class PermControlStrategy {
    private static final IControl self = new OnlySelfControl();
    private static final IControl dirChildIncSelf = new DirectChildrenIncSelfControl();
    private static final IControl dirChildExcSelf = new DirectChildrenExcludSelfControl();
    private static final IControl allChildIncSelf = new AllChildrenIncSelfControl();
    private static final IControl allChildExcSelf = new AllChildrenExcludSelfControl();
    private static final IControl brotherIncSelf = new BrotherIncSelfControl();
    private static final IControl brotherExcSelf = new BrotherExcludeSelfControl();
    private static final IControl allDetailChild = new AllChildrenOnlyDetailControl();
    private static final IControl allNonDetailChild = new AllChildrenOnlyNonDetailControl();

    public static IControl getStrategy(RangeEnum range) {
        switch (range) {
            case VALUE_10: {
                return Strategy.Only_Self.supply();
            }
            case VALUE_20: {
                return Strategy.Direct_Chidren_Exclude_self.supply();
            }
            case VALUE_30: {
                return Strategy.Direct_Chidren_Iclude_Self.supply();
            }
            case VALUE_40: {
                return Strategy.ALL_Chidren_Exclude_Self.supply();
            }
            case VALUE_50: {
                return Strategy.ALL_Chidren_Iclude_Self.supply();
            }
            case VALUE_60: {
                return Strategy.Brother_Exclude_Self.supply();
            }
            case VALUE_70: {
                return Strategy.Brother_Include_Self.supply();
            }
            case VALUE_90: {
                return Strategy.All_Detail_Children.supply();
            }
            case VALUE_110: {
                return Strategy.All_NonDetail_Children.supply();
            }
        }
        throw new RuntimeException("not support perm Range:" + range.getName());
    }

    static enum Strategy {
        Only_Self{

            @Override
            IControl supply() {
                return self;
            }
        }
        ,
        Direct_Chidren_Iclude_Self{

            @Override
            IControl supply() {
                return dirChildIncSelf;
            }
        }
        ,
        Direct_Chidren_Exclude_self{

            @Override
            IControl supply() {
                return dirChildExcSelf;
            }
        }
        ,
        ALL_Chidren_Iclude_Self{

            @Override
            IControl supply() {
                return allChildIncSelf;
            }
        }
        ,
        ALL_Chidren_Exclude_Self{

            @Override
            IControl supply() {
                return allChildExcSelf;
            }
        }
        ,
        Brother_Include_Self{

            @Override
            IControl supply() {
                return brotherIncSelf;
            }
        }
        ,
        Brother_Exclude_Self{

            @Override
            IControl supply() {
                return brotherExcSelf;
            }
        }
        ,
        All_Detail_Children{

            @Override
            IControl supply() {
                return allDetailChild;
            }
        }
        ,
        All_NonDetail_Children{

            @Override
            IControl supply() {
                return allNonDetailChild;
            }
        };


        abstract IControl supply();
    }
}

