/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.qing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.ebcommon.common.cache.IDNumberTreeNode;
import kd.epm.eb.ebBusiness.qing.model.EAndBPNode;
import kd.epm.eb.ebBusiness.serviceHelper.TreeStructureServiceHelper;

public class EAndBPTreeBulider {
    private Map<Long, IDNumberTreeNode> orgMap;
    private Map<String, Long> bpidmap;
    private List<DynamicObject> orgs;
    private List<DynamicObject> bps;
    private Map<String, EAndBPNode> result;
    private boolean isNeedDyObj;

    public EAndBPTreeBulider(List<DynamicObject> orgs, List<DynamicObject> bps, long modelId) {
        this.orgs = orgs;
        this.bps = bps;
        this.orgMap = TreeStructureServiceHelper.getAllNode("epm_entitymembertree", modelId);
        this.bpidmap = new HashMap<String, Long>();
        bps.forEach(b -> this.bpidmap.put(b.getString("number"), b.getLong("id")));
        this.result = new HashMap<String, EAndBPNode>();
    }

    public void setNeedDyObj(boolean needDyObj) {
        this.isNeedDyObj = needDyObj;
    }

    public List<EAndBPNode> getTree() {
        this.build();
        if (this.isNeedDyObj) {
            HashMap bpDys = new HashMap();
            HashMap orgDys = new HashMap();
            this.bps.forEach(b -> bpDys.put(b.getLong("id"), b));
            this.orgs.forEach(o -> orgDys.put(o.getLong("id"), o));
            this.result.values().forEach(r -> {
                r.setBp((DynamicObject)bpDys.get(r.getBpId()));
                r.setOrg((DynamicObject)orgDys.get(r.getOrgId()));
            });
        }
        ArrayList<EAndBPNode> list = new ArrayList<EAndBPNode>();
        this.result.values().forEach(r -> {
            if (r.getParent() == null) {
                list.add((EAndBPNode)r);
            }
        });
        return list;
    }

    private void build() {
        this.orgs.forEach(o -> {
            long oid = o.getLong("id");
            IDNumberTreeNode node = this.orgMap.get(oid);
            if (!node.isLeaf()) {
                this.buildCS(node);
            }
        });
        this.orgs.forEach(o -> {
            long oid = o.getLong("id");
            IDNumberTreeNode node = this.orgMap.get(oid);
            if (node.isLeaf()) {
                this.buildNormal(node, "IRpt");
            }
        });
    }

    private EAndBPNode buildNormal(IDNumberTreeNode node, String bpNumer) {
        if (this.bpidmap.get(bpNumer) != null) {
            EAndBPNode n = new EAndBPNode(node.getId(), this.bpidmap.get(bpNumer), node.getNumber(), bpNumer);
            n = this.checkNode(n);
            return n;
        }
        return null;
    }

    private EAndBPNode buildCS(IDNumberTreeNode node) {
        if (this.bpidmap.get("CS") != null) {
            EAndBPNode n = new EAndBPNode(node.getId(), this.bpidmap.get("CS"), node.getNumber(), "CS");
            n = this.checkNode(n);
            n.addChild(this.buildNormal(node, "CSTE"));
            n.addChild(this.buildSIRpt(node));
            n.addChild(this.buildADJT(node));
            n.addChild(this.buildEJET(node));
            return n;
        }
        return null;
    }

    private EAndBPNode buildEJET(IDNumberTreeNode node) {
        if (this.bpidmap.get("EJET") != null) {
            EAndBPNode n = new EAndBPNode(node.getId(), this.bpidmap.get("EJET"), node.getNumber(), "EJET");
            n = this.checkNode(n);
            n.addChild(this.buildSEJE(node));
            n.addChild(this.buildNormal(node, "DEJE"));
            return n;
        }
        return null;
    }

    private EAndBPNode buildSEJE(IDNumberTreeNode node) {
        if (this.bpidmap.get("SEJE") != null) {
            EAndBPNode n = new EAndBPNode(node.getId(), this.bpidmap.get("SEJE"), node.getNumber(), "SEJE");
            n = this.checkNode(n);
            n.addChild(this.buildSEIC(node));
            n.addChild(this.buildNormal(node, "SEIT"));
            n.addChild(this.buildNormal(node, "SEOE"));
            n.addChild(this.buildNormal(node, "SECF"));
            n.addChild(this.buildSEOther(node));
            return n;
        }
        return null;
    }

    private EAndBPNode buildSEOther(IDNumberTreeNode node) {
        if (this.bpidmap.get("SEOther") != null) {
            EAndBPNode n = new EAndBPNode(node.getId(), this.bpidmap.get("SEOther"), node.getNumber(), "SEOther");
            n = this.checkNode(n);
            for (IDNumberTreeNode c : node.getChildren()) {
                n.addChild(this.buildNormal(c, "EOther"));
            }
            return n;
        }
        return null;
    }

    private EAndBPNode buildSEIC(IDNumberTreeNode node) {
        if (this.bpidmap.get("SEIC") != null) {
            EAndBPNode n = new EAndBPNode(node.getId(), this.bpidmap.get("SEIC"), node.getNumber(), "SEIC");
            n = this.checkNode(n);
            for (IDNumberTreeNode c : node.getChildren()) {
                n.addChild(this.buildNormal(c, "EICA"));
            }
            return n;
        }
        return null;
    }

    private EAndBPNode buildADJT(IDNumberTreeNode node) {
        if (this.bpidmap.get("ADJT") != null) {
            EAndBPNode n = new EAndBPNode(node.getId(), this.bpidmap.get("ADJT"), node.getNumber(), "ADJT");
            n = this.checkNode(n);
            n.addChild(this.buildSADJ(node));
            n.addChild(this.buildNormal(node, "DADJ"));
            return n;
        }
        return null;
    }

    private EAndBPNode buildSADJ(IDNumberTreeNode node) {
        if (this.bpidmap.get("SADJ") != null) {
            EAndBPNode n = new EAndBPNode(node.getId(), this.bpidmap.get("SADJ"), node.getNumber(), "SADJ");
            n = this.checkNode(n);
            for (IDNumberTreeNode c : node.getChildren()) {
                n.addChild(this.buildNormal(c, "ADJ"));
            }
            return n;
        }
        return null;
    }

    private EAndBPNode buildSIRpt(IDNumberTreeNode node) {
        if (this.bpidmap.get("SIRpt") != null) {
            EAndBPNode n = new EAndBPNode(node.getId(), this.bpidmap.get("SIRpt"), node.getNumber(), "SIRpt");
            n = this.checkNode(n);
            for (IDNumberTreeNode c : node.getChildren()) {
                EAndBPNode cn = c.isLeaf() ? this.buildNormal(c, "IRpt") : this.buildCS(c);
                n.addChild(cn);
            }
            return n;
        }
        return null;
    }

    private EAndBPNode checkNode(EAndBPNode n) {
        String key = n.getKey();
        if (this.result.get(key) != null) {
            n = this.result.get(key);
        } else {
            this.result.put(key, n);
        }
        return n;
    }

    public static void main(String[] args) {
        Map org = BusinessDataServiceHelper.loadFromCache((String)"epm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)874565316880041984L).and("isexchangerate", "=", (Object)0)});
        Map bp = BusinessDataServiceHelper.loadFromCache((String)"epm_processmembertree", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)874565316880041984L)});
        EAndBPTreeBulider b = new EAndBPTreeBulider(Arrays.asList(org.values().toArray(new DynamicObject[0])), Arrays.asList(bp.values().toArray(new DynamicObject[0])), 874565316880041984L);
        b.getTree();
    }
}

