/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.reportlist.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.eb.common.cache.GlobalCacheServiceHelper;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.ebBusiness.serviceHelper.AppCacheServiceHelper;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.util.TemplateRangeService;

public class ReportRedisCache {
    public static List<TemplateModel> queryTemplateModelFromCache(Set<? extends Object> selecttemplateidList, boolean isOnlyWeaveTmpl) {
        Map queryTemplateMap = (Map)GlobalCacheServiceHelper.getCommonCache().getOrLoad("queryTemplateList", () -> {
            HashMap<Long, TemplateModel> queryTemplateCache = new HashMap<Long, TemplateModel>();
            ReportRedisCache.queryTemplateModel(selecttemplateidList, isOnlyWeaveTmpl, queryTemplateCache);
            return queryTemplateCache;
        });
        HashSet<? extends Object> copy = new HashSet<Object>(selecttemplateidList);
        copy.removeIf(p -> queryTemplateMap.containsKey(Long.valueOf(p.toString())));
        if (!copy.isEmpty()) {
            ReportRedisCache.queryTemplateModel(selecttemplateidList, isOnlyWeaveTmpl, queryTemplateMap);
            GlobalCacheServiceHelper.getCommonCache().replaceCache("queryTemplateList", (Object)queryTemplateMap);
        }
        return queryTemplateMap.values().stream().filter(p -> selecttemplateidList.contains(p.getId())).collect(Collectors.toList());
    }

    private static void queryTemplateModel(Set<? extends Object> selecttemplateidList, boolean isOnlyWeaveTmpl, Map<Long, TemplateModel> queryTemplateCache) {
        ArrayList<Object> models = new ArrayList<Object>();
        ArrayList<Object> notexist = new ArrayList<Object>();
        for (Object object : selecttemplateidList) {
            String templateSerial = AppCacheServiceHelper.get(ReportRedisCache.getAppCacheKey(object), String.class);
            if (StringUtils.isEmpty((CharSequence)templateSerial)) {
                notexist.add(object);
                continue;
            }
            TemplateModel t = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)templateSerial);
            if (isOnlyWeaveTmpl && "2".equals(t.getUsage())) continue;
            models.add(ObjectSerialUtil.deSerializedBytes((String)templateSerial));
        }
        List<TemplateModel> templates = TemplateRangeService.getTemplateModels(notexist, false, isOnlyWeaveTmpl);
        for (TemplateModel tml : templates) {
            AppCacheServiceHelper.put(ReportRedisCache.getAppCacheKey(tml.getId()), ObjectSerialUtil.toByteSerialized((Object)tml));
        }
        models.addAll(templates);
        models.forEach(m -> queryTemplateCache.put(m.getId(), (TemplateModel)m));
    }

    public static void removeTemplateModelFromCache(Object templateid) {
        AppCacheServiceHelper.remove(ReportRedisCache.getAppCacheKey(templateid));
    }

    public static String getAppCacheKey(Object templateid) {
        return String.valueOf(templateid) + "reportlistplugin";
    }
}

