/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.scale;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.common.MembersKey;
import kd.bos.olap.dataSources.FixedDimension;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.ebcommon.common.enums.CurrencyScaleEnum;
import kd.epm.eb.common.ebcommon.common.enums.FacTabFieldDefEnum;
import kotlin.Pair;

public class CurrencyScaleHandler {
    public static final int DEF_CURRENCY_SCALE = 2;

    public static void handle(DynamicObject currencyTree, String currencyNumber) {
    }

    private static List<String> getAllTcfChildMember(String cubeCatalog) {
        QFilter tcfFilter = new QFilter("longnumber", "like", (Object)"Process!TCF%");
        QFilter modelFilter = new QFilter("model.number", "=", (Object)cubeCatalog);
        Map dimObj = BusinessDataServiceHelper.loadFromCache((String)"epm_processmembertree", (String)"number", (QFilter[])new QFilter[]{tcfFilter, modelFilter});
        return Lists.transform(new ArrayList(dimObj.values()), dyna -> dyna.getString("number"));
    }

    public static void handle(SaveCommandInfo info, CellSet cellSets, String cubeCatalog) {
        String fMoney = FacTabFieldDefEnum.FIELD_MONEY.getField();
        for (String measure : info.getMeasures()) {
            if (!measure.equals(fMoney)) {
                return;
            }
            Iterator it = cellSets.getMetricEntries(fMoney);
            Pair<Integer, String> processPair = CurrencyScaleHandler.getMemberInfoPair("Process", info);
            int processIndex = (Integer)processPair.getFirst();
            List<String> tcfNumbers = CurrencyScaleHandler.getAllTcfChildMember(cubeCatalog);
            HashMap<String, Integer> scaleCache = new HashMap<String, Integer>();
            while (it.hasNext()) {
                Pair entry = (Pair)it.next();
                MembersKey key = (MembersKey)entry.getFirst();
                Object value = entry.getSecond();
                if (!(value instanceof Number)) continue;
                String processMember = null;
                processMember = processIndex == -1 ? (String)processPair.getSecond() : key.getKey(processIndex);
                if (tcfNumbers.contains(processMember)) continue;
                String currencyMember = CurrencyScaleHandler.getMemberNumberByKey("Currency", key, info);
                String scenarioMember = CurrencyScaleHandler.getMemberNumberByKey("Scenario", key, info);
                CurrencyScaleHandler.handleCurrency(cubeCatalog, cellSets, fMoney, (Pair<String, String>)new Pair((Object)scenarioMember, (Object)currencyMember), (Pair<MembersKey, Object>)entry, scaleCache);
            }
        }
    }

    public static void handleToOlapScale(SaveCommandInfo info, CellSet cellSets) {
        String fMoney = FacTabFieldDefEnum.FIELD_MONEY.getField();
        for (String measure : info.getMeasures()) {
            if (!measure.equals(fMoney)) {
                return;
            }
            Iterator it = cellSets.getMetricEntries(fMoney);
            while (it.hasNext()) {
                BigDecimal bigDecimal;
                Pair entry = (Pair)it.next();
                MembersKey key = (MembersKey)entry.getFirst();
                Object value = entry.getSecond();
                if (!(value instanceof BigDecimal) || (bigDecimal = (BigDecimal)value).scale() <= 15) continue;
                value = bigDecimal.setScale(15, 4);
                cellSets.set(CurrencyScaleHandler.getCoordinates(key), fMoney, value);
            }
        }
    }

    private static String getMemberNumberByKey(String dimKey, MembersKey key, SaveCommandInfo info) {
        Pair<Integer, String> pair = CurrencyScaleHandler.getMemberInfoPair(dimKey, info);
        int index = (Integer)pair.getFirst();
        String member = null;
        member = index == -1 ? (String)pair.getSecond() : key.getKey(index);
        return member;
    }

    public static void handleCurrency(String cubecatalog, CellSet cellSets, String fMoney, Pair<String, String> pair, Pair<MembersKey, Object> entry, Map<String, Integer> scaleCache) {
        String combinaKey = (String)pair.getFirst() + (String)pair.getSecond();
        Integer scale = scaleCache.get(combinaKey);
        if (scale == null) {
            scale = CurrencyScaleHandler.getCurrencyScale(pair, cubecatalog);
            scaleCache.put(combinaKey, scale);
        }
        MembersKey key = (MembersKey)entry.getFirst();
        Object value = entry.getSecond();
        BigDecimal result = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
        result = CurrencyScaleHandler.handleByScaleEnum(result, scale);
        cellSets.set(CurrencyScaleHandler.getCoordinates(key), fMoney, (Object)result);
    }

    public static BigDecimal handleByScaleEnum(BigDecimal value, Integer scale) {
        CurrencyScaleEnum scaleEnum = CurrencyScaleEnum.value((String)scale.toString());
        int unit = Math.abs(Integer.parseInt(scaleEnum.value));
        switch (scaleEnum) {
            case TENTHOUSAND: 
            case THOUSAND: 
            case HUNDRED: 
            case TEN: 
            case ONE: {
                BigDecimal tenNum = BigDecimal.TEN.pow(unit);
                value = value.divide(tenNum, 0, RoundingMode.HALF_UP);
                value = value.multiply(tenNum);
                break;
            }
            case ONESCALE: 
            case TWOSCALE: 
            case THIRDSCALE: 
            case FOURSCALE: 
            case FIVESCALE: 
            case SIXSCALE: {
                value = value.setScale((int)scale, RoundingMode.HALF_UP);
                break;
            }
        }
        return value;
    }

    private static String[] getCoordinates(MembersKey key) {
        int count = key.getCount();
        String[] coordinates = new String[count];
        for (int i = 0; i < count; ++i) {
            coordinates[i] = key.getKey(i);
        }
        return coordinates;
    }

    private static Integer getCurrencyScale(Pair<String, String> pair, String cubeNumber) {
        String currency;
        QFilter currencyFilter;
        String selectFields = "scaleentry.scale as scale";
        QFilter modelFilter = new QFilter("model.number", "=", (Object)cubeNumber);
        String scenario = (String)pair.getFirst();
        QFilter scenarioFilter = new QFilter("number", "=", (Object)scenario);
        QFilter[] filters = new QFilter[]{modelFilter, scenarioFilter, currencyFilter = new QFilter("scaleentry.currency.number", "=", (Object)(currency = (String)pair.getSecond()))};
        DynamicObject dimObj = QueryServiceHelper.queryOne((String)"epm_scenemembertree", (String)selectFields, (QFilter[])filters);
        if (dimObj == null || dimObj.get("scale") == null) {
            return 2;
        }
        return dimObj.getInt("scale");
    }

    private static Pair<Integer, String> getMemberInfoPair(String dimension, SaveCommandInfo info) {
        Object dim;
        int i;
        List fixedDimensions = info.getFixedDimensions();
        List dimensions = info.getDimensions();
        for (i = 0; i < fixedDimensions.size(); ++i) {
            dim = (FixedDimension)fixedDimensions.get(i);
            if (!dim.getName().equals(dimension)) continue;
            return new Pair((Object)-1, (Object)dim.getValue());
        }
        for (i = 0; i < dimensions.size(); ++i) {
            dim = (String)dimensions.get(i);
            if (!((String)dim).equals(dimension)) continue;
            return new Pair((Object)i, (Object)"");
        }
        throw new KDBizException(ResManager.loadResFormat((String)"\u4fdd\u5b58\u6570\u636e\u5931\u8d25\uff0c\u5904\u7406\u7cbe\u5ea6\u65f6\u672a\u83b7\u53d6\u5230\u76f8\u5173\u7ef4\u5ea6\u6210\u5458\uff1a%1", (String)"CurrencyScaleHandler_0", (String)"epm-eb-spread", (Object[])new Object[]{dimension}));
    }
}

