/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.scheme;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;

public class Dimension
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String number;
    private String id;
    private String fieldmapped;
    private String entity;
    private boolean issys;

    @JsonCreator
    public Dimension(@JsonProperty(value="name") String name, @JsonProperty(value="number") String number, @JsonProperty(value="id") String uqCode, @JsonProperty(value="realfieldKey") String fieldmapped) {
        this.name = name;
        this.number = number;
        this.id = uqCode;
        this.fieldmapped = fieldmapped;
        this.entity = DimensionServiceHelper.getDimMembEntityNumByDimNum(number);
        this.issys = !"epm_userdefinedmembertree".equalsIgnoreCase(this.entity);
    }

    public Dimension(DynamicObject dimension) {
        this.name = dimension.getString("name");
        this.number = dimension.getString("number");
        this.id = dimension.getString("id");
        this.fieldmapped = dimension.getString("fieldmapped");
        this.entity = DimensionServiceHelper.getDimMembEntityNumByDimNum(this.number);
        this.issys = !"epm_userdefinedmembertree".equalsIgnoreCase(this.entity);
    }

    public String getEntity() {
        return this.entity;
    }

    public boolean isIssys() {
        return this.issys;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Dimension) {
            Dimension dimension1 = (Dimension)o;
            return this.getNumber().equalsIgnoreCase(dimension1.getNumber());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getNumber() {
        return this.number;
    }

    public String getId() {
        return this.id;
    }

    public String getFieldmapped() {
        return StringUtils.isBlank((CharSequence)this.fieldmapped) ? this.number.toLowerCase() : this.fieldmapped;
    }

    public String toString() {
        return "name:" + this.name + " number:" + this.number;
    }
}

