/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.script;

import java.util.HashMap;
import java.util.Map;
import kd.bos.olap.dataSources.OlapConnection;
import kd.epm.eb.common.ebComputing.datasource.IOutline;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.PairList;
import kd.epm.eb.ebBusiness.script.ScopeBuilder;

public class AggScriptBuilder {
    private String scopeParamDifName;
    private ScopeBuilder scopesBuilder;
    private PairList<String, String> aggDims;
    private boolean needUpdateDataStatus = true;

    public AggScriptBuilder(String scopeParamDifName, PairList<String, String> aggDims) {
        this.scopeParamDifName = scopeParamDifName;
        this.aggDims = aggDims;
        this.scopesBuilder = new ScopeBuilder();
    }

    public void addDimensionScope(String dimNum, String ... scope) {
        this.scopesBuilder.addDimensionScope(dimNum, scope);
    }

    public String getBuildScript(Map<String, Object> params, OlapConnection conn, IOutline ot) {
        String script = this.genAggScript().replaceAll("agg\\(", "agg\\(" + this.scopeParamDifName + ",");
        return script;
    }

    private String genAggScript() {
        StringBuilder s = new StringBuilder();
        s.append("agg(");
        boolean hasMoreOne = false;
        for (Pair dim : this.aggDims) {
            if (hasMoreOne) {
                s.append(',');
            }
            s.append(String.format("\"%s%s%s\"", dim.p1, "@", dim.p2));
            hasMoreOne = true;
        }
        s.append(')');
        return s.toString();
    }

    public void buildScope2ScriptParam(Map<String, Object> params, OlapConnection conn, IOutline ot) {
        params.put(this.scopeParamDifName, this.scopesBuilder.genScopeInfo());
    }

    public Map<String, String[]> getScopeAndDimNum() {
        HashMap<String, String[]> dimNumToscope = new HashMap<String, String[]>(this.scopesBuilder.getScopes().size());
        for (ScopeBuilder.DimensionScopeInfo scope : this.scopesBuilder.getScopes()) {
            dimNumToscope.put(scope.getDimNum(), scope.getScope());
        }
        return dimNumToscope;
    }

    public boolean isNeedUpdateDataStatus() {
        return this.needUpdateDataStatus;
    }

    public void setNeedUpdateDataStatus(boolean needUpdateDataStatus) {
        this.needUpdateDataStatus = needUpdateDataStatus;
    }
}

