/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.script.run;

import java.util.HashMap;
import kd.epm.eb.common.ebcommon.common.PairList;
import kd.epm.eb.common.utils.ToStringHelper;
import kd.epm.eb.ebBusiness.script.ScopeBuilder;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;

public class RunScriptBuilder {
    private String cubecatalog;
    private ScopeBuilder scopeBuilder;
    private StringBuilder runScript = new StringBuilder();
    private StringBuilder runScriptFact = new StringBuilder();
    private static final String key_scope = "run_scope";

    public RunScriptBuilder(String cubecatalog) {
        this.cubecatalog = cubecatalog;
        this.scopeBuilder = new ScopeBuilder();
    }

    public void addDimensionScope(String dimNum, String ... scope) {
        this.scopeBuilder.addDimensionScope(dimNum, scope);
    }

    public void runScript() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(key_scope, this.scopeBuilder.genScopeInfo());
        OlapServiceHelper.excuteScript(this.cubecatalog, this.runScriptFact.toString(), params);
    }

    private String buildRunScript() {
        return "run(run_scope,\"" + this.runScript.toString() + "\");";
    }

    public void appendV(PairList<String, String> pairs) {
        this.runScript.append(this.parseV(pairs));
    }

    public void appendEqualSign() {
        this.runScript.append('=');
    }

    public void appendStr(String data) {
        this.runScript.append(data);
    }

    public void appendLeftBracket() {
        this.runScript.append('(');
    }

    public void endRunExpress() {
        this.runScriptFact.append(this.buildRunScript());
        this.runScript.setLength(0);
    }

    public void appendRightBracket() {
        this.runScript.append(')');
    }

    public void addV(PairList<String, String> pairs) {
        this.runScript.append('+').append(this.parseV(pairs));
    }

    public void subtractV(PairList<String, String> pairs) {
        this.runScript.append('-').append(this.parseV(pairs));
    }

    public void multiplyV(PairList<String, String> pairs) {
        this.runScript.append('*').append(this.parseV(pairs));
    }

    public void divideV(PairList<String, String> pairs) {
        this.runScript.append('/').append(this.parseV(pairs));
    }

    public String parseV(PairList<String, String> pairs) {
        StringBuilder sb = new StringBuilder();
        sb.append("v('");
        pairs.forEach(p -> sb.append(String.format("%s%s%s,", p.p1, "@", p.p2)));
        sb.deleteCharAt(sb.length() - 1);
        sb.append("')");
        return sb.toString();
    }

    public String toString() {
        return ToStringHelper.deepToString((Object)this);
    }
}

