/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.serviceHelper;

import kd.bos.cache.ThreadCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.epm.eb.ebBusiness.mq.MQMessagePublisherServiceHelper;

public class AppCacheServiceHelper {
    public static final String APP_EB = "_eb.";

    private static IAppCache getAppCache() {
        return AppCache.get((String)APP_EB);
    }

    public static void put(String key, Object value) {
        AppCacheServiceHelper.getAppCache().put(key, value);
    }

    public static void put(String key, Object value, int timeout) {
        AppCacheServiceHelper.getAppCache().put(key, value, timeout);
    }

    public static String getString(String key) {
        return (String)AppCacheServiceHelper.getAppCache().get(key, String.class);
    }

    public static Object get(String key) {
        return AppCacheServiceHelper.getAppCache().get(key, Object.class);
    }

    public static <T> T get(String key, Class<T> clazz) {
        return (T)AppCacheServiceHelper.getAppCache().get(key, clazz);
    }

    public static void remove(String key) {
        AppCacheServiceHelper.getAppCache().remove(key);
    }

    public static void clear() {
        AppCacheServiceHelper.getAppCache().clear();
    }

    public static void removeTemplateDispenseCache(String modelNum) {
        boolean isTrue = true;
        if (ThreadCache.exists((Object)("haveDeleteTmplDispenseCache" + modelNum))) {
            return;
        }
        AppCacheServiceHelper.getAppCache().remove("tmpl_map_org_4dispense" + modelNum);
        AppCacheServiceHelper.getAppCache().remove("tmpl_map_org_4dispense_part_" + modelNum);
        MQMessagePublisherServiceHelper.publishInvalidateTemplateDispense(modelNum);
        ThreadCache.put((Object)("haveDeleteTmplDispenseCache" + modelNum), (Object)isTrue);
    }

    public static String getTemplateDispenseCache(String modelNum) {
        return AppCacheServiceHelper.get("tmpl_map_org_4dispense" + modelNum, String.class);
    }

    public static void cacheTemplateDispenseCache(String modelNum, String cacheItem) {
        AppCacheServiceHelper.put("tmpl_map_org_4dispense" + modelNum, cacheItem);
    }

    public static String getTemplateDispenseCacheByPart(String modelNum) {
        return AppCacheServiceHelper.get("tmpl_map_org_4dispense_part_" + modelNum, String.class);
    }

    public static void cacheTemplateDispenseCacheByPart(String modelNum, String cacheItem) {
        AppCacheServiceHelper.put("tmpl_map_org_4dispense_part_" + modelNum, cacheItem);
    }

    public static final class CacheKeyConstant {
        public static final String KEY_TMPL_DISPENSE_MAP_ORG = "tmpl_map_org_4dispense";
        public static final String KEY_TMPL_DISPENSE_MAP_ORG_PART = "tmpl_map_org_4dispense_part_";
        public static final String KEY_TMPL_DISPENSE_LACAL_CACH = "template_dis_cache_";
    }
}

