/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.serviceHelper;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.UserUtils;

public class BcmFunPermissionHelper {
    private static ThreadLocal<Map<String, Set<Long>>> modelRoleLocal = ThreadLocal.withInitial(HashMap::new);

    public static Set<Long> getAllHasPermModel(QFilter[] filters) {
        HashSet<Long> sets = new HashSet<Long>();
        Collection dys = BusinessDataServiceHelper.loadFromCache((String)"perm_userperm", (String)"org", (QFilter[])filters).values();
        if (dys.size() > 0) {
            for (DynamicObject dy : dys) {
                sets.add(dy.getLong("org_id"));
            }
        }
        return sets;
    }

    public static Set<Long> getEffectiveByPermModel(String entity, ApplicationTypeEnum application) {
        entity = BcmFunPermissionHelper.getConnectPermEntity(entity);
        QFilter filter = new QFilter("user.id", "=", (Object)UserUtils.getUserId());
        AppInfo app = AppMetadataCache.getAppInfo((String)application.getAppnum());
        if (app == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6682\u65e0\u201c%1\u201d\u7684\u5e94\u7528\u64cd\u4f5c\u6743\u9650\u3002", (String)"EBPermission_2", (String)"epm-eb-common", (Object[])new Object[]{application.getAppnum()}));
        }
        QFilter bizApp = new QFilter("entryentity.bizapp", "=", (Object)app.getId());
        QFilter filter2 = new QFilter("entryentity.entitytype", "=", (Object)entity);
        if ("eb_card_myvalue".equals(entity) || "report_card_myvalue".equals(entity) || "report_card_financialdata".equals(entity)) {
            filter2 = new QFilter("1", "=", (Object)1);
        }
        Set<Long> set = BcmFunPermissionHelper.getAllHasPermModel(new QFilter[]{filter, bizApp, filter2});
        QFilter filter1 = new QFilter("id", "in", set);
        QFilter qcf = new QFilter("ReportType", "!=", (Object)"-1");
        switch (application) {
            case CM: {
                qcf = new QFilter("ReportType", "=", (Object)"1");
                break;
            }
            case RPT: {
                qcf = BcmFunPermissionHelper.getRptAdminModelQFilter();
                break;
            }
            case EB: {
                qcf = new QFilter("ReportType", "=", (Object)"4");
                break;
            }
            case BGMD: 
            case BGM: {
                qcf = new QFilter("ReportType", "=", (Object)"7");
                break;
            }
            case BGBD: {
                qcf = new QFilter("ReportType", "=", (Object)"9");
                qcf.or("ReportType", "=", (Object)"4").or("ReportType", "=", (Object)"7");
                break;
            }
        }
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"epm_model", (String)"id", (QFilter[])new QFilter[]{filter1, qcf});
        set.clear();
        for (DynamicObject dy : dys) {
            set.add(dy.getLong("id"));
        }
        return set;
    }

    public static Boolean existPublicModel() {
        QFilter filter = new QFilter("reporttype", "=", (Object)"5");
        return QueryServiceHelper.exists((String)"epm_model", (QFilter[])new QFilter[]{filter});
    }

    public static Set<Long> getRoleModel(long UserID, String perType, ApplicationTypeEnum application, String entityNum, String permItemId) {
        QFilter qcf = null;
        Map<String, Set<Long>> map = modelRoleLocal.get();
        if (map.containsKey("" + UserID + perType + application.name)) {
            return map.get("" + UserID + perType + application.name);
        }
        HashSet<Long> publicModelIds = new HashSet<Long>();
        HasPermDimObjResult perResult = entityNum == null || "eb_card_myvalue".equals(entityNum) || "report_card_myvalue".equals(entityNum) || "report_card_financialdata".equals(entityNum) ? PermissionServiceHelper.getUserHasPermDimObjs((long)UserID, (String)perType) : PermissionServiceHelper.getHasPermDimObjs((long)UserID, (String)AppMetadataCache.getAppInfo((String)application.getAppnum()).getId(), (String)entityNum, (String)permItemId);
        if (!perResult.hasAllDimObjPerm()) {
            publicModelIds.addAll(perResult.getHasPermDimObjs());
            qcf = new QFilter("id", "in", publicModelIds);
            if (ApplicationTypeEnum.RPT == application) {
                qcf.and(new QFilter("reporttype", "in", (Object)new String[]{ApplicationTypeEnum.RPT.index, ApplicationTypeEnum.CM.index, ApplicationTypeEnum.PUB.index}));
            } else if (ApplicationTypeEnum.BGBD == application) {
                qcf.and(new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.EB.index).or("reporttype", "=", (Object)ApplicationTypeEnum.BGMD.index));
            } else {
                qcf.and(new QFilter("reporttype", "=", (Object)application.index));
            }
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"epm_model", (String)"id", (QFilter[])new QFilter[]{qcf});
            publicModelIds.clear();
            for (DynamicObject dy : dys) {
                publicModelIds.add(dy.getLong("id"));
            }
        } else {
            switch (application) {
                case CM: {
                    qcf = new QFilter("ReportType", "=", (Object)"1");
                    break;
                }
                case RPT: {
                    qcf = BcmFunPermissionHelper.getRptAdminModelQFilter();
                    break;
                }
                case EB: {
                    qcf = new QFilter("ReportType", "=", (Object)"4");
                    break;
                }
                case BGMD: {
                    qcf = new QFilter("ReportType", "=", (Object)"7");
                    break;
                }
                case BGBD: {
                    qcf = new QFilter("ReportType", "=", (Object)"4");
                    qcf.or("ReportType", "=", (Object)"7");
                    break;
                }
            }
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"epm_model", (String)"id", (QFilter[])new QFilter[]{qcf});
            if (dys != null) {
                for (DynamicObject dy : dys) {
                    publicModelIds.add(dy.getLong("id"));
                }
            }
        }
        modelRoleLocal.get().put("" + UserID + perType + application.name, publicModelIds);
        return publicModelIds;
    }

    public static Set<Long> getRoleModel(long UserID, String perType, ApplicationTypeEnum application) {
        return BcmFunPermissionHelper.getRoleModel(UserID, perType, application, null, null);
    }

    public static QFilter getRptAdminModelQFilter() {
        QFilter qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.PUB.getOIndex());
        qcf.or(new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.RPT.getOIndex())).or(new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.CM.getOIndex()));
        return qcf;
    }

    private static String getConnectPermEntity(String entity) {
        String newentity = entity;
        switch (entity) {
            case "eb_datacollectlog_list": {
                newentity = "eb_datacollection";
                break;
            }
            case "eb_tpl_treelist": {
                newentity = "eb_cslscheme";
                break;
            }
            case "eb_phasesubmitlist": {
                newentity = "eb_phasesubmit";
                break;
            }
        }
        return newentity;
    }
}

