/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.serviceHelper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.ebcommon.common.enums.OrgBizChangeTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.PeriodUtils;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebBusiness.exchangeRate.ExchageRateServiceHelper;
import kd.epm.eb.ebBusiness.sql.util.DateTimeUtils;
import kd.epm.eb.ebBusiness.util.EntityVersioningUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CslSchemeServiceHelper {
    private static final String year = "year";
    private static final String period = "period";
    private static final String model = "model";
    private static final String cslscheme = "cslscheme";

    public static Collection<Long> getEffectiveCslSchemeIds(String yearNum, String periodId, Set<String> schemeNum, Long modelId) {
        CslSchemeServiceHelper.checkArgsNotNull(modelId);
        Pair dateMilliScope = null;
        if (yearNum != null && CslSchemeServiceHelper.isValidePeriodAndYear(yearNum, periodId)) {
            yearNum = yearNum.substring(2);
            dateMilliScope = PeriodUtils.getDateMilliScope((String)yearNum, (long)Long.parseLong(periodId));
        }
        DynamicObjectCollection allSchemeDynCollection = CslSchemeServiceHelper.queryAllSchemes(schemeNum, modelId);
        Map<String, Long> id2NumberMapping = CslSchemeServiceHelper.selectVaildeSchemes(dateMilliScope, allSchemeDynCollection);
        return id2NumberMapping.values();
    }

    private static boolean isValidePeriodAndYear(String yearNum, String periodId) {
        return StringUtils.isNotEmpty((String)yearNum) && StringUtils.isNotEmpty((String)periodId);
    }

    private static DynamicObjectCollection queryAllSchemes(Set<String> schemeNum, Long modelId) {
        boolean isTrue = true;
        QFilter filter = QFilter.of((String)"model = ? and isenable = ?", (Object[])new Object[]{modelId, isTrue});
        if (schemeNum != null) {
            filter.and(new QFilter("number", "in", schemeNum));
        }
        DynamicObjectCollection allSchemeDynCollection = QueryServiceHelper.query((String)"eb_cslscheme", (String)"id, number, version, effectivedate, expirationdate", (QFilter[])filter.toArray(), (String)"version", (int)-1);
        return allSchemeDynCollection;
    }

    private static Map<String, Long> selectVaildeSchemes(Pair<Long, Long> dateMilliScope, DynamicObjectCollection allSchemeDynCollection) {
        HashMap id2NumberMapping = Maps.newHashMap();
        for (DynamicObject schemeDyn : allSchemeDynCollection) {
            String number = schemeDyn.getString("number");
            if (id2NumberMapping.containsKey(number)) continue;
            Date effectiveDate = schemeDyn.getDate("effectivedate");
            Date expirationDate = schemeDyn.getDate("expirationdate");
            Long startMilliSeconds = effectiveDate == null ? Long.MIN_VALUE : effectiveDate.getTime();
            Long endMilliSeconds = expirationDate == null ? Long.MAX_VALUE : expirationDate.getTime();
            if (dateMilliScope != null && !CslSchemeServiceHelper.isDateInScope(startMilliSeconds, endMilliSeconds, dateMilliScope)) continue;
            id2NumberMapping.put(number, schemeDyn.getLong("id"));
        }
        return id2NumberMapping;
    }

    private static boolean isDateInScope(Long startMilliSeconds, Long endMilliSeconds, Pair<Long, Long> dateMilliScope) {
        Long legalStartMilliSeconds = (Long)dateMilliScope.getLeft();
        Long legalEndMilliSeconds = (Long)dateMilliScope.getRight();
        return startMilliSeconds <= legalEndMilliSeconds && endMilliSeconds >= legalStartMilliSeconds;
    }

    private static void checkArgsNotNull(Object ... args) {
        if (args.length <= 0) {
            return;
        }
        for (Object arg : args) {
            if (!Objects.isNull(arg)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"CslSchemeServiceHelper_0", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
    }

    public static Collection<Long> getAllEffectiveCslSchemeIds(String yearNum, String periodId, Long modelId) {
        return CslSchemeServiceHelper.getEffectiveCslSchemeIds(yearNum, periodId, null, modelId);
    }

    public static DynamicObjectCollection getOrgDynamicObjectCollection(QueryOrgParam param) {
        return param.getOrgDynamicObjectCollection();
    }

    public static DynamicObjectCollection getOrgDynamicObjectCollection(QueryOrgParam param, QFilter qFilter, Integer off, Integer len) {
        return param.getOrgDynamicObjectCollection(qFilter, off, len);
    }

    public static DynamicObjectCollection getOrgCollection(QFilter[] filters, String selectFields, String orderBys) {
        Collection values = BusinessDataServiceHelper.loadFromCache((String)"epm_entitymembertree", (String)selectFields, (QFilter[])filters, (String)orderBys).values();
        DynamicObject first = values.isEmpty() ? null : (DynamicObject)values.stream().findFirst().get();
        DynamicObjectCollection colls = first == null ? new DynamicObjectCollection() : new DynamicObjectCollection(first.getDynamicObjectType(), (Object)first);
        colls.addAll(values);
        return colls;
    }

    public static Long getRptDefaultSchemeId(long modelId) {
        QFBuilder qf = new QFBuilder(model, "=", (Object)modelId);
        qf.add("number", "=", (Object)"DefaultScheme");
        DynamicObject defaultScheme = QueryServiceHelper.queryOne((String)"eb_cslscheme", (String)"id", (QFilter[])qf.toArray());
        if (defaultScheme != null) {
            return defaultScheme.getLong("id");
        }
        return 0L;
    }

    public static class QueryOrgParam {
        private String yearNum = "";
        private String periodId = "";
        private String modelId = "";
        private Pair<Long, String> cslScheme;
        private Map<String, Object> params = new HashMap<String, Object>(10);
        private QFBuilder builder;
        private boolean needSchemeFilter = true;
        private boolean needSchemeModelFilter = true;
        private boolean isShowExchangeRate = false;
        private String selectFields = "id,name,number,parent,isleaf,storagetype,orgcode,currency,longnumber,aggoprt,level";

        private QueryOrgParam() {
        }

        public String getYearNum() {
            return this.yearNum;
        }

        public String getPeriodId() {
            return this.periodId;
        }

        public String getModelId() {
            return this.modelId;
        }

        public void set(String key, Object value) {
            this.params.put(key, value);
            switch (key) {
                case "cslscheme": {
                    this.cslScheme = (Pair)value;
                    break;
                }
                case "model": {
                    this.modelId = value == null ? null : String.valueOf(value);
                    break;
                }
                case "year": {
                    this.yearNum = value == null ? null : String.valueOf(value);
                    break;
                }
                case "period": {
                    this.periodId = value == null ? null : String.valueOf(value);
                    break;
                }
            }
        }

        public QFilter[] getBuilder() {
            if (this.builder != null) {
                return this.builder.toArray();
            }
            return QFilter.of((String)"1 = 1", (Object[])new Object[0]).toArray();
        }

        public void setBuilder(QFBuilder builder) {
            this.builder = builder;
        }

        public static QueryOrgParam of(String key, Object value) {
            QueryOrgParam param = new QueryOrgParam();
            param.set(key, value);
            return param;
        }

        public boolean isNeedSchemeFilter() {
            return this.needSchemeFilter;
        }

        public void setNeedSchemeFilter(boolean needSchemeFilter) {
            this.needSchemeFilter = needSchemeFilter;
        }

        public boolean isNeedSchemeModelFilter() {
            return this.needSchemeModelFilter;
        }

        public void setNeedSchemeModelFilter(boolean needSchemeModelFilter) {
            this.needSchemeModelFilter = needSchemeModelFilter;
        }

        public boolean isShowExchangeRate() {
            return this.isShowExchangeRate;
        }

        public void setShowExchangeRate(boolean showExchangeRate) {
            this.isShowExchangeRate = showExchangeRate;
        }

        public String getSelectFields() {
            return this.selectFields;
        }

        public void setSelectFields(String selectFields) {
            CslSchemeServiceHelper.checkArgsNotNull(new Object[]{selectFields});
            this.selectFields = selectFields;
        }

        public void setYearNum(String yearNum) {
            this.yearNum = yearNum;
        }

        public void setPeriodId(String periodId) {
            this.periodId = periodId;
        }

        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public Pair<Long, String> getCslScheme() {
            return this.cslScheme;
        }

        public void setCslScheme(Pair<Long, String> cslScheme) {
            this.cslScheme = cslScheme;
        }

        public QFilter genQueryFilter() {
            if (StringUtils.isEmpty((String)this.modelId)) {
                return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            }
            Long realTypeModelId = -1L;
            realTypeModelId = Long.valueOf(this.modelId);
            QFilter filterModel = new QFilter(CslSchemeServiceHelper.model, "=", (Object)realTypeModelId);
            if (!this.needSchemeFilter) {
                return filterModel;
            }
            HashSet effectiveCslSchemeIds = this.cslScheme != null ? Sets.newHashSet((Object[])new Long[]{(Long)this.cslScheme.getLeft()}) : CslSchemeServiceHelper.getAllEffectiveCslSchemeIds(this.yearNum, this.periodId, realTypeModelId);
            if (!this.needSchemeModelFilter) {
                effectiveCslSchemeIds = Sets.newHashSet((Object[])new Long[]{0L});
            }
            if (this.isShowExchangeRate) {
                if (effectiveCslSchemeIds.size() == 0) {
                    return filterModel;
                }
                filterModel = filterModel.and(new QFilter(CslSchemeServiceHelper.cslscheme, "in", (Object)effectiveCslSchemeIds).or(QFilter.of((String)"number = ?", (Object[])new Object[]{"Entity"}).or("isexchangerate", "=", (Object)Character.valueOf('1'))));
            } else {
                filterModel = filterModel.and(new QFilter(CslSchemeServiceHelper.cslscheme, "in", (Object)effectiveCslSchemeIds).or(QFilter.of((String)"number = ?", (Object[])new Object[]{"Entity"})));
            }
            return filterModel;
        }

        public DynamicObjectCollection getOrgDynamicObjectCollection() {
            QFilter filterModel = this.genQueryFilter();
            ExchageRateServiceHelper.delExchangeRatePlanFilter(filterModel, "epm_entitymembertree");
            QFilter[] customFilter = this.getBuilder();
            customFilter = Arrays.copyOf(customFilter, customFilter.length + 1);
            customFilter[customFilter.length - 1] = filterModel;
            DynamicObjectCollection doc = CslSchemeServiceHelper.getOrgCollection(customFilter, this.selectFields, "dseq");
            if (CslSchemeServiceHelper.isValidePeriodAndYear(this.yearNum, this.periodId)) {
                EntityVersioningUtil.filterVersionOrgTree(doc, this.modelId, this.yearNum, this.periodId);
            }
            return doc;
        }

        public DynamicObjectCollection getOrgDynamicObjectCollection(QFilter qFilter, Integer off, Integer len) {
            QFilter filterModel = this.genQueryFilter();
            if (qFilter != null) {
                filterModel = filterModel.and(qFilter);
            }
            if (CslSchemeServiceHelper.isValidePeriodAndYear(this.yearNum, this.periodId)) {
                DynamicObject modelDo = EntityVersioningUtil.getModelFilter(this.modelId);
                DynamicObject periodDo = EntityVersioningUtil.getPeriodFilter(this.periodId);
                Date firstDate = EntityVersioningUtil.getFilterDay(true, modelDo, this.yearNum, periodDo);
                Date yearFirst = DateTimeUtils.getYearFirst(DateTimeUtils.getYear(firstDate));
                Date lastDate = EntityVersioningUtil.getFilterDay(false, modelDo, this.yearNum, periodDo);
                filterModel = filterModel.and(new QFilter("bizchangerds.bizeffdate", "is null", null).or("namechangerds.namerds", "is null", null).or(new QFilter("bizchangerds.bizeffdate", "<=", (Object)lastDate).and(new QFilter("bizchangerds.bizexpdate", "is null", null).or("bizchangerds.bizexpdate", ">=", (Object)lastDate)).and(new QFilter("bizchangerds.changetype", "not in", (Object)new String[]{OrgBizChangeTypeEnum.disable.getValue(), OrgBizChangeTypeEnum.sameControlDisposal.getValue(), OrgBizChangeTypeEnum.liquidationDisposal.getValue(), OrgBizChangeTypeEnum.newSetMergeDisable.getValue()}).or(new QFilter("bizchangerds.changetype", "in", (Object)new String[]{OrgBizChangeTypeEnum.sameControlDisposal.getValue(), OrgBizChangeTypeEnum.liquidationDisposal.getValue()}).and("bizchangerds.bizeffdate", ">", (Object)yearFirst))).or(new QFilter("bizchangerds.changetype", "=", (Object)OrgBizChangeTypeEnum.newSetMergeDisable.getValue()).and("bizchangerds.bizeffdate", ">=", (Object)firstDate)).and(new QFilter("namechangerds.nameeffdate", "<=", (Object)lastDate).and(new QFilter("namechangerds.nameexpdate", "is null", null).or("namechangerds.nameexpdate", ">=", (Object)lastDate)))));
            }
            ExchageRateServiceHelper.delExchangeRatePlanFilter(filterModel, "epm_entitymembertree");
            QFilter[] customFilter = this.getBuilder();
            customFilter = Arrays.copyOf(customFilter, customFilter.length + 1);
            customFilter[customFilter.length - 1] = filterModel;
            DynamicObjectCollection doc1 = CslSchemeServiceHelper.getOrgCollection(customFilter, this.selectFields, "dseq");
            return doc1;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public DynamicObjectCollection queryPage(QFilter[] filters, int off, int len, String memberKey, String selectFields) {
            ORM orm = ORM.create();
            try (DataSet ds = orm.queryDataSet(this.getClass().getName(), memberKey, selectFields, filters, "dseq", off * 20, len);){
                DynamicObjectCollection dynamicObjectCollection = orm.toPlainDynamicObjectCollection(ds);
                return dynamicObjectCollection;
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
    }
}

