/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.serviceHelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.ElimTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;

@KSObject
public class DimensionServiceHelper {
    private static final Object[] mems = new Object[]{"DataCollection", "TraDif", "EntityInputTraDif", "CWP", "AutoCWP", "LinkageJournal"};

    public static void initDimensionDyObject(DynamicObject dy) {
        dy.set("status", (Object)"C");
        dy.set("enable", (Object)"1");
        DimensionServiceHelper.initCommonDyObject(dy);
    }

    public static void initDimensionDyObject(DynamicObject dy, boolean withOrg) {
        DimensionServiceHelper.initDimensionDyObject(dy);
        if (withOrg) {
            RequestContext tx = RequestContext.get();
            DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
            org.set("id", (Object)tx.getOrgId());
            dy.set("org", (Object)org);
        }
    }

    public static void initDimensionDyObjectWithOrg(DynamicObject dy) {
        DimensionServiceHelper.initDimensionDyObject(dy, true);
    }

    public static void initCommonDyObject(DynamicObject dy) {
        RequestContext tx = RequestContext.get();
        Date createTime = DimensionServiceHelper.getCurrentDate();
        dy.set("createtime", (Object)createTime);
        dy.set("modifytime", (Object)createTime);
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)UserUtils.getUserId());
        dy.set("creator", (Object)user);
        dy.set("modifier", (Object)user);
    }

    private static Date getCurrentDate() {
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static Collection<String> getMemberObjectFromMembers(List<DynamicObject> members) {
        ArrayList<String> collections = new ArrayList<String>(members.size());
        for (DynamicObject dynamicObject : members) {
            String object = dynamicObject.getString("number");
            collections.add(object);
        }
        return collections;
    }

    public static void initObject4BaseInfo(DynamicObject dy) {
        RequestContext tx = RequestContext.get();
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        Date createTime = Date.from(instant);
        dy.set("createtime", (Object)createTime);
        dy.set("modifytime", (Object)createTime);
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)UserUtils.getUserId());
        dy.set("creator", (Object)user);
        dy.set("modifier", (Object)user);
    }

    public static void assemModifyField(DynamicObject dy) {
        RequestContext tx = RequestContext.get();
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        Date createTime = Date.from(instant);
        dy.set("modifytime", (Object)createTime);
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)UserUtils.getUserId());
        dy.set("modifier", (Object)user);
    }

    public static DynamicObject getDimensionMessage(Object modelid, String entity, String selectFields, String dimsionNumber) {
        QFilter filter1 = new QFilter("model.id", "=", modelid);
        QFilter filter2 = new QFilter("membermodel", "=", (Object)entity);
        QFilter[] filters = StringUtils.isEmpty((String)dimsionNumber) ? new QFilter[]{filter1, filter2} : new QFilter[]{filter1, filter2, new QFilter("number", "=", (Object)dimsionNumber)};
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"epm_dimension", (String)selectFields, (QFilter[])filters);
        return dy;
    }

    public static DynamicObject getDynamicObjectName(String number, long modelid, String entityid) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        QFilter filter2 = new QFilter("model.id", "=", (Object)modelid);
        QFilter[] filters = new QFilter[]{filter, filter2};
        return QueryServiceHelper.queryOne((String)entityid, (String)"name", (QFilter[])filters);
    }

    public static DynamicObject getDynamicObject(String modelNum, String memberNum, String formEtity, String selectFields, long modelId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder = modelNum == null ? qfBuilder.add("model.id", "=", (Object)modelId) : qfBuilder.add("model.number", "=", (Object)modelNum);
        qfBuilder.add("number", "=", (Object)memberNum);
        return BusinessDataServiceHelper.loadSingle((String)formEtity, (String)selectFields, (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObject getModel(String modelNum, String selectFields) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("number", "=", (Object)modelNum);
        return BusinessDataServiceHelper.loadSingle((String)"epm_model", (String)selectFields, (QFilter[])qfBuilder.toArray());
    }

    public static Map<String, String> getDimensionNumMapped(Object modelId) {
        HashMap<String, String> result = new HashMap<String, String>();
        QFilter[] filters = new QFilter[]{new QFilter("model", "=", modelId)};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"DimensionServiceHelper.getDimensionNumMapped", (String)"epm_dimension", (String)"number,issysdimension,fieldmapped", (QFilter[])filters, null);){
            for (Row d : ds) {
                String number = d.getString("number");
                if (!d.getBoolean("issysdimension").booleanValue()) {
                    result.put(number, d.getString("fieldmapped"));
                    continue;
                }
                result.put(number, number.toLowerCase());
            }
        }
        return result;
    }

    public static List<String> getDimensionNumListByModel(Object modelId) {
        ArrayList<String> dimNums = new ArrayList<String>();
        BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"number", (QFilter[])new QFBuilder().add("model", "=", modelId).toArray(), (String)"dseq").values().forEach(e -> dimNums.add(e.getString("number")));
        return dimNums;
    }

    public static List<Long> getDimensionIdListByModel(Object modelId) {
        ArrayList<Long> dimIds = new ArrayList<Long>();
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"id", (QFilter[])new QFBuilder().add("model", "=", modelId).toArray(), (String)"dseq");
        dims.forEach(e -> dimIds.add(e.getLong("id")));
        return dimIds;
    }

    public static void getDimensionBymodelOnConsumer(long modelId, String selector, Consumer<DynamicObject> c) {
        BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)selector, (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).toArray(), (String)"dseq").values().forEach(c);
    }

    public static List<String> getUserDefineDimensionNumListByModel(Object modelId) {
        ArrayList<String> dimNums = new ArrayList<String>();
        BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"number", (QFilter[])new QFBuilder().add("model", "=", modelId).add("issysdimension", "=", (Object)"0").toArray()).values().forEach(e -> dimNums.add(e.getString("number")));
        return dimNums;
    }

    public static Map<String, String> getUserDefineDimensionNameAndMapByModel(Object modelId, boolean isShowName) {
        HashMap<String, String> map = new HashMap<String, String>();
        Collection dims = BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"number,name,fieldmapped", (QFilter[])new QFBuilder().add("model", "=", modelId).add("issysdimension", "=", (Object)false).toArray(), (String)"dseq").values();
        if (!isShowName) {
            for (DynamicObject dim : dims) {
                map.put(dim.getString("number"), dim.getString("fieldmapped"));
            }
        } else {
            for (DynamicObject dim : dims) {
                map.put(dim.getString("fieldmapped"), dim.getString("name"));
            }
        }
        return map;
    }

    public static Set<String> getExitUserDefinedDim(Object modelId) {
        return DimensionServiceHelper.getUserDefineDimensionNameAndMapByModel(modelId, true).keySet();
    }

    public static Map<String, String> getUserDefineDimensionNumAndNameByModel(Object modelId, boolean needSeq) {
        HashMap<String, String> dimNumAndName = new HashMap<String, String>();
        Collection dims = BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"number,name,fieldmapped", (QFilter[])new QFBuilder().add("model", "=", modelId).add("issysdimension", "=", (Object)false).toArray(), (String)"dseq").values();
        int seq = 1;
        for (DynamicObject dim : dims) {
            if (needSeq) {
                String ffieldmapped = dim.getString("fieldmapped");
                if (ffieldmapped != null && ffieldmapped.length() > 3) {
                    seq = Integer.parseInt(ffieldmapped.substring(3));
                }
                dimNumAndName.put(dim.getString("number"), dim.getString("name") + "." + seq);
            } else {
                dimNumAndName.put(dim.getString("number"), dim.getString("name"));
            }
            ++seq;
        }
        return dimNumAndName;
    }

    public static Map<String, String> getUserDefineDimensionNumAndName(Object modelId, boolean needSeq, Map<Long, String> map) {
        HashMap<String, String> dimNumAndName = new HashMap<String, String>();
        Collection dims = BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"number,name,fieldmapped", (QFilter[])new QFBuilder().add("model", "=", modelId).add("issysdimension", "=", (Object)"0").toArray(), (String)"dseq").values();
        int seq = 1;
        for (DynamicObject dim : dims) {
            if (needSeq) {
                String ffieldmapped = dim.getString("fieldmapped");
                if (ffieldmapped != null && ffieldmapped.length() > 3) {
                    seq = Integer.parseInt(ffieldmapped.substring(3));
                }
                dimNumAndName.put(dim.getString("number"), dim.getString("name") + "." + seq);
                map.put(dim.getLong("id"), dim.getString("number"));
            } else {
                dimNumAndName.put(dim.getString("number"), dim.getString("name"));
            }
            ++seq;
        }
        return dimNumAndName;
    }

    public static long getIdByNum(String entity, long modelId, String number) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model.id", "=", (Object)modelId);
        qfBuilder.add("number", "=", (Object)number);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)entity, (String)"id", (QFilter[])qfBuilder.toArray());
        return dy == null ? 0L : dy.getLong("id");
    }

    public static void initModelAndDimension(DynamicObject dy, String number, long modelId, String className) {
        DynamicObject modelOb = BusinessDataServiceHelper.newDynamicObject((String)"epm_model");
        DynamicObject dimensionOb = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimension");
        modelOb.set("id", (Object)modelId);
        String selectFields = "id";
        QFilter filter1 = new QFilter("number", "=", (Object)number);
        QFilter filter2 = new QFilter("model.id", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)className, (String)"epm_dimension", (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            String dimensionId = ((DynamicObject)dcs.get(0)).getString("id");
            dimensionOb.set("id", (Object)dimensionId);
        }
        dy.set("model", (Object)modelOb);
        dy.set("dimension", (Object)dimensionOb);
    }

    public static int getDSeq(long id, String entity, String className) {
        QFilter filter = new QFilter("parent", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)className, (String)entity, (String)"dseq", (QFilter[])filters, (String)"dseq");
        if (dcs != null) {
            if (dcs.size() == 0) {
                return 1;
            }
            return ((DynamicObject)dcs.get(dcs.size() - 1)).getInt("dseq") + 1;
        }
        return 1;
    }

    public static Map<String, Map<String, DynamicObject>> queryAllDimMember(List<String> queryDims, Object modelId, String dimKeytype, String memberKeytype, String selectFields) {
        Objects.requireNonNull(queryDims);
        ArrayList lowercase = new ArrayList();
        queryDims.forEach(d -> lowercase.add(d.toLowerCase()));
        return (Map)ThreadCache.get((Object)(dimKeytype + memberKeytype + selectFields + modelId + String.join((CharSequence)";", queryDims)), () -> {
            HashMap result = new HashMap(16);
            QFilter qFilter = new QFilter("model", "=", modelId);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"bcm", (String)"epm_dimension", (String)"shortnumber,number", (QFilter[])new QFilter[]{qFilter}, null);
            Iterator iterator = ds.iterator();
            while (ds.hasNext()) {
                Row row = (Row)iterator.next();
                String number = row.getString("number");
                if (!lowercase.contains(number.toLowerCase())) continue;
                String entityNum = DimensionServiceHelper.getDimMembEntityNumByShortNum(row.getString("shortnumber"));
                Collection members = BusinessDataServiceHelper.loadFromCache((String)entityNum, (String)selectFields, (QFilter[])new QFilter[]{qFilter}).values();
                HashMap dimMap = new HashMap(members.size());
                members.forEach(e -> dimMap.put(e.getString(memberKeytype), e));
                result.put(row.getString(dimKeytype), dimMap);
            }
            return result;
        });
    }

    public static DynamicObject queryDimensionMemberByNumber(String entityName, Object modelId, String dimNumber) {
        QFilter qf = new QFilter("model", "=", modelId);
        QFilter qf2 = new QFilter("number", "=", (Object)dimNumber);
        return QueryServiceHelper.queryOne((String)entityName, (String)"id,name,dimension.name", (QFilter[])new QFilter[]{qf, qf2});
    }

    public static DynamicObject queryMemberIdByNumber(String entityName, Object modelId, String dimNumber) {
        QFilter qf = new QFilter("model", "=", modelId);
        QFilter qf2 = new QFilter("number", "=", (Object)dimNumber);
        return QueryServiceHelper.queryOne((String)entityName, (String)"id,number", (QFilter[])new QFilter[]{qf, qf2});
    }

    public static DynamicObject queryMemberNameByNumber(String entityName, Object modelId, String dimNumber) {
        QFilter qf = new QFilter("model", "=", modelId);
        QFilter qf2 = new QFilter("number", "=", (Object)dimNumber);
        return QueryServiceHelper.queryOne((String)entityName, (String)"name", (QFilter[])new QFilter[]{qf, qf2});
    }

    public static String getDimMembEntityNumByDimNum(String dimNum) {
        switch (dimNum.toLowerCase(Locale.getDefault())) {
            case "entity": {
                return "epm_entitymembertree";
            }
            case "account": {
                return "epm_accountmembertree";
            }
            case "year": {
                return "epm_yearmembertree";
            }
            case "period": {
                return "epm_periodmembertree";
            }
            case "scenario": {
                return "epm_scenemembertree";
            }
            case "process": {
                return "epm_processmembertree";
            }
            case "currency": {
                return "epm_currencymembertree";
            }
            case "audittrail": {
                return "epm_audittrialmembertree";
            }
            case "changetype": {
                return "epm_changetypemembertree";
            }
            case "internalcompany": {
                return "epm_icmembertree";
            }
            case "multigaap": {
                return "eb_rulemembertree";
            }
            case "datatype": {
                return "epm_datatypemembertree";
            }
            case "datasort": {
                return "eb_datasortmembertree";
            }
            case "mycompany": {
                return "eb_mycompanymembertree";
            }
        }
        return "epm_userdefinedmembertree";
    }

    public static String getDimMembEntityNumByShortNum(String shortNum) {
        switch (shortNum) {
            case "E": {
                return "epm_entitymembertree";
            }
            case "A": {
                return "epm_accountmembertree";
            }
            case "S": {
                return "epm_scenemembertree";
            }
            case "FY": {
                return "epm_yearmembertree";
            }
            case "P": {
                return "epm_periodmembertree";
            }
            case "BP": {
                return "epm_processmembertree";
            }
            case "C": {
                return "epm_currencymembertree";
            }
            case "AT": {
                return "epm_audittrialmembertree";
            }
            case "CT": {
                return "epm_changetypemembertree";
            }
            case "MC": {
                return "eb_mycompanymembertree";
            }
            case "IC": {
                return "epm_icmembertree";
            }
            case "MG": {
                return "eb_rulemembertree";
            }
            case "DS": {
                return "eb_datasortmembertree";
            }
        }
        return "epm_userdefinedmembertree";
    }

    public static boolean checkSPConfig(boolean isBeforeSelect, DynamicObject scenarioDy, long modelId, IDataModel dataModel, String periodKey) {
        if (isBeforeSelect) {
            if (scenarioDy == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"DimensionServiceHelper_0", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
            DynamicObjectCollection coll = DimensionServiceHelper.getScenePeriod(modelId, scenarioDy.getLong("id"));
            if (coll != null && coll.size() > 0) {
                boolean hasPeriod = dataModel.getDataEntityType().getProperties().containsKey((Object)periodKey);
                if (hasPeriod) {
                    // empty if block
                }
                return true;
            }
        }
        return false;
    }

    public static void buildPeriodFilter(long modelId, long scenarioId, FormShowParameter showParameter) {
        DynamicObjectCollection coll = DimensionServiceHelper.getScenePeriod(modelId, scenarioId);
        if (coll != null && coll.size() > 0) {
            ArrayList list = new ArrayList();
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            coll.forEach(p -> {
                DynamicObject period = p.getDynamicObject("fbasedataid");
                if (period != null) {
                    list.add(period.getLong("id"));
                }
            });
            filter.and("id", "in", (Object)list.toArray());
            showParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"DimensionServiceHelper_1", (String)"epm-eb-spread", (Object[])new Object[0]));
            showParameter.setCustomParam("periodFilter", (Object)ObjectSerialUtil.toByteSerialized((Object)filter));
        }
    }

    public static DynamicObjectCollection getScenePeriod(long modelId, long scenarioId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("id", "=", (Object)scenarioId);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"epm_scenemembertree", (String)"sceneperiod", (QFilter[])qfBuilder.toArray());
        if (dy == null) {
            return null;
        }
        return dy.getDynamicObjectCollection("sceneperiod");
    }

    public static void hazySearch(long modelId, long scenarioId, BasedataEdit basedataEdit) {
        QFilter filter = DimensionServiceHelper.getFilter(modelId, scenarioId);
        if (filter != null) {
            basedataEdit.setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{filter}));
        }
    }

    public static QFilter getFilter(long modelId, long scenarioId) {
        QFilter filter = null;
        DynamicObjectCollection coll = DimensionServiceHelper.getScenePeriod(modelId, scenarioId);
        if (coll != null && coll.size() > 0) {
            ArrayList list = new ArrayList();
            filter = new QFilter("model", "=", (Object)modelId);
            coll.forEach(p -> {
                DynamicObject period = p.getDynamicObject("fbasedataid");
                if (period != null) {
                    list.add(period.getLong("id"));
                }
            });
            filter.and("id", "in", (Object)list.toArray());
        }
        return filter;
    }

    public static String getDefaultScenarioNumber(long modelId, long templdateId) {
        QFBuilder qf = new QFBuilder("number", "=", (Object)"Actual");
        if (modelId != 0L) {
            qf.add("model", "=", (Object)modelId);
        } else {
            DynamicObject dy = QueryServiceHelper.queryOne((String)"eb_templateentity_bg", (String)"model", (QFilter[])new QFBuilder("id", "=", (Object)templdateId).toArray());
            if (dy == null) {
                return "MRpt";
            }
            qf.add("model", "=", (Object)dy.getLong("model"));
        }
        boolean isOldData = QueryServiceHelper.exists((String)"epm_scenemembertree", (QFilter[])qf.toArray());
        if (isOldData) {
            return "Actual";
        }
        return "MRpt";
    }

    public static String getDefaultScenarioNumber(long modelId, long templdateId, ApplicationTypeEnum app) {
        if (ApplicationTypeEnum.BGMD == app || ApplicationTypeEnum.BGBD == app || ApplicationTypeEnum.BGM == app) {
            return "NoScenario";
        }
        if (ApplicationTypeEnum.EB == app) {
            return "Budget";
        }
        QFBuilder qf = new QFBuilder("number", "=", (Object)"Actual");
        if (modelId != 0L) {
            qf.add("model", "=", (Object)modelId);
        } else {
            DynamicObject dy = QueryServiceHelper.queryOne((String)"eb_templateentity_bg", (String)"model", (QFilter[])new QFBuilder("id", "=", (Object)templdateId).toArray());
            if (dy == null) {
                return "MRpt";
            }
            qf.add("model", "=", (Object)dy.getLong("model"));
        }
        boolean isOldData = QueryServiceHelper.exists((String)"epm_scenemembertree", (QFilter[])qf.toArray());
        if (isOldData) {
            return "Actual";
        }
        return "MRpt";
    }

    public static DynamicObject getEbDefaultScenMember(Object modelId, String selectKeys, ApplicationTypeEnum app) {
        if (selectKeys == null || selectKeys.equals("")) {
            selectKeys = "id,number,name";
        }
        String memberNumber = "NoScenario";
        QFilter qModel = new QFilter("model", "=", modelId);
        QFilter qMemberNum = new QFilter("number", "=", (Object)memberNumber);
        DynamicObject member = QueryServiceHelper.queryOne((String)"epm_scenemembertree", (String)"id,number,name", (QFilter[])new QFilter[]{qMemberNum, qModel});
        return member;
    }

    public static DynamicObject getEbDefaultProcessMember(Object modelId, String selectKeys) {
        if (selectKeys == null || selectKeys.equals("")) {
            selectKeys = "id,number,name";
        }
        QFilter qModel = new QFilter("model", "=", modelId);
        QFilter qMemberNum = new QFilter("number", "=", (Object)"IRpt");
        DynamicObject member = QueryServiceHelper.queryOne((String)"epm_processmembertree", (String)"id,number,name", (QFilter[])new QFilter[]{qMemberNum, qModel});
        return member;
    }

    public static DynamicObject getEbDefaultChangeTypeMember(Object modelId, String selectKeys) {
        if (selectKeys == null || selectKeys.equals("")) {
            selectKeys = "id,number,name";
        }
        QFilter qModel = new QFilter("model", "=", modelId);
        QFilter qMemberNum = new QFilter("number", "=", (Object)"CurrentPeriod");
        DynamicObject member = QueryServiceHelper.queryOne((String)"epm_changetypemembertree", (String)"id,number,name", (QFilter[])new QFilter[]{qMemberNum, qModel});
        return member;
    }

    public static DynamicObject queryMyCompanyDim(long modelId) {
        return QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id,number", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)"MyCompany").toArray());
    }

    public static boolean existsMyCompanyDim(long modelId) {
        return QueryServiceHelper.exists((String)"epm_dimension", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)"MyCompany").toArray());
    }

    public static boolean existsMGMultiGAAPDim(long modelId) {
        return QueryServiceHelper.exists((String)"epm_dimension", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)"MultiGAAP").toArray());
    }

    public static boolean existsTraDifMember(long modelId) {
        return QueryServiceHelper.exists((String)"epm_audittrialmembertree", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)"TraDif").toArray());
    }

    public static boolean existsBPNoneMember(long modelId) {
        return QueryServiceHelper.exists((String)"epm_processmembertree", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)"BPNone").toArray());
    }

    public static List<String> getAllDim(Long modelid) {
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"id, number", (QFilter[])new QFBuilder().add("model", "=", (Object)modelid).toArray(), (String)"dseq");
        ArrayList<String> allDim = new ArrayList<String>();
        dims.forEach(e -> allDim.add(e.getString("number")));
        return allDim;
    }

    public static boolean isExitMember(long modelId, long dimensionId, String number, String form) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        qf.add("dimension", "=", (Object)dimensionId);
        qf.add("number", "=", (Object)number);
        return QueryServiceHelper.exists((String)form, (QFilter[])qf.toArray());
    }

    public static Map<Long, Set<String>> getAllModelMembers(Object[] numbers, String form) {
        QFBuilder qf = new QFBuilder("number", "in", (Object)numbers);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)form, (String)"model.id,number", (QFilter[])qf.toArray());
        HashMap map = Maps.newHashMap();
        for (DynamicObject dy : doc) {
            Long modelId = dy.getLong("model.id");
            if (map.get(modelId) == null) {
                HashSet set = Sets.newHashSet();
                set.add(dy.getString("number"));
                map.put(modelId, set);
                continue;
            }
            ((Set)map.get(modelId)).add(dy.getString("number"));
        }
        return map;
    }

    public static String getMemberNumber(String entityNum, DynamicObject obj) {
        QFilter filter = new QFilter("id", "=", obj.get("parent"));
        DynamicObject parent = QueryServiceHelper.queryOne((String)entityNum, (String)"number", (QFilter[])new QFilter[]{filter});
        return parent.getString("number");
    }

    public static String getMemberNumber(String entityNum, Object id) {
        if (id instanceof DynamicObject) {
            id = ((DynamicObject)id).get("id");
        }
        QFilter filter = new QFilter("id", "=", id);
        DynamicObject parent = QueryServiceHelper.queryOne((String)entityNum, (String)"number", (QFilter[])new QFilter[]{filter});
        if (parent == null) {
            return "";
        }
        return parent.getString("number");
    }

    public static List<Long> getYearIdsByModel(long modelid) {
        QFBuilder qf = new QFBuilder();
        qf.add(new QFilter("model", "=", (Object)modelid));
        DynamicObject[] yearCollections = BusinessDataServiceHelper.load((String)"epm_yearmembertree", (String)"id", (QFilter[])qf.toArray(), (String)"dseq");
        ArrayList<Long> yearIdsList = new ArrayList<Long>(yearCollections.length);
        for (DynamicObject dy : yearCollections) {
            yearIdsList.add(dy.getLong("id"));
        }
        return yearIdsList;
    }

    public static Map<String, List<String>> getScenePeriodMap(Long modelid) {
        DynamicObject[] dycol;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelid);
        for (DynamicObject dy : dycol = BusinessDataServiceHelper.load((String)"epm_scenemembertree", (String)"number, sceneperiod.number", (QFilter[])qfBuilder.toArray())) {
            if (map.get(dy.getString("number")) == null) {
                map.put(dy.getString("number"), new ArrayList());
            }
            if (dy.getDynamicObjectCollection("sceneperiod") == null) continue;
            dy.getDynamicObjectCollection("sceneperiod").forEach(e -> {
                if (e.getDynamicObject("fbasedataid") != null) {
                    ((List)map.get(dy.getString("number"))).add(e.getDynamicObject("fbasedataid").getString("number"));
                }
            });
        }
        return map;
    }

    public static boolean isCM02Model(long modelid) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelid);
        qfBuilder.and("number", "=", (Object)ElimTypeEnum.EIT.getNumber());
        return !QueryServiceHelper.exists((String)"epm_processmembertree", (QFilter[])qfBuilder.toArray());
    }
}

