/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.serviceHelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.ebcommon.common.cache.IDNumberTreeNode;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;
import kd.epm.eb.common.ebcommon.common.enums.DetailTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.ebBusiness.exchangeRate.ExchageRateServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.TreeStructureServiceHelper;

public class DistributionDetailsSpreadLogic {
    protected static WatchLogger log;
    private static final String[] selectFields1;
    private static final String[] selectFields2;
    private static final String[] selectFields3;
    private static final String[] selectFields4;

    public DistributionDetailsSpreadLogic() {
        log = BcmLogFactory.getWatchLogInstance(this.getClass());
    }

    public List<QFilter> buildQueryAllChildFilter(String entity, Object entityid, String modelid, Integer iDetail, boolean needQueryLongNumber, boolean needAddDelExchangeRatePlanFilter, boolean includeSelf) {
        boolean isFalse = false;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (modelid != null) {
            filterList.add(new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelid)));
        }
        if (needQueryLongNumber) {
            Object longNumber = this.getOrgMemLongNumber(entity, entityid);
            filterList.add(new QFilter("longnumber", "like", (Object)(longNumber + String.valueOf('!') + "%")));
        }
        if (needAddDelExchangeRatePlanFilter) {
            if ("epm_entitymembertree".equals(entity)) {
                filterList.add(new QFilter("isexchangerate", "=", (Object)isFalse));
            } else if ("epm_versionmembertree".equals(entity)) {
                filterList.add(new QFilter("isactual", "!=", (Object)"1"));
            }
        }
        if (iDetail != null) {
            filterList.add(new QFilter("isleaf", "=", (Object)(iDetail == 1 ? 1 : 0)));
        }
        return filterList;
    }

    protected Object getOrgMemLongNumber(String entity, Object entityid) {
        DynamicObject orgmen = BusinessDataServiceHelper.loadSingleFromCache((Object)entityid, (String)entity, (String)"longnumber");
        return orgmen != null ? orgmen.get("longnumber") : null;
    }

    List<DynamicObject> queryAllChild(String entity, Long entityid, String modelid, Integer iDetail) {
        List<QFilter> filters = this.buildQueryAllChildFilter(entity, entityid, modelid, iDetail, true, true, true);
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id,number,name, copyfrom", (QFilter[])filters.toArray(new QFilter[0])).values());
    }

    List<DynamicObject> queryAllChild(String entity, Long entityid, String modelid) {
        List<QFilter> filters = this.buildQueryAllChildFilter(entity, entityid, modelid, null, true, true, true);
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id,number,name,isleaf,copyfrom,parent,level,dseq", (QFilter[])filters.toArray(new QFilter[0]), (String)"dseq").values());
    }

    DynamicObject querySelf(String entity, Long entityid, String modelid) {
        QFilter filter = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelid));
        QFilter filter1 = new QFilter("id", "=", (Object)entityid);
        return BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"id,number,name,isleaf,copyfrom,parent,level,dseq", (QFilter[])new QFilter[]{filter, filter1});
    }

    public List<QFilter> buildQueryDirectChild(String entity, Collection<?> entityIds, String parent, boolean needAddDelExchangeRatePlanFilter) {
        boolean isFalse = false;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (parent != null) {
            filterList.add(new QFilter(parent, "in", (Object)IDUtils.toLongs((Object[])entityIds.toArray())));
        }
        if (needAddDelExchangeRatePlanFilter) {
            if ("epm_entitymembertree".equals(entity)) {
                filterList.add(new QFilter("isexchangerate", "=", (Object)isFalse));
            } else if ("epm_versionmembertree".equals(entity)) {
                filterList.add(new QFilter("isactual", "!=", (Object)"1"));
            }
        }
        return filterList;
    }

    private List<DynamicObject> queryDirectChild(String entity, Long entityid, String parent) {
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id, number, name, isleaf, copyfrom", (QFilter[])this.buildQueryDirectChild(entity, Collections.singletonList(entityid), parent, true).toArray(new QFilter[0]), (String)"dseq").values());
    }

    protected List<QFilter> buildQueryAllBrothersFilters(String entity, Collection<?> entityIds, String modelid, String parent) {
        QFilter filter = new QFilter("id", "in", (Object)IDUtils.toLongs((Object[])entityIds.toArray()));
        HashSet<Object> parentIds = new HashSet<Object>();
        for (DynamicObject dyn : QueryServiceHelper.query((String)entity, (String)parent, (QFilter[])filter.toArray())) {
            parentIds.add(dyn.get(parent));
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filter = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelid));
        ExchageRateServiceHelper.delExchangeRatePlanFilter(filter, entity);
        filterList.add(filter);
        filterList.add(new QFilter(parent, "in", (Object)IDUtils.toLongs(parentIds)));
        filterList.add(new QFilter("number", "!=", (Object)DimTypesEnum.ENTITY.getNumber()));
        return filterList;
    }

    private List<DynamicObject> queryAllBrothers(String entity, Long entityId, String modelid, String parent) {
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id, number, name, isleaf, copyfrom", (QFilter[])this.buildQueryAllBrothersFilters(entity, Collections.singletonList(entityId), modelid, parent).toArray(new QFilter[0]), (String)"dseq").values());
    }

    public DynamicObject[] queryDistributeCollectionByTemplate(Collection<Long> tempalteIds, Object modelid) {
        String selectFields = "id, template, entity, memrangdecombo, definedproperty, definedpropertyvalue";
        QFilter filter1 = new QFilter("model", "=", (Object)Convert.toLong((Object)modelid));
        if (tempalteIds != null) {
            filter1.and(new QFilter("template", "in", tempalteIds));
        }
        return BusinessDataServiceHelper.loadFromCache((String)"eb_distributionentity", (String)selectFields, (QFilter[])filter1.toArray()).values().toArray(new DynamicObject[0]);
    }

    @Deprecated
    public DynamicObject[] queryDistributeCollectionByModelId(Object modelId) {
        return this.queryDistributeCollectionByTemplate(null, modelId);
    }

    Map<Long, Set<Long>> getDistributionDetailsByTemplate(Collection<Long> tempalteIds, Object modelid, boolean isCheckPerm) {
        HashMap<Long, Set<Long>> resultOrgMap = new HashMap<Long, Set<Long>>();
        HashMap<Long, Map> rangOrgMap = new HashMap<Long, Map>();
        for (DynamicObject dd : this.queryDistributeCollectionByTemplate(tempalteIds, modelid)) {
            Long templateId = dd.getLong("template.id");
            int range = dd.getInt("memrangdecombo");
            Long entity = dd.getLong("entity_id");
            if (entity == 0L) continue;
            Map map = rangOrgMap.computeIfAbsent(templateId, k -> new HashMap());
        }
        for (Map.Entry entry : rangOrgMap.entrySet()) {
            Set entitySet = resultOrgMap.computeIfAbsent((Long)entry.getKey(), (Function<Long, Set<Long>>)((Function<Long, Set>)k -> new HashSet()));
            entitySet.addAll(this.chooseMethodByRange("epm_entitymembertree", modelid, (Map)entry.getValue(), DetailTypeEnum.TEMPLATEDIS));
        }
        return resultOrgMap;
    }

    Long getBaseMemberId(Long mid, String membermodel) {
        DynamicObject member = BusinessDataServiceHelper.loadSingleFromCache((Object)mid, (String)membermodel, (String)"member,dimension.id");
        QFilter filter = new QFilter("dimension", "=", member.get("dimension.id")).and(new QFilter("number", "=", (Object)member.getString("number"))).and(new QFilter("storagetype", "!=", (Object)"3"));
        member = BusinessDataServiceHelper.loadSingleFromCache((String)membermodel, (String)"id", (QFilter[])filter.toArray());
        return member.getLong("id");
    }

    List<DynamicObject> queryMemberIdsByProperty(String entity, String colname, Set<Long> list) {
        QFilter filter = new QFilter(colname, "in", list);
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id,number,name", (QFilter[])filter.toArray()).values());
    }

    Set<Object> change2ShareMember(Object mid) {
        HashSet<Object> mids = new HashSet<Object>();
        mids.add(mid);
        DynamicObjectType dtType = EntityMetadataCache.getSubDataEntityType((String)"epm_entitymembertree", Arrays.asList(selectFields1));
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)mid, (DynamicObjectType)dtType);
        if (!"3".equals(obj.getString("storagetype"))) {
            QFilter filter1 = new QFilter("member.id", "=", (Object)obj.getLong("member.id"));
            QFilter filter2 = new QFilter("storagetype", "=", (Object)"3");
            DynamicObject basemember = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{filter1, filter2});
            if (basemember != null) {
                mids.add(basemember.getLong("id"));
            }
        }
        return mids;
    }

    Set<Long> change2BaseMember(Set<Long> mids) {
        return MemberReader.change2BaseMember((String)"epm_entitymembertree", mids);
    }

    public boolean chooseMethodByRange(int value, DynamicObject org, DynamicObject entity, String parent) {
        if (!"parentid".equals(parent) && entity.getBoolean("isexchangerate")) {
            return false;
        }
        switch (value) {
            case 10: {
                return ("parentid".equals(parent) || !DimTypesEnum.ENTITY.getNumber().equals(entity.getString("number"))) && org.getLong("id") == entity.getLong("id");
            }
            case 20: {
                return entity.getLong("id") == org.getLong(parent);
            }
            case 30: {
                return entity.getLong("id") == org.getLong(parent) || entity.getLong("id") == org.getLong("id");
            }
            case 40: {
                return org.getString("longnumber").indexOf(entity.getString("longnumber")) == 0 && entity.getLong("id") != org.getLong("id");
            }
            case 50: {
                return org.getString("longnumber").indexOf(entity.getString("longnumber")) == 0;
            }
            case 60: {
                return entity.getLong(parent) == org.getLong(parent) && entity.getLong("id") != org.getLong("id");
            }
            case 70: {
                return entity.getLong(parent) == org.getLong(parent);
            }
            case 90: {
                return org.getString("longnumber").indexOf(entity.getString("longnumber")) == 0 && entity.getLong("id") != org.getLong("id") && org.getBoolean("isleaf");
            }
            case 110: {
                return org.getString("longnumber").indexOf(entity.getString("longnumber")) == 0 && !org.getBoolean("isleaf");
            }
        }
        return false;
    }

    public List<DynamicObject> chooseMethodColByRange(String entity, int scope, Long entityid, String modelid, String parent, DetailTypeEnum type) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> temp = new ArrayList<DynamicObject>();
        DynamicObject self = this.querySelf(entity, entityid, modelid);
        switch (scope) {
            case 10: {
                if (this.isOrgRootMember(entityid, type)) break;
                result.add(self);
                break;
            }
            case 20: {
                result.addAll(this.queryDirectChild(entity, entityid, parent));
                break;
            }
            case 30: {
                if (!this.isOrgRootMember(entityid, type)) {
                    result.add(self);
                }
                result.addAll(this.queryDirectChild(entity, entityid, parent));
                break;
            }
            case 40: {
                temp.add(self);
                temp.addAll(this.queryAllChild(entity, entityid, modelid));
                String parentId = self != null && self.getDynamicObject("parent") != null ? self.getDynamicObject("parent").getString("id") : "";
                this.getMemberListByLevelAndDseq(result, temp, parentId, 40);
                break;
            }
            case 50: {
                temp.add(self);
                temp.addAll(this.queryAllChild(entity, entityid, modelid));
                this.getMemberListByLevelAndDseq(result, temp, self != null && self.getDynamicObject("parent") != null ? self.getDynamicObject("parent").getString("id") : "0", 50);
                break;
            }
            case 60: {
                result.addAll(this.queryAllBrothers(entity, entityid, modelid, parent));
                this.removeSelf(result, entityid);
                break;
            }
            case 70: {
                result.addAll(this.queryAllBrothers(entity, entityid, modelid, parent));
                break;
            }
            case 90: {
                temp.add(self);
                temp.addAll(this.queryAllChild(entity, entityid, modelid));
                String parentId = self != null && self.getDynamicObject("parent") != null ? self.getDynamicObject("parent").getString("id") : "";
                this.getMemberListByLevelAndDseq(result, temp, parentId, 90);
                break;
            }
            case 110: {
                temp.add(self);
                temp.addAll(this.queryAllChild(entity, entityid, modelid));
                String parentId = self != null && self.getDynamicObject("parent") != null ? self.getDynamicObject("parent").getString("id") : "";
                this.getMemberListByLevelAndDseq(result, temp, parentId, 110);
            }
        }
        return result;
    }

    public Set<Long> chooseMethodByRange(String entityName, Object modelid, Map<Integer, Set<Long>> lookupSourceMap, DetailTypeEnum type) {
        Map<Long, IDNumberTreeNode> entityTree = TreeStructureServiceHelper.getAllNode(entityName, modelid);
        HashSet<Long> resultList = new HashSet<Long>();
        for (Map.Entry<Integer, Set<Long>> en : lookupSourceMap.entrySet()) {
            for (Long entityId : en.getValue()) {
                resultList.addAll(this.chooseMethodByRange(entityTree, en.getKey(), entityId, type));
            }
        }
        return resultList;
    }

    public Set<Long> chooseMethodByRange(Map<Long, IDNumberTreeNode> entityTree, int scope, Long entityId, DetailTypeEnum type) {
        HashSet<Long> resultList = new HashSet<Long>();
        boolean addSelf = false;
        switch (scope) {
            case 10: {
                addSelf = true;
                break;
            }
            case 30: {
                addSelf = true;
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getChildren()));
                break;
            }
            case 20: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getChildren()));
                break;
            }
            case 50: {
                addSelf = true;
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getAllChildren()));
                break;
            }
            case 40: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getAllChildren()));
                break;
            }
            case 70: {
                resultList.add(entityId);
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getBrother()));
                break;
            }
            case 60: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getBrother()));
                break;
            }
            case 90: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getAllChildren(2)));
                break;
            }
            case 110: {
                addSelf = true;
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getAllChildren(1)));
                break;
            }
        }
        if (addSelf && !TreeStructureServiceHelper.isRootEntityNodeId(entityId, type)) {
            resultList.add(entityId);
        }
        return resultList;
    }

    @Deprecated
    public Set<Long> chooseMethodByRange(String entity, int value, Long entityid, String modelid, String parent, DetailTypeEnum type) {
        HashSet<Long> templateSet = new HashSet<Long>();
        switch (value) {
            case 10: {
                if (this.isOrgRootMember(entityid, type)) break;
                templateSet.add(entityid);
                break;
            }
            case 20: {
                for (DynamicObject mem : this.queryDirectChild(entity, entityid, parent)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 30: {
                if (!this.isOrgRootMember(entityid, type)) {
                    templateSet.add(entityid);
                }
                for (DynamicObject mem : this.queryDirectChild(entity, entityid, parent)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 40: {
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 50: {
                if (!this.isOrgRootMember(entityid, type)) {
                    templateSet.add(entityid);
                }
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 60: {
                for (DynamicObject mem : this.queryAllBrothers(entity, entityid, modelid, parent)) {
                    templateSet.add(mem.getLong("id"));
                }
                templateSet.remove(entityid);
                break;
            }
            case 70: {
                for (DynamicObject mem : this.queryAllBrothers(entity, entityid, modelid, parent)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 90: {
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid, 1)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 110: {
                if (!this.isOrgRootMember(entityid, type)) {
                    templateSet.add(entityid);
                }
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid, 0)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
        }
        return templateSet;
    }

    public Set<String> chooseMethodByRange4Number(String entity, int scope, Long entityId, String number, String modelid, String parent, DetailTypeEnum type) {
        String key = entity + "|" + scope + "|" + entityId + "|" + modelid + "|" + type;
        HashSet<String> resultList = (HashSet<String>)ThreadCache.get((Object)key);
        if (resultList != null) {
            return resultList;
        }
        resultList = new HashSet<String>();
        ThreadCache.put((Object)key, resultList);
        Map<Long, IDNumberTreeNode> entityTree = TreeStructureServiceHelper.getAllNode(entity, modelid);
        boolean addSelf = false;
        switch (scope) {
            case 10: {
                addSelf = true;
                break;
            }
            case 30: {
                addSelf = true;
                break;
            }
            case 20: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getNumbers(treeNodeBuf.getChildren()));
                break;
            }
            case 50: {
                addSelf = true;
                break;
            }
            case 40: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getNumbers(treeNodeBuf.getAllChildren()));
                break;
            }
            case 70: {
                resultList.add(number);
                break;
            }
            case 60: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getNumbers(treeNodeBuf.getBrother()));
                break;
            }
            case 90: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getNumbers(treeNodeBuf.getAllChildren(2)));
                break;
            }
            case 110: {
                addSelf = true;
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getNumbers(treeNodeBuf.getAllChildren(1)));
                break;
            }
        }
        if (addSelf && !TreeStructureServiceHelper.isRootEntityNodeId(entityId, type)) {
            resultList.add(number);
        }
        return resultList;
    }

    Set<Long> getTemplateIdSet(Object modelid, Long orgId, boolean isCheckPerm) {
        Long valueId;
        HashSet<Long> templateIds = new HashSet<Long>();
        DynamicObject[] distColl = this.queryDistributeCollectionByTemplate(null, modelid);
        HashSet<Long> entityIds = new HashSet<Long>();
        for (DynamicObject dd : distColl) {
            valueId = dd.getLong("entity.id");
            if (valueId == 0L) continue;
            entityIds.add(valueId);
        }
        HashMap<Long, DynamicObject> entitys = new HashMap<Long, DynamicObject>();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"epm_entitymembertree");
        if (!entityIds.isEmpty()) {
            for (DynamicObject entity : BusinessDataServiceHelper.loadFromCache((String)"epm_entitymembertree", (String)"id,number,longnumber,parent,isleaf,isexchangerate", (QFilter[])new QFilter("id", "in", entityIds).toArray()).values()) {
                entitys.put(entity.getLong("id"), entity);
            }
        }
        for (DynamicObject dd : distColl) {
            int range = dd.getInt("memrangdecombo");
            valueId = dd.getLong("entity.id");
            if (valueId == 0L || !this.chooseMethodByRange(range, org, (DynamicObject)entitys.get(valueId), "parent.id") || dd.getLong("template.id") == 0L) continue;
            templateIds.add(dd.getLong("template.id"));
        }
        return templateIds;
    }

    private boolean isOrgRootMember(Long entityid, DetailTypeEnum type) {
        if (DetailTypeEnum.TEMPLATEDIS == type) {
            QFilter filter = new QFilter("id", "=", (Object)entityid);
            QFilter filter2 = new QFilter("number", "=", (Object)DimTypesEnum.ENTITY.getNumber());
            return QueryServiceHelper.exists((String)"epm_entitymembertree", (QFilter[])new QFilter[]{filter, filter2});
        }
        return false;
    }

    private void removeSelf(List<DynamicObject> result, Long id) {
        for (DynamicObject dot : result) {
            if (!id.equals(dot.getLong("id"))) continue;
            result.remove(dot);
            break;
        }
    }

    private void getMemberListByLevelAndDseq(List<DynamicObject> result, List<DynamicObject> dots, String rootId, int scope) {
        TreeNode root = new TreeNode("root", null);
        root = this.getTree(dots, root, rootId);
        if (scope == 40) {
            this.scan(root, result);
            result.remove(0);
        } else if (scope == 50) {
            this.scan(root, result);
        } else if (scope == 90) {
            this.scanOnlyLeaf(root, result, true);
        } else if (scope == 110) {
            this.scanOnlyLeaf(root, result, false);
        }
    }

    private void scan(TreeNode b, List<DynamicObject> result) {
        result.add(b.getData());
        for (TreeNode child : b.getChildren()) {
            this.scan(child, result);
        }
    }

    private void scanOnlyLeaf(TreeNode b, List<DynamicObject> result, boolean onlyLeaf) {
        if (onlyLeaf) {
            if (b.getChildren().isEmpty()) {
                result.add(b.getData());
            }
        } else if (!b.getChildren().isEmpty()) {
            result.add(b.getData());
        }
        for (TreeNode child : b.getChildren()) {
            this.scanOnlyLeaf(child, result, onlyLeaf);
        }
    }

    public TreeNode getTree(List<DynamicObject> rootNodeList, TreeNode root, String parentId) {
        return this.getDimensionTreeRoot(false, rootNodeList, root, parentId);
    }

    private TreeNode getDimensionTreeRoot(boolean ishaveroot, List<DynamicObject> rootNodeList, TreeNode parent, String parentId) {
        for (DynamicObject map : rootNodeList) {
            if (!ishaveroot) {
                if (map.getDynamicObject("parent") != null && !map.getDynamicObject("parent").getString("id").equals(parentId)) continue;
                parent = new TreeNode(map.getString("id"), map);
                parent.setParent(null);
                this.getDimensionTreeRoot(true, rootNodeList, parent, parentId);
                continue;
            }
            if (map == null || map.getDynamicObject("parent") == null || !map.getDynamicObject("parent").getString("id").equals(parent.getId())) continue;
            TreeNode child = new TreeNode(map.getString("id"), map);
            child.setParent(parent);
            parent.addChild(child);
            this.getDimensionTreeRoot(true, rootNodeList, child, parentId);
        }
        return parent;
    }

    static {
        selectFields1 = new String[]{"id", "storagetype", "member.id"};
        selectFields2 = new String[]{"propertyid", "propertyid.name", "propertyid.number", "propertyid.propertyn"};
        selectFields3 = new String[]{"id", "number", "longnumber", "parentid", "propertyid.propertyn"};
        selectFields4 = new String[]{"id", "number", "longnumber", "parentid"};
    }

    static class TreeNode {
        private String id;
        private TreeNode parent;
        private List<TreeNode> children = new ArrayList<TreeNode>();
        private DynamicObject data;

        public TreeNode(String id, DynamicObject dot) {
            this.id = id;
            this.data = dot;
        }

        public String getId() {
            return this.id;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public void setParent(TreeNode parent) {
            this.parent = parent;
        }

        public List<TreeNode> getChildren() {
            return this.children;
        }

        public void addChild(TreeNode child) {
            this.children.add(child);
            child.setParent(this);
        }

        public DynamicObject getData() {
            return this.data;
        }
    }
}

